
package com.github.testpress.mikephil.charting.data;

import android.util.Log;

import com.github.testpress.mikephil.charting.highlight.Highlight;
import com.github.testpress.mikephil.charting.interfaces.datasets.IBarLineScatterCandleBubbleDataSet;

import java.util.ArrayList;
import java.util.List;

/**
 * Data object that allows the combination of Line-, Bar-, Scatter-, Bubble- and
 * CandleData. Used in the CombinedChart class.
 *
 * @author Philipp Jahoda
 */
public class CombinedData extends com.github.testpress.mikephil.charting.data.BarLineScatterCandleBubbleData<IBarLineScatterCandleBubbleDataSet<? extends Entry>> {

    private com.github.testpress.mikephil.charting.data.LineData mLineData;
    private com.github.testpress.mikephil.charting.data.BarData mBarData;
    private com.github.testpress.mikephil.charting.data.ScatterData mScatterData;
    private com.github.testpress.mikephil.charting.data.CandleData mCandleData;
    private BubbleData mBubbleData;

    public CombinedData() {
        super();
    }

    public void setData(com.github.testpress.mikephil.charting.data.LineData data) {
        mLineData = data;
        init();
    }

    public void setData(com.github.testpress.mikephil.charting.data.BarData data) {
        mBarData = data;
        init();
    }

    public void setData(com.github.testpress.mikephil.charting.data.ScatterData data) {
        mScatterData = data;
        init();
    }

    public void setData(com.github.testpress.mikephil.charting.data.CandleData data) {
        mCandleData = data;
        init();
    }

    public void setData(BubbleData data) {
        mBubbleData = data;
        init();
    }

    @Override
    public void calcMinMax() {

        if(mDataSets == null){
            mDataSets = new ArrayList<>();
        }
        mDataSets.clear();

        mYMax = -Float.MAX_VALUE;
        mYMin = Float.MAX_VALUE;
        mXMax = -Float.MAX_VALUE;
        mXMin = Float.MAX_VALUE;

        mLeftAxisMax = -Float.MAX_VALUE;
        mLeftAxisMin = Float.MAX_VALUE;
        mRightAxisMax = -Float.MAX_VALUE;
        mRightAxisMin = Float.MAX_VALUE;

        List<com.github.testpress.mikephil.charting.data.BarLineScatterCandleBubbleData> allData = getAllData();

        for (com.github.testpress.mikephil.charting.data.ChartData data : allData) {

            data.calcMinMax();

            List<IBarLineScatterCandleBubbleDataSet<? extends Entry>> sets = data.getDataSets();
            mDataSets.addAll(sets);

            if (data.getYMax() > mYMax)
                mYMax = data.getYMax();

            if (data.getYMin() < mYMin)
                mYMin = data.getYMin();

            if (data.getXMax() > mXMax)
                mXMax = data.getXMax();

            if (data.getXMin() < mXMin)
                mXMin = data.getXMin();

            if (data.mLeftAxisMax > mLeftAxisMax)
                mLeftAxisMax = data.mLeftAxisMax;

            if (data.mLeftAxisMin < mLeftAxisMin)
                mLeftAxisMin = data.mLeftAxisMin;

            if (data.mRightAxisMax > mRightAxisMax)
                mRightAxisMax = data.mRightAxisMax;

            if (data.mRightAxisMin < mRightAxisMin)
                mRightAxisMin = data.mRightAxisMin;

        }

    }

    public BubbleData getBubbleData() {
        return mBubbleData;
    }

    public com.github.testpress.mikephil.charting.data.LineData getLineData() {
        return mLineData;
    }

    public com.github.testpress.mikephil.charting.data.BarData getBarData() {
        return mBarData;
    }

    public com.github.testpress.mikephil.charting.data.ScatterData getScatterData() {
        return mScatterData;
    }

    public com.github.testpress.mikephil.charting.data.CandleData getCandleData() {
        return mCandleData;
    }

    /**
     * Returns all data objects in row: line-bar-scatter-candle-bubble if not null.
     *
     * @return
     */
    public List<com.github.testpress.mikephil.charting.data.BarLineScatterCandleBubbleData> getAllData() {

        List<com.github.testpress.mikephil.charting.data.BarLineScatterCandleBubbleData> data = new ArrayList<com.github.testpress.mikephil.charting.data.BarLineScatterCandleBubbleData>();
        if (mLineData != null)
            data.add(mLineData);
        if (mBarData != null)
            data.add(mBarData);
        if (mScatterData != null)
            data.add(mScatterData);
        if (mCandleData != null)
            data.add(mCandleData);
        if (mBubbleData != null)
            data.add(mBubbleData);

        return data;
    }

    public com.github.testpress.mikephil.charting.data.BarLineScatterCandleBubbleData getDataByIndex(int index) {
        return getAllData().get(index);
    }

    @Override
    public void notifyDataChanged() {
        if (mLineData != null)
            mLineData.notifyDataChanged();
        if (mBarData != null)
            mBarData.notifyDataChanged();
        if (mCandleData != null)
            mCandleData.notifyDataChanged();
        if (mScatterData != null)
            mScatterData.notifyDataChanged();
        if (mBubbleData != null)
            mBubbleData.notifyDataChanged();

        init(); // recalculate everything
    }

    /**
     * Get the Entry for a corresponding highlight object
     *
     * @param highlight
     * @return the entry that is highlighted
     */
    @Override
    public Entry getEntryForHighlight(Highlight highlight) {

        List<com.github.testpress.mikephil.charting.data.BarLineScatterCandleBubbleData> dataObjects = getAllData();

        if (highlight.getDataIndex() >= dataObjects.size())
            return null;

        com.github.testpress.mikephil.charting.data.ChartData data = dataObjects.get(highlight.getDataIndex());

        if (highlight.getDataSetIndex() >= data.getDataSetCount())
            return null;
        else {
            // The value of the highlighted entry could be NaN -
            //   if we are not interested in highlighting a specific value.

            List<Entry> entries = data.getDataSetByIndex(highlight.getDataSetIndex())
                    .getEntriesForXPos(highlight.getX());
            for (Entry entry : entries)
                if (entry.getY() == highlight.getY() ||
                        Float.isNaN(highlight.getY()))
                    return entry;

            return null;
        }
    }

    public int getDataIndex(com.github.testpress.mikephil.charting.data.ChartData data) {
        return getAllData().indexOf(data);
    }

    @Override
    public boolean removeDataSet(IBarLineScatterCandleBubbleDataSet<? extends Entry> d) {

        List<com.github.testpress.mikephil.charting.data.BarLineScatterCandleBubbleData> datas = getAllData();

        boolean success = false;

        for (com.github.testpress.mikephil.charting.data.ChartData data : datas) {

            success = data.removeDataSet(d);

            if (success) {
                break;
            }
        }

        return success;
    }

    @Deprecated
    @Override
    public boolean removeDataSet(int index) {
        Log.e("MPAndroidChart", "removeDataSet(int index) not supported for CombinedData");
        return false;
    }

    @Deprecated
    @Override
    public boolean removeEntry(Entry e, int dataSetIndex) {
        Log.e("MPAndroidChart", "removeEntry(...) not supported for CombinedData");
        return false;
    }

    @Deprecated
    @Override
    public boolean removeEntry(float xPos, int dataSetIndex) {
        Log.e("MPAndroidChart", "removeEntry(...) not supported for CombinedData");
        return false;
    }
}
