/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import com.github.mikephil.charting.animation.ChartAnimator;
import com.github.mikephil.charting.buffer.ScatterBuffer;
import com.github.mikephil.charting.charts.ScatterChart;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.data.ScatterData;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.interfaces.dataprovider.ScatterDataProvider;
import com.github.mikephil.charting.interfaces.datasets.IScatterDataSet;
import com.github.mikephil.charting.renderer.LineScatterCandleRadarRenderer;
import com.github.mikephil.charting.utils.Transformer;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.ViewPortHandler;
import java.util.List;

public class ScatterChartRenderer
extends LineScatterCandleRadarRenderer {
    protected ScatterDataProvider mChart;
    protected ScatterBuffer[] mScatterBuffers;

    public ScatterChartRenderer(ScatterDataProvider chart, ChartAnimator animator, ViewPortHandler viewPortHandler) {
        super(animator, viewPortHandler);
        this.mChart = chart;
    }

    @Override
    public void initBuffers() {
        ScatterData scatterData = this.mChart.getScatterData();
        this.mScatterBuffers = new ScatterBuffer[scatterData.getDataSetCount()];
        for (int i = 0; i < this.mScatterBuffers.length; ++i) {
            IScatterDataSet set = (IScatterDataSet)scatterData.getDataSetByIndex(i);
            this.mScatterBuffers[i] = new ScatterBuffer(set.getEntryCount() * 2);
        }
    }

    @Override
    public void drawData(Canvas c) {
        ScatterData scatterData = this.mChart.getScatterData();
        for (IScatterDataSet set : scatterData.getDataSets()) {
            if (!set.isVisible()) continue;
            this.drawDataSet(c, set);
        }
    }

    protected void drawDataSet(Canvas c, IScatterDataSet dataSet) {
        Transformer trans = this.mChart.getTransformer(dataSet.getAxisDependency());
        float phaseX = this.mAnimator.getPhaseX();
        float phaseY = this.mAnimator.getPhaseY();
        float shapeSize = Utils.convertDpToPixel(dataSet.getScatterShapeSize());
        float shapeHalf = shapeSize / 2.0f;
        float shapeHoleSizeHalf = Utils.convertDpToPixel(dataSet.getScatterShapeHoleRadius());
        float shapeHoleSize = shapeHoleSizeHalf * 2.0f;
        int shapeHoleColor = dataSet.getScatterShapeHoleColor();
        float shapeStrokeSize = (shapeSize - shapeHoleSize) / 2.0f;
        float shapeStrokeSizeHalf = shapeStrokeSize / 2.0f;
        ScatterChart.ScatterShape shape = dataSet.getScatterShape();
        ScatterBuffer buffer = this.mScatterBuffers[this.mChart.getScatterData().getIndexOfDataSet(dataSet)];
        buffer.setPhases(phaseX, phaseY);
        buffer.feed(dataSet);
        trans.pointValuesToPixel(buffer.buffer);
        switch (shape) {
            case SQUARE: {
                for (int i = 0; i < buffer.size() && this.mViewPortHandler.isInBoundsRight(buffer.buffer[i]); i += 2) {
                    if (!this.mViewPortHandler.isInBoundsLeft(buffer.buffer[i]) || !this.mViewPortHandler.isInBoundsY(buffer.buffer[i + 1])) continue;
                    this.mRenderPaint.setColor(dataSet.getColor(i / 2));
                    if ((double)shapeHoleSize > 0.0) {
                        this.mRenderPaint.setStyle(Paint.Style.STROKE);
                        this.mRenderPaint.setStrokeWidth(shapeStrokeSize);
                        c.drawRect(buffer.buffer[i] - shapeHoleSizeHalf - shapeStrokeSizeHalf, buffer.buffer[i + 1] - shapeHoleSizeHalf - shapeStrokeSizeHalf, buffer.buffer[i] + shapeHoleSizeHalf + shapeStrokeSizeHalf, buffer.buffer[i + 1] + shapeHoleSizeHalf + shapeStrokeSizeHalf, this.mRenderPaint);
                        if (shapeHoleColor == 0x112233) continue;
                        this.mRenderPaint.setStyle(Paint.Style.FILL);
                        this.mRenderPaint.setColor(shapeHoleColor);
                        c.drawRect(buffer.buffer[i] - shapeHoleSizeHalf, buffer.buffer[i + 1] - shapeHoleSizeHalf, buffer.buffer[i] + shapeHoleSizeHalf, buffer.buffer[i + 1] + shapeHoleSizeHalf, this.mRenderPaint);
                        continue;
                    }
                    this.mRenderPaint.setStyle(Paint.Style.FILL);
                    c.drawRect(buffer.buffer[i] - shapeHalf, buffer.buffer[i + 1] - shapeHalf, buffer.buffer[i] + shapeHalf, buffer.buffer[i + 1] + shapeHalf, this.mRenderPaint);
                }
                break;
            }
            case CIRCLE: {
                for (int i = 0; i < buffer.size() && this.mViewPortHandler.isInBoundsRight(buffer.buffer[i]); i += 2) {
                    if (!this.mViewPortHandler.isInBoundsLeft(buffer.buffer[i]) || !this.mViewPortHandler.isInBoundsY(buffer.buffer[i + 1])) continue;
                    this.mRenderPaint.setColor(dataSet.getColor(i / 2));
                    if ((double)shapeHoleSize > 0.0) {
                        this.mRenderPaint.setStyle(Paint.Style.STROKE);
                        this.mRenderPaint.setStrokeWidth(shapeStrokeSize);
                        c.drawCircle(buffer.buffer[i], buffer.buffer[i + 1], shapeHoleSizeHalf + shapeStrokeSizeHalf, this.mRenderPaint);
                        if (shapeHoleColor == 0x112233) continue;
                        this.mRenderPaint.setStyle(Paint.Style.FILL);
                        this.mRenderPaint.setColor(shapeHoleColor);
                        c.drawCircle(buffer.buffer[i], buffer.buffer[i + 1], shapeHoleSizeHalf, this.mRenderPaint);
                        continue;
                    }
                    this.mRenderPaint.setStyle(Paint.Style.FILL);
                    c.drawCircle(buffer.buffer[i], buffer.buffer[i + 1], shapeHalf, this.mRenderPaint);
                }
                break;
            }
            case TRIANGLE: {
                this.mRenderPaint.setStyle(Paint.Style.FILL);
                Path tri = new Path();
                for (int i = 0; i < buffer.size() && this.mViewPortHandler.isInBoundsRight(buffer.buffer[i]); i += 2) {
                    if (!this.mViewPortHandler.isInBoundsLeft(buffer.buffer[i]) || !this.mViewPortHandler.isInBoundsY(buffer.buffer[i + 1])) continue;
                    this.mRenderPaint.setColor(dataSet.getColor(i / 2));
                    tri.moveTo(buffer.buffer[i], buffer.buffer[i + 1] - shapeHalf);
                    tri.lineTo(buffer.buffer[i] + shapeHalf, buffer.buffer[i + 1] + shapeHalf);
                    tri.lineTo(buffer.buffer[i] - shapeHalf, buffer.buffer[i + 1] + shapeHalf);
                    if ((double)shapeHoleSize > 0.0) {
                        tri.lineTo(buffer.buffer[i], buffer.buffer[i + 1] - shapeHalf);
                        tri.moveTo(buffer.buffer[i] - shapeHalf + shapeStrokeSize, buffer.buffer[i + 1] + shapeHalf - shapeStrokeSize);
                        tri.lineTo(buffer.buffer[i] + shapeHalf - shapeStrokeSize, buffer.buffer[i + 1] + shapeHalf - shapeStrokeSize);
                        tri.lineTo(buffer.buffer[i], buffer.buffer[i + 1] - shapeHalf + shapeStrokeSize);
                        tri.lineTo(buffer.buffer[i] - shapeHalf + shapeStrokeSize, buffer.buffer[i + 1] + shapeHalf - shapeStrokeSize);
                    }
                    tri.close();
                    c.drawPath(tri, this.mRenderPaint);
                    tri.reset();
                    if (!((double)shapeHoleSize > 0.0) || shapeHoleColor == 0x112233) continue;
                    this.mRenderPaint.setColor(shapeHoleColor);
                    tri.moveTo(buffer.buffer[i], buffer.buffer[i + 1] - shapeHalf + shapeStrokeSize);
                    tri.lineTo(buffer.buffer[i] + shapeHalf - shapeStrokeSize, buffer.buffer[i + 1] + shapeHalf - shapeStrokeSize);
                    tri.lineTo(buffer.buffer[i] - shapeHalf + shapeStrokeSize, buffer.buffer[i + 1] + shapeHalf - shapeStrokeSize);
                    tri.close();
                    c.drawPath(tri, this.mRenderPaint);
                    tri.reset();
                }
                break;
            }
            case CROSS: {
                this.mRenderPaint.setStyle(Paint.Style.STROKE);
                this.mRenderPaint.setStrokeWidth(Utils.convertDpToPixel(1.0f));
                for (int i = 0; i < buffer.size() && this.mViewPortHandler.isInBoundsRight(buffer.buffer[i]); i += 2) {
                    if (!this.mViewPortHandler.isInBoundsLeft(buffer.buffer[i]) || !this.mViewPortHandler.isInBoundsY(buffer.buffer[i + 1])) continue;
                    this.mRenderPaint.setColor(dataSet.getColor(i / 2));
                    c.drawLine(buffer.buffer[i] - shapeHalf, buffer.buffer[i + 1], buffer.buffer[i] + shapeHalf, buffer.buffer[i + 1], this.mRenderPaint);
                    c.drawLine(buffer.buffer[i], buffer.buffer[i + 1] - shapeHalf, buffer.buffer[i], buffer.buffer[i + 1] + shapeHalf, this.mRenderPaint);
                }
                break;
            }
            case X: {
                this.mRenderPaint.setStyle(Paint.Style.STROKE);
                this.mRenderPaint.setStrokeWidth(Utils.convertDpToPixel(1.0f));
                for (int i = 0; i < buffer.size() && this.mViewPortHandler.isInBoundsRight(buffer.buffer[i]); i += 2) {
                    if (!this.mViewPortHandler.isInBoundsLeft(buffer.buffer[i]) || !this.mViewPortHandler.isInBoundsY(buffer.buffer[i + 1])) continue;
                    this.mRenderPaint.setColor(dataSet.getColor(i / 2));
                    c.drawLine(buffer.buffer[i] - shapeHalf, buffer.buffer[i + 1] - shapeHalf, buffer.buffer[i] + shapeHalf, buffer.buffer[i + 1] + shapeHalf, this.mRenderPaint);
                    c.drawLine(buffer.buffer[i] + shapeHalf, buffer.buffer[i + 1] - shapeHalf, buffer.buffer[i] - shapeHalf, buffer.buffer[i + 1] + shapeHalf, this.mRenderPaint);
                }
                break;
            }
        }
    }

    @Override
    public void drawValues(Canvas c) {
        if ((float)this.mChart.getScatterData().getYValCount() < (float)this.mChart.getMaxVisibleCount() * this.mViewPortHandler.getScaleX()) {
            List dataSets = this.mChart.getScatterData().getDataSets();
            for (int i = 0; i < this.mChart.getScatterData().getDataSetCount(); ++i) {
                IScatterDataSet dataSet = (IScatterDataSet)dataSets.get(i);
                if (!dataSet.isDrawValuesEnabled() || dataSet.getEntryCount() == 0) continue;
                this.applyValueTextStyle(dataSet);
                float[] positions = this.mChart.getTransformer(dataSet.getAxisDependency()).generateTransformedValuesScatter(dataSet, this.mAnimator.getPhaseY());
                float shapeSize = Utils.convertDpToPixel(dataSet.getScatterShapeSize());
                int j = 0;
                while ((float)j < (float)positions.length * this.mAnimator.getPhaseX() && this.mViewPortHandler.isInBoundsRight(positions[j])) {
                    if (this.mViewPortHandler.isInBoundsLeft(positions[j]) && this.mViewPortHandler.isInBoundsY(positions[j + 1])) {
                        Object entry = dataSet.getEntryForIndex(j / 2);
                        this.drawValue(c, dataSet.getValueFormatter(), ((Entry)entry).getVal(), (Entry)entry, i, positions[j], positions[j + 1] - shapeSize, dataSet.getValueTextColor(j / 2));
                    }
                    j += 2;
                }
            }
        }
    }

    @Override
    public void drawExtras(Canvas c) {
    }

    @Override
    public void drawHighlighted(Canvas c, Highlight[] indices) {
        for (int i = 0; i < indices.length; ++i) {
            float yVal;
            int xIndex;
            IScatterDataSet set = (IScatterDataSet)this.mChart.getScatterData().getDataSetByIndex(indices[i].getDataSetIndex());
            if (set == null || !set.isHighlightEnabled() || (float)(xIndex = indices[i].getXIndex()) > this.mChart.getXChartMax() * this.mAnimator.getPhaseX() || (yVal = set.getYValForXIndex(xIndex)) == Float.NaN) continue;
            float y = yVal * this.mAnimator.getPhaseY();
            float[] pts = new float[]{xIndex, y};
            this.mChart.getTransformer(set.getAxisDependency()).pointValuesToPixel(pts);
            this.drawHighlightLines(c, pts, set);
        }
    }
}

