/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.highlight;

import com.github.mikephil.charting.components.YAxis;
import com.github.mikephil.charting.highlight.BarHighlighter;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.interfaces.dataprovider.BarDataProvider;
import com.github.mikephil.charting.interfaces.datasets.IBarDataSet;

public class HorizontalBarHighlighter
extends BarHighlighter {
    public HorizontalBarHighlighter(BarDataProvider chart) {
        super(chart);
    }

    @Override
    public Highlight getHighlight(float x, float y) {
        Highlight h = super.getHighlight(x, y);
        if (h == null) {
            return h;
        }
        IBarDataSet set = (IBarDataSet)((BarDataProvider)this.mChart).getBarData().getDataSetByIndex(h.getDataSetIndex());
        if (set.isStacked()) {
            float[] pts = new float[2];
            pts[0] = y;
            ((BarDataProvider)this.mChart).getTransformer(set.getAxisDependency()).pixelsToValue(pts);
            return this.getStackedHighlight(h, set, h.getXIndex(), h.getDataSetIndex(), pts[0]);
        }
        return h;
    }

    @Override
    protected int getXIndex(float x) {
        if (!((BarDataProvider)this.mChart).getBarData().isGrouped()) {
            float[] pts = new float[2];
            pts[1] = x;
            ((BarDataProvider)this.mChart).getTransformer(YAxis.AxisDependency.LEFT).pixelsToValue(pts);
            return Math.round(pts[1]);
        }
        float baseNoSpace = this.getBase(x);
        int setCount = ((BarDataProvider)this.mChart).getBarData().getDataSetCount();
        int xIndex = (int)baseNoSpace / setCount;
        int valCount = ((BarDataProvider)this.mChart).getData().getXValCount();
        if (xIndex < 0) {
            xIndex = 0;
        } else if (xIndex >= valCount) {
            xIndex = valCount - 1;
        }
        return xIndex;
    }

    @Override
    protected float getBase(float y) {
        float[] pts = new float[2];
        pts[1] = y;
        ((BarDataProvider)this.mChart).getTransformer(YAxis.AxisDependency.LEFT).pixelsToValue(pts);
        float yVal = pts[1];
        int setCount = ((BarDataProvider)this.mChart).getBarData().getDataSetCount();
        int steps = (int)(yVal / ((float)setCount + ((BarDataProvider)this.mChart).getBarData().getGroupSpace()));
        float groupSpaceSum = ((BarDataProvider)this.mChart).getBarData().getGroupSpace() * (float)steps;
        float baseNoSpace = yVal - groupSpaceSum;
        return baseNoSpace;
    }
}

