/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.highlight;

import com.github.mikephil.charting.data.ChartData;
import com.github.mikephil.charting.data.CombinedData;
import com.github.mikephil.charting.highlight.ChartHighlighter;
import com.github.mikephil.charting.interfaces.dataprovider.BarLineScatterCandleBubbleDataProvider;
import com.github.mikephil.charting.interfaces.datasets.IDataSet;
import com.github.mikephil.charting.utils.SelectionDetail;
import java.util.ArrayList;
import java.util.List;

public class CombinedHighlighter
extends ChartHighlighter<BarLineScatterCandleBubbleDataProvider> {
    public CombinedHighlighter(BarLineScatterCandleBubbleDataProvider chart) {
        super(chart);
    }

    @Override
    protected List<SelectionDetail> getSelectionDetailsAtIndex(int xIndex) {
        CombinedData data = (CombinedData)this.mChart.getData();
        List<ChartData> dataObjects = data.getAllData();
        ArrayList<SelectionDetail> vals = new ArrayList<SelectionDetail>();
        float[] pts = new float[2];
        for (int i = 0; i < dataObjects.size(); ++i) {
            for (int j = 0; j < dataObjects.get(i).getDataSetCount(); ++j) {
                float yVal;
                Object dataSet = dataObjects.get(i).getDataSetByIndex(j);
                if (!dataSet.isHighlightEnabled() || (yVal = dataSet.getYValForXIndex(xIndex)) == Float.NaN) continue;
                pts[1] = yVal;
                this.mChart.getTransformer(dataSet.getAxisDependency()).pointValuesToPixel(pts);
                if (Float.isNaN(pts[1])) continue;
                vals.add(new SelectionDetail(pts[1], j, (IDataSet)dataSet));
            }
        }
        return vals;
    }
}

