/*
 * Decompiled with CFR 0.152.
 */
package net.christophschubert.cp.testcontainers.util;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class Tag
implements Comparable<Tag> {
    private final List<Integer> parts;

    public Tag(List<Integer> parts) {
        this.parts = parts;
    }

    public Tag(String tag) {
        this.parts = Arrays.stream(tag.split(Pattern.quote("."))).map(Integer::parseInt).collect(Collectors.toList());
    }

    @Override
    public int compareTo(Tag o) {
        Iterator<Integer> thisIterator = this.parts.iterator();
        Iterator<Integer> otherIterator = o.parts.iterator();
        while (thisIterator.hasNext() || otherIterator.hasNext()) {
            Integer otherValue;
            Integer thisValue = thisIterator.hasNext() ? thisIterator.next() : Integer.valueOf(0);
            int cmp = thisValue.compareTo(otherValue = otherIterator.hasNext() ? otherIterator.next() : Integer.valueOf(0));
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    public boolean atLeast(Tag minVersion) {
        return this.compareTo(minVersion) >= 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tag tag = (Tag)o;
        return Objects.equals(this.parts, tag.parts);
    }

    public int hashCode() {
        return Objects.hash(this.parts);
    }

    public String toString() {
        return "Tag{parts=" + this.parts + "}";
    }
}

