/*
 * Decompiled with CFR 0.152.
 */
package net.christophschubert.cp.testcontainers;

import java.time.Duration;
import java.util.Objects;
import net.christophschubert.cp.testcontainers.CPTestContainer;
import net.christophschubert.cp.testcontainers.ConfluentServerContainer;
import net.christophschubert.cp.testcontainers.SecurityConfigs;
import org.testcontainers.containers.KafkaContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;

public class SchemaRegistryContainer
extends CPTestContainer<SchemaRegistryContainer> {
    static final int defaultPort = 8081;
    private String clusterId = "schema-registry";
    private String schemasTopic = "_schemas";

    SchemaRegistryContainer(DockerImageName imageName, KafkaContainer bootstrap, Network network) {
        super(imageName, bootstrap, network, 8081, "SCHEMA_REGISTRY");
        this.waitingFor((WaitStrategy)Wait.forHttp((String)"/subjects").forStatusCodeMatching(it -> it >= 200 && it < 300 || it == 401));
        this.withStartupTimeout(Duration.ofMinutes(2L));
        this.withProperty("host.name", "schema-registry");
        this.withProperty("kafkastore.bootstrap.servers", SchemaRegistryContainer.getInternalBootstrap(bootstrap));
        this.withProperty("listeners", this.getHttpPortListener());
    }

    public SchemaRegistryContainer withClusterId(String clusterId) {
        Objects.requireNonNull(clusterId);
        this.clusterId = clusterId;
        this.withProperty("schema.registry.group.id", clusterId);
        return this;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public SchemaRegistryContainer withSchemasTopic(String schemasTopic) {
        Objects.requireNonNull(schemasTopic);
        this.schemasTopic = schemasTopic;
        this.withProperty("kafkastore.topic", schemasTopic);
        return this;
    }

    public String getSchemasTopic() {
        return this.schemasTopic;
    }

    public SchemaRegistryContainer enableRbac() {
        if (!(this.bootstrap instanceof ConfluentServerContainer)) {
            throw new IllegalStateException("rbac requires a ConfluentServerContainer as bootstrap");
        }
        return this.enableRbac(((ConfluentServerContainer)this.bootstrap).getMdsUrl(), "sr-user", "sr-user-secret");
    }

    public SchemaRegistryContainer enableRbac(String mdsBootstrap, String srPrincipal, String srSecret) {
        this.prepareCertificates();
        this.withEnv("CUB_CLASSPATH", "/usr/share/java/confluent-security/schema-registry/*:/usr/share/java/schema-registry/*:/usr/share/java/cp-base-new/*");
        this.withProperties("kafkastore", SecurityConfigs.oAuthWithTokenCallbackHandlerProperties(srPrincipal, srSecret, mdsBootstrap));
        this.withProperty("debug", true);
        this.withProperty("schema.registry.resource.extension.class", "io.confluent.kafka.schemaregistry.security.SchemaRegistrySecurityResourceExtension");
        this.withProperty("confluent.schema.registry.authorizer.class", "io.confluent.kafka.schemaregistry.security.authorizer.rbac.RbacAuthorizer");
        this.withProperty("rest.servlet.initializor.classes", "io.confluent.common.security.jetty.initializer.InstallBearerOrBasicSecurityHandler");
        this.withProperties(SecurityConfigs.confluentMdsSettings(srPrincipal, srSecret, mdsBootstrap));
        this.withProperty("public.key.path", this.getPublicKeyPath());
        return this;
    }

    @Override
    public CPTestContainer<SchemaRegistryContainer> withLogLevel(String logLevel) {
        return this;
    }
}

