/*
 * Decompiled with CFR 0.152.
 */
package com.tejpratapsingh.pdfcreator.utils;

import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Environment;
import android.util.Log;
import android.webkit.MimeTypeMap;
import androidx.annotation.NonNull;
import com.tejpratapsingh.pdfcreator.utils.Utilities;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLConnection;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.Locale;

public class FileManager {
    private final String tempDirectoryName = "temp";
    private final String tempDuplicateFileNameSuffix = "dup";
    private final String DOCUMENT_THUMBNAIL_SUFFIX = "-thumb.jpeg";
    private final int IMAGE_DOCUMENT_MAX_THUMBNAIL_SIZE = 50;
    private static FileManager instance;

    private FileManager() {
    }

    public static FileManager getInstance() {
        if (instance == null) {
            instance = new FileManager();
        }
        return instance;
    }

    public File saveFileToPrivateStorageFromInputStream(Context context, InputStream inputStream, String fileName, boolean overWriteIfExist, boolean createThumbnail) throws Exception, IOException {
        boolean isFileAlreadyExist;
        this.makeDirectoryInPrivateStorage(context, fileName.substring(0, fileName.indexOf("/")));
        File fileToSave = new File(context.getExternalFilesDir(null), fileName);
        if (!overWriteIfExist && (isFileAlreadyExist = this.hasExternalStoragePrivateFile(context, fileName))) {
            throw new Exception("File Already Exists, make it overWritable to replace.");
        }
        FileOutputStream fileOutput = new FileOutputStream(fileToSave);
        byte[] buffer = new byte[1024];
        int bufferLength = 0;
        while ((bufferLength = inputStream.read(buffer)) > 0) {
            fileOutput.write(buffer, 0, bufferLength);
        }
        fileOutput.flush();
        fileOutput.close();
        inputStream.close();
        String fileMimeType = this.getMimeType(context, fileToSave);
        if (fileMimeType == null) {
            fileMimeType = "";
        }
        if (createThumbnail && fileMimeType.split("/")[0].equals("image")) {
            try {
                File thumbNailFile = new File(fileToSave.getAbsolutePath() + "-thumb.jpeg");
                if (!thumbNailFile.exists()) {
                    Bitmap thumbnailBitmap = this.crateThumbnail(fileToSave, 50);
                    FileOutputStream out = new FileOutputStream(thumbNailFile);
                    thumbnailBitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)out);
                    out.flush();
                    ((OutputStream)out).close();
                }
            }
            catch (IOException e) {
                Log.e((String)"ExternalStorage", (String)"Error writing thumbnail");
                throw e;
            }
        }
        return fileToSave;
    }

    public File saveStringToFile(File fileToWrite, String dataToWrite) throws Exception {
        try {
            FileWriter fw = new FileWriter(fileToWrite);
            fw.write(dataToWrite);
            fw.close();
            return fileToWrite;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Exception(e.getMessage());
        }
    }

    public boolean deleteExternalStoragePrivateFile(Context context, String fileName) throws Exception {
        File file = new File(context.getExternalFilesDir(null), fileName);
        if (file != null) {
            boolean fileDeleted = file.delete();
            File thumbFile = new File(file.getAbsolutePath() + "-thumb.jpeg");
            if (fileDeleted && thumbFile.exists()) {
                thumbFile.delete();
            }
            return true;
        }
        throw new Exception("File does not exist.");
    }

    public boolean hasExternalStoragePrivateFile(Context context, String fileName) {
        File file = new File(context.getExternalFilesDir(null), fileName);
        if (file != null) {
            return file.exists();
        }
        return false;
    }

    public File[] listExternalStoragePrivateFile(Context context) {
        String path = context.getExternalFilesDir(null) + "";
        Log.d((String)"Files", (String)("Path: " + path));
        File directory = new File(path);
        return directory.listFiles();
    }

    public String getFileUrlFromExternalStoragePrivateFile(Context context, String fileName) throws Exception {
        if (this.hasExternalStoragePrivateFile(context, fileName)) {
            return context.getExternalFilesDir(null) + File.separator + fileName;
        }
        throw new Exception("No File Found");
    }

    public Bitmap crateThumbnail(File file, int size) throws Exception {
        try {
            BitmapFactory.Options o = new BitmapFactory.Options();
            o.inJustDecodeBounds = true;
            BitmapFactory.decodeFile((String)file.getAbsolutePath(), (BitmapFactory.Options)o);
            int scale = 1;
            while (o.outWidth / scale / 2 >= size && o.outHeight / scale / 2 >= size) {
                scale *= 2;
            }
            BitmapFactory.Options o2 = new BitmapFactory.Options();
            o2.inSampleSize = scale;
            return BitmapFactory.decodeFile((String)file.getAbsolutePath(), (BitmapFactory.Options)o2);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new Exception(e.getMessage());
        }
    }

    public String getThumbnailFileUrlFromExternalStoragePrivateFile(Context context, String fileName) throws Exception {
        if (this.hasExternalStoragePrivateFile(context, fileName + "-thumb.jpeg")) {
            return context.getExternalFilesDir(null) + File.separator + fileName + "-thumb.jpeg";
        }
        throw new Exception("No File Found");
    }

    public String getMimeType(Context context, @NonNull File file) {
        String type = null;
        String extension = MimeTypeMap.getFileExtensionFromUrl((String)file.getAbsolutePath());
        if (extension != null) {
            type = MimeTypeMap.getSingleton().getMimeTypeFromExtension(extension);
        }
        if (type == null) {
            try {
                type = file.toURI().toURL().openConnection().getContentType();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (type == null) {
            type = context.getContentResolver().getType(Uri.fromFile((File)file));
        }
        if (type == null) {
            type = URLConnection.guessContentTypeFromName(file.getName());
        }
        if (type == null) {
            type = "";
        }
        return type;
    }

    public String getFileExtension(File sourceFile) {
        if (sourceFile == null || sourceFile.getName().lastIndexOf(".") <= 0) {
            return null;
        }
        String[] fileNameParts = sourceFile.getName().split("\\.");
        Log.d((String)"AddNewDocumentActivity", (String)("fileNameParts.length: " + fileNameParts.length));
        Log.d((String)"AddNewDocumentActivity", (String)("getFileExtension: " + fileNameParts[fileNameParts.length - 1]));
        return fileNameParts[fileNameParts.length - 1];
    }

    public File getFileFromURI(Context context, Uri contentUri) {
        try {
            InputStream inputStream = context.getContentResolver().openInputStream(contentUri);
            File fileToSave = this.createTempFile(context, this.getFileExtension(new File(this.getFileName(context, contentUri))), false);
            FileOutputStream fileOutput = new FileOutputStream(fileToSave);
            byte[] buffer = new byte[1024];
            int bufferLength = 0;
            while ((bufferLength = inputStream.read(buffer)) > 0) {
                fileOutput.write(buffer, 0, bufferLength);
            }
            fileOutput.flush();
            fileOutput.close();
            inputStream.close();
            return fileToSave;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFileName(Context context, Uri uri) {
        int cut;
        String result = null;
        if (uri.getScheme().equals("content")) {
            try (Cursor cursor = context.getContentResolver().query(uri, null, null, null, null);){
                if (cursor != null && cursor.moveToFirst()) {
                    result = cursor.getString(cursor.getColumnIndex("_display_name"));
                }
            }
        }
        if (result == null && (cut = (result = uri.getPath()).lastIndexOf(47)) != -1) {
            result = result.substring(cut + 1);
        }
        return result;
    }

    private int getRandomFileDirectory(Context context) throws SecurityException {
        int randomDirectoryName = Utilities.generateRandomNumber(0, 9);
        this.makeDirectoryInPrivateStorage(context, String.valueOf(randomDirectoryName));
        return randomDirectoryName;
    }

    private boolean makeDirectoryInPrivateStorage(Context context, String directoryName) {
        File randomDirectory = new File(context.getExternalFilesDir(null) + File.separator + directoryName);
        if (!randomDirectory.exists()) {
            System.out.println("creating directory: " + directoryName);
            randomDirectory.mkdir();
        }
        return true;
    }

    public String getTempFolder(Context context) {
        File tempDirectory = new File(context.getExternalFilesDir(null) + File.separator + "temp");
        if (!tempDirectory.exists()) {
            System.out.println("creating directory: temp");
            tempDirectory.mkdir();
        }
        return tempDirectory.getAbsolutePath();
    }

    public File createTempFile(Context context, String withExtension, boolean withDuplicate) {
        String tempFileName = Long.toString(new Date().getTime());
        if (withExtension != null && !withExtension.isEmpty()) {
            tempFileName = tempFileName + "." + withExtension;
        }
        File tempFile = new File(this.getTempFolder(context), tempFileName);
        if (withDuplicate) {
            File file = new File(this.getTempFolder(context), tempFileName + "dup");
        }
        return tempFile;
    }

    public File createTempFileWithName(Context context, String tempFileName, boolean withDuplicate) {
        File tempFile = new File(this.getTempFolder(context), tempFileName);
        if (withDuplicate) {
            File file = new File(this.getTempFolder(context), tempFileName + "dup");
        }
        return tempFile;
    }

    public File saveImageToFile(File fileToSave, Bitmap bitmapToSave, Bitmap.CompressFormat compressFormat, boolean createThumbnail) throws Exception, IOException {
        try {
            FileOutputStream out = new FileOutputStream(fileToSave);
            bitmapToSave.compress(compressFormat, 100, (OutputStream)out);
            out.flush();
            ((OutputStream)out).close();
        }
        catch (IOException e) {
            Log.e((String)"ExternalStorage", (String)("Error writing " + fileToSave), (Throwable)e);
            throw new IOException("Error writing " + fileToSave + ", Exception: " + e.getMessage());
        }
        if (createThumbnail) {
            try {
                File thumbNailFile = new File(fileToSave.getAbsolutePath() + "-thumb.jpeg");
                Bitmap thumbnailBitmap = this.crateThumbnail(fileToSave, 50);
                FileOutputStream out = new FileOutputStream(thumbNailFile);
                thumbnailBitmap.compress(compressFormat, 100, (OutputStream)out);
                out.flush();
                ((OutputStream)out).close();
            }
            catch (IOException e) {
                Log.e((String)"ExternalStorage", (String)"Error writing thumbnail");
                throw e;
            }
        }
        return fileToSave;
    }

    public File getTempFile(Context context, String fileName) throws Exception {
        File tempFile = new File(this.getTempFolder(context), fileName);
        if (!tempFile.exists()) {
            throw new Exception("File not found");
        }
        return tempFile;
    }

    public File getTempDuplicateFile(Context context, String fileName) throws Exception {
        File tempDuplicateFile = new File(this.getTempFolder(context), fileName + "dup");
        if (!tempDuplicateFile.exists()) {
            throw new Exception("File not found");
        }
        return tempDuplicateFile;
    }

    public void cleanTempFolder(Context context) {
        File tempDirectory = new File(context.getExternalFilesDir(null) + File.separator + "temp");
        if (tempDirectory.exists()) {
            try {
                for (File f : tempDirectory.listFiles()) {
                    f.delete();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public long getAvailableStorageSpace() {
        return Environment.getExternalStorageDirectory().getFreeSpace();
    }

    public long getTotalStorageSpace() {
        return Environment.getExternalStorageDirectory().getTotalSpace();
    }

    public String getReadableFileSize(long fileSizeInKb) {
        DecimalFormat numberFormat = new DecimalFormat("##.##");
        if (fileSizeInKb < 1024L) {
            return String.format(Locale.getDefault(), "%s KB", numberFormat.format((double)fileSizeInKb));
        }
        if (fileSizeInKb >= 1024L && fileSizeInKb < 0x100000L) {
            return String.format(Locale.getDefault(), "%s MB", numberFormat.format((float)fileSizeInKb / 1024.0f));
        }
        return String.format(Locale.getDefault(), "%s GB", numberFormat.format((float)fileSizeInKb / 1048576.0f));
    }

    public static enum IMAGE_QUALITY implements Serializable
    {
        HIGH(1024),
        MID(512),
        LOW(256);

        private int size;

        private IMAGE_QUALITY(int size) {
            this.size = size;
        }

        public int getSize() {
            return this.size;
        }
    }

    public static enum FILE_TYPE implements Serializable
    {
        IMAGE,
        AUDIO,
        VIDEO,
        PDF,
        TEXT,
        DOC,
        PPT,
        XLS,
        UNKNOWN;

    }
}

