/*
 * Decompiled with CFR 0.152.
 */
package com.tejpratapsingh.pdfcreator.adapter;

import android.content.Context;
import android.graphics.Bitmap;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.github.chrisbanes.photoview.PhotoView;
import com.tejpratapsingh.pdfcreator.R;
import java.util.LinkedList;
import java.util.Locale;

public class RecyclerPdfViewerAdapter
extends RecyclerView.Adapter<ViewHolderPdfPage> {
    private static final String TAG = "RecyclerPdfViewerAdapte";
    private LinkedList<Bitmap> pdfPagesImage = new LinkedList();

    public RecyclerPdfViewerAdapter(@NonNull LinkedList<Bitmap> pdfPagesImage) {
        this.pdfPagesImage.addAll(pdfPagesImage);
    }

    @NonNull
    public ViewHolderPdfPage onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View rootView = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.item_pdf_viewer, parent, false);
        return new ViewHolderPdfPage(rootView);
    }

    public void onBindViewHolder(@NonNull ViewHolderPdfPage holder, int position) {
        Log.d((String)TAG, (String)("onBindViewHolder: rendering: " + position));
        Bitmap currentImage = this.pdfPagesImage.get(position);
        holder.imageView.setImageBitmap(currentImage);
        holder.textViewPageNumber.setText((CharSequence)String.format(Locale.getDefault(), "%d OF %d", position + 1, this.pdfPagesImage.size()));
    }

    public int getItemCount() {
        return this.pdfPagesImage.size();
    }

    static class ViewHolderPdfPage
    extends RecyclerView.ViewHolder {
        PhotoView imageView;
        TextView textViewPageNumber;

        ViewHolderPdfPage(@NonNull View itemView) {
            super(itemView);
            this.imageView = (PhotoView)itemView.findViewById(R.id.imageViewItemPdfViewer);
            this.textViewPageNumber = (TextView)itemView.findViewById(R.id.textViewPdfViewerPageNumber);
        }
    }
}

