/*
 * Decompiled with CFR 0.152.
 */
package com.tejpratapsingh.pdfcreator.activity;

import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.AppCompatTextView;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentStatePagerAdapter;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.github.chrisbanes.photoview.PhotoView;
import com.tejpratapsingh.pdfcreator.R;
import com.tejpratapsingh.pdfcreator.custom.ViewPagerForPhotoView;
import com.tejpratapsingh.pdfcreator.utils.PDFUtil;
import java.io.File;
import java.util.LinkedList;
import java.util.Locale;

public class PDFViewerActivity
extends AppCompatActivity {
    private static final String TAG = "PDFViewerActivity";
    public static final String PDF_FILE_URI = "pdfFileUri";
    private File pdfFile = null;
    private static LinkedList<Bitmap> pdfBitmapList = new LinkedList();

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_pdf_viewer);
        if (!this.getIntent().hasExtra(PDF_FILE_URI)) {
            new IllegalStateException("set PdfViewerActivity.PDF_FILE_URI before using PdfViewerActivity").printStackTrace();
            this.finish();
            return;
        }
        Uri pdfFileUri = (Uri)this.getIntent().getParcelableExtra(PDF_FILE_URI);
        if (pdfFileUri == null || pdfFileUri.getPath() == null) {
            new IllegalStateException("pdf File Uri is null").printStackTrace();
            this.finish();
            return;
        }
        this.pdfFile = new File(pdfFileUri.getPath());
        if (!this.pdfFile.exists()) {
            new IllegalStateException("File Does Not Exist.").printStackTrace();
            this.finish();
            return;
        }
        try {
            pdfBitmapList = PDFUtil.pdfToBitmap(this.pdfFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ViewPagerForPhotoView viewPager = (ViewPagerForPhotoView)this.findViewById(R.id.viewPagerPdfViewer);
        viewPager.setAdapter((PagerAdapter)new PDFViewerPagerAdapter(this.getSupportFragmentManager(), 1));
        viewPager.setPageTransformer(true, new ZoomOutPageTransformer());
    }

    public File getPdfFile() {
        return this.pdfFile;
    }

    private static class ZoomOutPageTransformer
    implements ViewPager.PageTransformer {
        private ZoomOutPageTransformer() {
        }

        public void transformPage(View view, float position) {
            View viewToAnimateUTB = view.findViewById(R.id.textViewPdfViewerPageNumber);
            int pageHeight = view.getHeight();
            if (position < -1.0f) {
                viewToAnimateUTB.setTranslationY(0.0f);
            } else if (position <= 1.0f) {
                viewToAnimateUTB.setTranslationY(Math.abs((float)pageHeight * -position));
            } else {
                viewToAnimateUTB.setTranslationY(0.0f);
            }
        }
    }

    public static class PdfPageFragment
    extends Fragment {
        public static final String ARG_POSITION = "position";

        public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
            View rootView = inflater.inflate(R.layout.item_pdf_viewer, container, false);
            Bundle args = this.getArguments();
            int position = args != null ? args.getInt(ARG_POSITION, 0) : 0;
            Bitmap currentImage = (Bitmap)pdfBitmapList.get(position);
            ((PhotoView)rootView.findViewById(R.id.imageViewItemPdfViewer)).setImageBitmap(currentImage);
            ((AppCompatTextView)rootView.findViewById(R.id.textViewPdfViewerPageNumber)).setText((CharSequence)String.format(Locale.getDefault(), "%d OF %d", position + 1, pdfBitmapList.size()));
            return rootView;
        }

        public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        }
    }

    private static class PDFViewerPagerAdapter
    extends FragmentStatePagerAdapter {
        public PDFViewerPagerAdapter(@NonNull FragmentManager fm, int behavior) {
            super(fm, behavior);
        }

        @NonNull
        public Fragment getItem(int position) {
            PdfPageFragment fragment = new PdfPageFragment();
            Bundle args = new Bundle();
            args.putInt("position", position);
            fragment.setArguments(args);
            return fragment;
        }

        public int getCount() {
            return pdfBitmapList.size();
        }
    }
}

