/*
 * Decompiled with CFR 0.152.
 */
package com.tejpratapsingh.pdfcreator.activity;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.content.ContextCompat;
import com.github.chrisbanes.photoview.PhotoView;
import com.tejpratapsingh.pdfcreator.R;
import com.tejpratapsingh.pdfcreator.utils.FileManager;
import com.tejpratapsingh.pdfcreator.utils.PDFUtil;
import com.tejpratapsingh.pdfcreator.views.PDFBody;
import com.tejpratapsingh.pdfcreator.views.PDFHeaderView;
import com.tejpratapsingh.pdfcreator.views.basic.PDFView;
import java.io.File;
import java.util.ArrayList;
import java.util.Locale;

public abstract class PDFCreatorActivity
extends AppCompatActivity
implements View.OnClickListener {
    private static final String TAG = "PDFCreatorActivity";
    private int headerLayoutHeight = 0;
    private int selectedPreviewPage = 0;
    LinearLayout layoutPageParent;
    LinearLayout layoutPrintPreview;
    TextView textViewGeneratingPDFHolder;
    TextView textViewPageNumber;
    TextView textViewPreviewNotAvailable;
    PhotoView imageViewPDFPreview;
    Button buttonEmailVisit;
    ImageButton buttonNextPage;
    ImageButton buttonPreviousPage;
    ArrayList<Bitmap> pagePreviewBitmapList = new ArrayList();
    File savedPDFFile = null;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_pdfcreator);
        this.layoutPageParent = (LinearLayout)this.findViewById(R.id.layoutPdfPreview);
        this.textViewGeneratingPDFHolder = (TextView)this.findViewById(R.id.textViewPdfGeneratingHolder);
        this.layoutPrintPreview = (LinearLayout)this.findViewById(R.id.layoutPrintPreview);
        this.imageViewPDFPreview = (PhotoView)this.layoutPrintPreview.findViewById(R.id.imagePreviewPdfPrescription);
        this.textViewPageNumber = (TextView)this.layoutPrintPreview.findViewById(R.id.textViewPreviewPageNumber);
        this.textViewPreviewNotAvailable = (TextView)this.layoutPrintPreview.findViewById(R.id.textViewPreviewPDFNotSupported);
        this.layoutPageParent.removeAllViews();
        this.buttonNextPage = (ImageButton)this.layoutPrintPreview.findViewById(R.id.buttonNextPage);
        this.buttonNextPage.setOnClickListener((View.OnClickListener)this);
        this.buttonPreviousPage = (ImageButton)this.layoutPrintPreview.findViewById(R.id.buttonPreviousPage);
        this.buttonPreviousPage.setOnClickListener((View.OnClickListener)this);
        this.buttonEmailVisit = (Button)this.layoutPrintPreview.findViewById(R.id.buttonSendEmail);
        this.buttonEmailVisit.setOnClickListener((View.OnClickListener)this);
    }

    public void createPDF(String fileName, final PDFUtil.PDFUtilListener pdfUtilListener) {
        ArrayList<View> bodyViewList = new ArrayList<View>();
        LinearLayout header = null;
        if (this.getHeaderView(0) != null) {
            header = this.getHeaderView(0).getView();
            header.setTag((Object)PDFHeaderView.class.getSimpleName());
            bodyViewList.add((View)header);
            this.addViewToTempLayout(this.layoutPageParent, (View)header);
        }
        if (this.getBodyViews() != null) {
            for (PDFView pdfView : this.getBodyViews().getChildViewList()) {
                View bodyView = pdfView.getView();
                bodyView.setTag((Object)PDFBody.class.getSimpleName());
                bodyViewList.add(bodyView);
                this.addViewToTempLayout(this.layoutPageParent, bodyView);
            }
        }
        this.createPDFFromViewList((View)header, bodyViewList, fileName, new PDFUtil.PDFUtilListener(){

            @Override
            public void pdfGenerationSuccess(File savedPDFFile) {
                try {
                    PDFCreatorActivity.this.pagePreviewBitmapList.clear();
                    PDFCreatorActivity.this.pagePreviewBitmapList.addAll(PDFUtil.pdfToBitmap(savedPDFFile));
                    PDFCreatorActivity.this.textViewGeneratingPDFHolder.setVisibility(8);
                    PDFCreatorActivity.this.layoutPrintPreview.setVisibility(0);
                    PDFCreatorActivity.this.selectedPreviewPage = 0;
                    PDFCreatorActivity.this.imageViewPDFPreview.setImageBitmap(PDFCreatorActivity.this.pagePreviewBitmapList.get(PDFCreatorActivity.this.selectedPreviewPage));
                    PDFCreatorActivity.this.textViewPageNumber.setText((CharSequence)String.format(Locale.getDefault(), "%d OF %d", PDFCreatorActivity.this.selectedPreviewPage + 1, PDFCreatorActivity.this.pagePreviewBitmapList.size()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    PDFCreatorActivity.this.imageViewPDFPreview.setVisibility(8);
                    PDFCreatorActivity.this.textViewPageNumber.setVisibility(8);
                    PDFCreatorActivity.this.buttonNextPage.setVisibility(8);
                    PDFCreatorActivity.this.buttonPreviousPage.setVisibility(8);
                    PDFCreatorActivity.this.textViewPreviewNotAvailable.setVisibility(0);
                }
                PDFCreatorActivity.this.savedPDFFile = savedPDFFile;
                pdfUtilListener.pdfGenerationSuccess(savedPDFFile);
            }

            @Override
            public void pdfGenerationFailure(Exception exception) {
                pdfUtilListener.pdfGenerationFailure(exception);
            }
        });
    }

    private void createPDFFromViewList(final View headerView, final @NonNull ArrayList<View> tempViewList, final @NonNull String filename, final PDFUtil.PDFUtilListener pdfUtilListener) {
        tempViewList.get(tempViewList.size() - 1).post(new Runnable(){

            @Override
            public void run() {
                final FileManager fileManager = FileManager.getInstance();
                fileManager.cleanTempFolder(PDFCreatorActivity.this.getApplicationContext());
                PDFCreatorActivity.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        ArrayList<View> pdfPageViewList = new ArrayList<View>();
                        LinearLayout currentPDFLayout = (LinearLayout)PDFCreatorActivity.this.getLayoutInflater().inflate(R.layout.item_pdf_page, null);
                        currentPDFLayout.setBackgroundColor(ContextCompat.getColor((Context)PDFCreatorActivity.this.getApplicationContext(), (int)R.color.colorWhite));
                        pdfPageViewList.add((View)currentPDFLayout);
                        int currentPageHeight = 0;
                        if (headerView != null) {
                            PDFCreatorActivity.this.headerLayoutHeight = headerView.getHeight();
                        }
                        int pageIndex = 1;
                        for (View viewItem : tempViewList) {
                            if (currentPageHeight + viewItem.getHeight() > PDFCreatorActivity.this.getResources().getDimensionPixelSize(R.dimen.pdf_height) - PDFCreatorActivity.this.getResources().getDimensionPixelSize(R.dimen.pdf_margin_vertical) * 2) {
                                currentPDFLayout = (LinearLayout)PDFCreatorActivity.this.getLayoutInflater().inflate(R.layout.item_pdf_page, null);
                                currentPDFLayout.setBackgroundColor(ContextCompat.getColor((Context)PDFCreatorActivity.this.getApplicationContext(), (int)R.color.colorWhite));
                                pdfPageViewList.add((View)currentPDFLayout);
                                currentPageHeight = 0;
                                if (PDFCreatorActivity.this.headerLayoutHeight > 0) {
                                    LinearLayout layoutHeader = PDFCreatorActivity.this.getHeaderView(pageIndex).getView();
                                    PDFCreatorActivity.this.addViewToTempLayout(PDFCreatorActivity.this.layoutPageParent, (View)layoutHeader);
                                    currentPageHeight += PDFCreatorActivity.this.headerLayoutHeight;
                                    PDFCreatorActivity.this.layoutPageParent.removeView((View)layoutHeader);
                                    currentPDFLayout.addView((View)layoutHeader);
                                    ++pageIndex;
                                }
                            }
                            currentPageHeight += viewItem.getHeight();
                            PDFCreatorActivity.this.layoutPageParent.removeView(viewItem);
                            currentPDFLayout.addView(viewItem);
                        }
                        PDFUtil.getInstance().generatePDF(pdfPageViewList, fileManager.createTempFileWithName(PDFCreatorActivity.this.getApplicationContext(), filename + ".pdf", false).getAbsolutePath(), pdfUtilListener);
                    }
                });
            }
        });
    }

    private void addViewToTempLayout(LinearLayout layoutPageParent, View viewToAdd) {
        layoutPageParent.addView(viewToAdd);
    }

    public void onClick(View v) {
        if (v == this.buttonNextPage) {
            if (this.selectedPreviewPage == this.pagePreviewBitmapList.size() - 1) {
                return;
            }
            ++this.selectedPreviewPage;
            this.imageViewPDFPreview.setImageBitmap(this.pagePreviewBitmapList.get(this.selectedPreviewPage));
            this.textViewPageNumber.setText((CharSequence)String.format(Locale.getDefault(), "%d of %d", this.selectedPreviewPage + 1, this.pagePreviewBitmapList.size()));
        } else if (v == this.buttonPreviousPage) {
            if (this.selectedPreviewPage == 0) {
                return;
            }
            --this.selectedPreviewPage;
            this.imageViewPDFPreview.setImageBitmap(this.pagePreviewBitmapList.get(this.selectedPreviewPage));
            this.textViewPageNumber.setText((CharSequence)String.format(Locale.getDefault(), "%d of %d", this.selectedPreviewPage + 1, this.pagePreviewBitmapList.size()));
        } else if (v == this.buttonEmailVisit) {
            this.onNextClicked(this.savedPDFFile);
        }
    }

    protected abstract PDFHeaderView getHeaderView(int var1);

    protected abstract PDFBody getBodyViews();

    protected abstract void onNextClicked(File var1);
}

