/*
 * Decompiled with CFR 0.152.
 */
package com.tejpratapsingh.pdfcreator.utils;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.pdf.PdfDocument;
import android.graphics.pdf.PdfRenderer;
import android.os.AsyncTask;
import android.os.Build;
import android.os.ParcelFileDescriptor;
import android.util.Log;
import android.view.View;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class PDFUtil {
    private static final String TAG = PDFUtil.class.getName();
    private static final double PDF_PAGE_WIDTH = 597.6;
    private static final double PDF_PAGE_HEIGHT = 842.4;
    private static PDFUtil sInstance;

    private PDFUtil() {
    }

    public static PDFUtil getInstance() {
        if (sInstance == null) {
            sInstance = new PDFUtil();
        }
        return sInstance;
    }

    public final void generatePDF(List<View> contentViews, String filePath, PDFUtilListener listener) {
        int currentApiVersion = Build.VERSION.SDK_INT;
        if (currentApiVersion >= 19) {
            new GeneratePDFAsync(contentViews, filePath, listener).execute(new Void[0]);
        } else {
            Log.e((String)TAG, (String)"Generate PDF is not available for your android version.");
            listener.pdfGenerationFailure(new APINotSupportedException("Generate PDF is not available for your android version."));
        }
    }

    public static ArrayList<Bitmap> pdfToBitmap(File pdfFile) throws Exception, IllegalStateException {
        if (pdfFile == null || !pdfFile.exists()) {
            throw new IllegalStateException("");
        }
        ArrayList<Bitmap> bitmaps = new ArrayList<Bitmap>();
        try {
            PdfRenderer renderer = new PdfRenderer(ParcelFileDescriptor.open((File)pdfFile, (int)0x10000000));
            int pageCount = renderer.getPageCount();
            for (int i = 0; i < pageCount; ++i) {
                PdfRenderer.Page page = renderer.openPage(i);
                int width = page.getWidth();
                int height = page.getHeight();
                Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                page.render(bitmap, null, null, 1);
                bitmaps.add(bitmap);
                page.close();
            }
            renderer.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return bitmaps;
    }

    private int getTotalPages(File pdfFile) throws IOException, Exception {
        ParcelFileDescriptor parcelFileDescriptor = ParcelFileDescriptor.open((File)pdfFile, (int)0x10000000);
        if (Build.VERSION.SDK_INT >= 21) {
            PdfRenderer pdfRenderer = new PdfRenderer(parcelFileDescriptor);
            return pdfRenderer.getPageCount();
        }
        throw new Exception("PDF cannot be processed in this device");
    }

    private static class APINotSupportedException
    extends Exception {
        private String mErrorMessage;

        APINotSupportedException(String errorMessage) {
            this.mErrorMessage = errorMessage;
        }

        @Override
        public String toString() {
            return "APINotSupportedException{mErrorMessage='" + this.mErrorMessage + '\'' + '}';
        }
    }

    private static class GeneratePDFAsync
    extends AsyncTask<Void, Void, File> {
        private List<View> mContentViews;
        private String mFilePath;
        private PDFUtilListener mListener = null;
        private Exception mException;

        GeneratePDFAsync(List<View> contentViews, String filePath, PDFUtilListener listener) {
            this.mContentViews = contentViews;
            this.mFilePath = filePath;
            this.mListener = listener;
        }

        protected File doInBackground(Void ... params) {
            try {
                PdfDocument pdfDocument = new PdfDocument();
                this.writePDFDocument(pdfDocument);
                return this.savePDFDocumentToStorage(pdfDocument);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }

        protected void onPostExecute(File savedPDFFile) {
            super.onPostExecute((Object)savedPDFFile);
            if (savedPDFFile != null) {
                this.mListener.pdfGenerationSuccess(savedPDFFile);
            } else {
                this.mListener.pdfGenerationFailure(this.mException);
            }
        }

        private void writePDFDocument(PdfDocument pdfDocument) {
            for (int i = 0; i < this.mContentViews.size(); ++i) {
                View contentView = this.mContentViews.get(i);
                PdfDocument.PageInfo pageInfo = new PdfDocument.PageInfo.Builder(597, 842, i + 1).create();
                PdfDocument.Page page = pdfDocument.startPage(pageInfo);
                Canvas pageCanvas = page.getCanvas();
                pageCanvas.scale(1.0f, 1.0f);
                int pageWidth = pageCanvas.getWidth();
                int pageHeight = pageCanvas.getHeight();
                int measureWidth = View.MeasureSpec.makeMeasureSpec((int)pageWidth, (int)0x40000000);
                int measuredHeight = View.MeasureSpec.makeMeasureSpec((int)pageHeight, (int)0x40000000);
                contentView.measure(measureWidth, measuredHeight);
                contentView.layout(0, 0, pageWidth, pageHeight);
                contentView.draw(pageCanvas);
                pdfDocument.finishPage(page);
            }
        }

        private File savePDFDocumentToStorage(PdfDocument pdfDocument) throws IOException {
            FileOutputStream fos = null;
            File pdfFile = null;
            pdfFile = this.mFilePath == null || this.mFilePath.isEmpty() ? File.createTempFile(Long.toString(new Date().getTime()), "pdf") : new File(this.mFilePath);
            File parentFile = pdfFile.getParentFile();
            if (parentFile == null) {
                return null;
            }
            if (!parentFile.exists() && !parentFile.mkdirs()) {
                throw new IllegalStateException("Couldn't create directory: " + parentFile);
            }
            boolean fileExists = pdfFile.exists();
            if (fileExists) {
                fileExists = !pdfFile.delete();
            }
            try {
                if (!fileExists) {
                    fileExists = pdfFile.createNewFile();
                }
                if (fileExists) {
                    fos = new FileOutputStream(pdfFile);
                    pdfDocument.writeTo((OutputStream)fos);
                    fos.close();
                    pdfDocument.close();
                }
                return pdfFile;
            }
            catch (IOException exception) {
                exception.printStackTrace();
                if (fos != null) {
                    fos.close();
                }
                throw exception;
            }
        }
    }

    public static interface PDFUtilListener {
        public void pdfGenerationSuccess(File var1);

        public void pdfGenerationFailure(Exception var1);
    }
}

