/*
 * Decompiled with CFR 0.152.
 */
package org.schabi.newpipe.extractor.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.schabi.newpipe.extractor.Downloader;
import org.schabi.newpipe.extractor.MediaFormat;
import org.schabi.newpipe.extractor.NewPipe;
import org.schabi.newpipe.extractor.exceptions.ParsingException;
import org.schabi.newpipe.extractor.exceptions.ReCaptchaException;
import org.schabi.newpipe.extractor.services.youtube.ItagItem;
import org.schabi.newpipe.extractor.stream.AudioStream;
import org.schabi.newpipe.extractor.stream.Stream;
import org.schabi.newpipe.extractor.stream.StreamInfo;
import org.schabi.newpipe.extractor.stream.VideoStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DashMpdParser {
    private DashMpdParser() {
    }

    public static void getStreams(StreamInfo streamInfo) throws DashMpdParsingException, ReCaptchaException {
        String dashDoc;
        Downloader downloader = NewPipe.getDownloader();
        try {
            dashDoc = downloader.download(streamInfo.dashMpdUrl);
        }
        catch (IOException ioe) {
            throw new DashMpdParsingException("Could not get dash mpd: " + streamInfo.dashMpdUrl, ioe);
        }
        catch (ReCaptchaException e) {
            throw new ReCaptchaException("reCaptcha Challenge needed");
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            ByteArrayInputStream stream = new ByteArrayInputStream(dashDoc.getBytes());
            Document doc = builder.parse(stream);
            NodeList representationList = doc.getElementsByTagName("Representation");
            for (int i = 0; i < representationList.getLength(); ++i) {
                Element representation = (Element)representationList.item(i);
                try {
                    int format;
                    String mimeType = ((Element)representation.getParentNode()).getAttribute("mimeType");
                    String id = representation.getAttribute("id");
                    String url = representation.getElementsByTagName("BaseURL").item(0).getTextContent();
                    ItagItem itag = ItagItem.getItag(Integer.parseInt(id));
                    if (itag == null) continue;
                    MediaFormat mediaFormat = MediaFormat.getFromMimeType(mimeType);
                    int n = format = mediaFormat != null ? mediaFormat.id : -1;
                    if (itag.itagType.equals((Object)ItagItem.ItagType.AUDIO)) {
                        AudioStream audioStream = new AudioStream(url, format, itag.avgBitrate);
                        if (Stream.containSimilarStream(audioStream, streamInfo.audio_streams)) continue;
                        streamInfo.audio_streams.add(audioStream);
                        continue;
                    }
                    boolean isVideoOnly = itag.itagType.equals((Object)ItagItem.ItagType.VIDEO_ONLY);
                    VideoStream videoStream = new VideoStream(url, format, itag.resolutionString, isVideoOnly);
                    if (isVideoOnly) {
                        if (Stream.containSimilarStream(videoStream, streamInfo.video_only_streams)) continue;
                        streamInfo.video_only_streams.add(videoStream);
                        continue;
                    }
                    if (Stream.containSimilarStream(videoStream, streamInfo.video_streams)) continue;
                    streamInfo.video_streams.add(videoStream);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            throw new DashMpdParsingException("Could not parse Dash mpd", e);
        }
    }

    public static class DashMpdParsingException
    extends ParsingException {
        DashMpdParsingException(String message, Exception e) {
            super(message, e);
        }
    }
}

