/*
 * Decompiled with CFR 0.152.
 */
package org.schabi.newpipe.extractor.stream;

import java.util.List;
import java.util.Vector;
import org.schabi.newpipe.extractor.InfoItem;
import org.schabi.newpipe.extractor.InfoItemCollector;
import org.schabi.newpipe.extractor.exceptions.FoundAdException;
import org.schabi.newpipe.extractor.exceptions.ParsingException;
import org.schabi.newpipe.extractor.stream.StreamInfoItem;
import org.schabi.newpipe.extractor.stream.StreamInfoItemExtractor;

public class StreamInfoItemCollector
extends InfoItemCollector {
    public StreamInfoItemCollector(int serviceId) {
        super(serviceId);
    }

    public StreamInfoItem extract(StreamInfoItemExtractor extractor) throws Exception {
        if (extractor.isAd()) {
            throw new FoundAdException("Found ad");
        }
        StreamInfoItem resultItem = new StreamInfoItem();
        resultItem.service_id = this.getServiceId();
        resultItem.url = extractor.getUrl();
        resultItem.name = extractor.getName();
        resultItem.stream_type = extractor.getStreamType();
        try {
            resultItem.duration = extractor.getDuration();
        }
        catch (Exception e) {
            this.addError(e);
        }
        try {
            resultItem.uploader_name = extractor.getUploaderName();
        }
        catch (Exception e) {
            this.addError(e);
        }
        try {
            resultItem.upload_date = extractor.getUploadDate();
        }
        catch (Exception e) {
            this.addError(e);
        }
        try {
            resultItem.view_count = extractor.getViewCount();
        }
        catch (Exception e) {
            this.addError(e);
        }
        try {
            resultItem.thumbnail_url = extractor.getThumbnailUrl();
        }
        catch (Exception e) {
            this.addError(e);
        }
        return resultItem;
    }

    public void commit(StreamInfoItemExtractor extractor) throws ParsingException {
        try {
            this.addItem(this.extract(extractor));
        }
        catch (FoundAdException foundAdException) {
        }
        catch (Exception e) {
            this.addError(e);
        }
    }

    public List<StreamInfoItem> getStreamInfoItemList() {
        Vector<StreamInfoItem> siiList = new Vector<StreamInfoItem>();
        for (InfoItem ii : super.getItemList()) {
            if (!(ii instanceof StreamInfoItem)) continue;
            siiList.add((StreamInfoItem)ii);
        }
        return siiList;
    }
}

