/*
 * Decompiled with CFR 0.152.
 */
package org.schabi.newpipe.extractor.stream;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.schabi.newpipe.extractor.Info;
import org.schabi.newpipe.extractor.InfoItem;
import org.schabi.newpipe.extractor.NewPipe;
import org.schabi.newpipe.extractor.ServiceList;
import org.schabi.newpipe.extractor.StreamingService;
import org.schabi.newpipe.extractor.exceptions.ContentNotAvailableException;
import org.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.schabi.newpipe.extractor.stream.AudioStream;
import org.schabi.newpipe.extractor.stream.StreamExtractor;
import org.schabi.newpipe.extractor.stream.StreamInfoItem;
import org.schabi.newpipe.extractor.stream.StreamInfoItemCollector;
import org.schabi.newpipe.extractor.stream.StreamType;
import org.schabi.newpipe.extractor.stream.VideoStream;
import org.schabi.newpipe.extractor.utils.DashMpdParser;

public class StreamInfo
extends Info {
    public StreamType stream_type;
    public String thumbnail_url;
    public String upload_date;
    public long duration = -1L;
    public int age_limit = -1;
    public String description;
    public long view_count = -1L;
    public long like_count = -1L;
    public long dislike_count = -1L;
    public String uploader_name;
    public String uploader_url;
    public String uploader_avatar_url;
    public List<VideoStream> video_streams;
    public List<AudioStream> audio_streams;
    public List<VideoStream> video_only_streams;
    public String dashMpdUrl;
    public StreamInfoItem next_video;
    public List<InfoItem> related_streams;
    public long start_position = 0L;

    public static StreamInfo getInfo(String url) throws IOException, ExtractionException {
        return StreamInfo.getInfo(NewPipe.getServiceByUrl(url), url);
    }

    public static StreamInfo getInfo(ServiceList serviceItem, String url) throws IOException, ExtractionException {
        return StreamInfo.getInfo(serviceItem.getService(), url);
    }

    public static StreamInfo getInfo(StreamingService service, String url) throws IOException, ExtractionException {
        return StreamInfo.getInfo(service.getStreamExtractor(url));
    }

    public static StreamInfo getInfo(StreamExtractor extractor) throws ExtractionException {
        StreamInfo streamInfo = new StreamInfo();
        try {
            streamInfo = StreamInfo.extractImportantData(streamInfo, extractor);
            streamInfo = StreamInfo.extractStreams(streamInfo, extractor);
            streamInfo = StreamInfo.extractOptionalData(streamInfo, extractor);
        }
        catch (ExtractionException e) {
            String errorMsg = extractor.getErrorMessage();
            if (errorMsg != null) {
                throw new ContentNotAvailableException(errorMsg);
            }
            throw e;
        }
        return streamInfo;
    }

    private static StreamInfo extractImportantData(StreamInfo streamInfo, StreamExtractor extractor) throws ExtractionException {
        streamInfo.service_id = extractor.getServiceId();
        streamInfo.url = extractor.getCleanUrl();
        streamInfo.stream_type = extractor.getStreamType();
        streamInfo.id = extractor.getId();
        streamInfo.name = extractor.getName();
        streamInfo.age_limit = extractor.getAgeLimit();
        if (streamInfo.stream_type == StreamType.NONE || streamInfo.url == null || streamInfo.url.isEmpty() || streamInfo.id == null || streamInfo.id.isEmpty() || streamInfo.name == null || streamInfo.age_limit == -1) {
            throw new ExtractionException("Some important stream information was not given.");
        }
        return streamInfo;
    }

    private static StreamInfo extractStreams(StreamInfo streamInfo, StreamExtractor extractor) throws ExtractionException {
        try {
            streamInfo.dashMpdUrl = extractor.getDashMpdUrl();
        }
        catch (Exception e) {
            streamInfo.addException(new ExtractionException("Couldn't get Dash manifest", e));
        }
        try {
            streamInfo.audio_streams = extractor.getAudioStreams();
        }
        catch (Exception e) {
            streamInfo.addException(new ExtractionException("Couldn't get audio streams", e));
        }
        try {
            streamInfo.video_streams = extractor.getVideoStreams();
        }
        catch (Exception e) {
            streamInfo.addException(new ExtractionException("Couldn't get video streams", e));
        }
        try {
            streamInfo.video_only_streams = extractor.getVideoOnlyStreams();
        }
        catch (Exception e) {
            streamInfo.addException(new ExtractionException("Couldn't get video only streams", e));
        }
        if (streamInfo.video_streams == null) {
            streamInfo.video_streams = new ArrayList<VideoStream>();
        }
        if (streamInfo.video_only_streams == null) {
            streamInfo.video_only_streams = new ArrayList<VideoStream>();
        }
        if (streamInfo.audio_streams == null) {
            streamInfo.audio_streams = new ArrayList<AudioStream>();
        }
        Exception dashMpdError = null;
        if (streamInfo.dashMpdUrl != null && !streamInfo.dashMpdUrl.isEmpty()) {
            try {
                DashMpdParser.getStreams(streamInfo);
            }
            catch (Exception e) {
                dashMpdError = e;
            }
        }
        if ((streamInfo.video_streams == null || streamInfo.video_streams.isEmpty()) && (streamInfo.audio_streams == null || streamInfo.audio_streams.isEmpty())) {
            if (dashMpdError != null) {
                streamInfo.addException(dashMpdError);
            }
            throw new StreamExtractException("Could not get any stream. See error variable to get further details.");
        }
        return streamInfo;
    }

    private static StreamInfo extractOptionalData(StreamInfo streamInfo, StreamExtractor extractor) {
        try {
            streamInfo.thumbnail_url = extractor.getThumbnailUrl();
        }
        catch (Exception e) {
            streamInfo.addException(e);
        }
        try {
            streamInfo.duration = extractor.getLength();
        }
        catch (Exception e) {
            streamInfo.addException(e);
        }
        try {
            streamInfo.uploader_name = extractor.getUploaderName();
        }
        catch (Exception e) {
            streamInfo.addException(e);
        }
        try {
            streamInfo.uploader_url = extractor.getUploaderUrl();
        }
        catch (Exception e) {
            streamInfo.addException(e);
        }
        try {
            streamInfo.description = extractor.getDescription();
        }
        catch (Exception e) {
            streamInfo.addException(e);
        }
        try {
            streamInfo.view_count = extractor.getViewCount();
        }
        catch (Exception e) {
            streamInfo.addException(e);
        }
        try {
            streamInfo.upload_date = extractor.getUploadDate();
        }
        catch (Exception e) {
            streamInfo.addException(e);
        }
        try {
            streamInfo.uploader_avatar_url = extractor.getUploaderAvatarUrl();
        }
        catch (Exception e) {
            streamInfo.addException(e);
        }
        try {
            streamInfo.start_position = extractor.getTimeStamp();
        }
        catch (Exception e) {
            streamInfo.addException(e);
        }
        try {
            streamInfo.like_count = extractor.getLikeCount();
        }
        catch (Exception e) {
            streamInfo.addException(e);
        }
        try {
            streamInfo.dislike_count = extractor.getDislikeCount();
        }
        catch (Exception e) {
            streamInfo.addException(e);
        }
        try {
            streamInfo.next_video = extractor.getNextVideo();
        }
        catch (Exception e) {
            streamInfo.addException(e);
        }
        try {
            StreamInfoItemCollector c = extractor.getRelatedVideos();
            streamInfo.related_streams = c.getItemList();
            streamInfo.errors.addAll(c.getErrors());
        }
        catch (Exception e) {
            streamInfo.addException(e);
        }
        if (streamInfo.related_streams == null) {
            streamInfo.related_streams = new ArrayList<InfoItem>();
        }
        return streamInfo;
    }

    public void addException(Exception e) {
        this.errors.add(e);
    }

    public static class StreamExtractException
    extends ExtractionException {
        StreamExtractException(String message) {
            super(message);
        }
    }
}

