/*
 * Decompiled with CFR 0.152.
 */
package org.schabi.newpipe.extractor.services.youtube;

import com.grack.nanojson.JsonArray;
import com.grack.nanojson.JsonParser;
import com.grack.nanojson.JsonParserException;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.schabi.newpipe.extractor.Downloader;
import org.schabi.newpipe.extractor.NewPipe;
import org.schabi.newpipe.extractor.SuggestionExtractor;
import org.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.schabi.newpipe.extractor.exceptions.ParsingException;

public class YoutubeSuggestionExtractor
extends SuggestionExtractor {
    public static final String CHARSET_UTF_8 = "UTF-8";

    public YoutubeSuggestionExtractor(int serviceId) {
        super(serviceId);
    }

    @Override
    public List<String> suggestionList(String query, String contentCountry) throws IOException, ExtractionException {
        Downloader dl = NewPipe.getDownloader();
        ArrayList<String> suggestions = new ArrayList<String>();
        String url = "https://suggestqueries.google.com/complete/search?client=youtube&jsonp=JP&ds=yt&hl=" + URLEncoder.encode(contentCountry, CHARSET_UTF_8) + "&q=" + URLEncoder.encode(query, CHARSET_UTF_8);
        String response = dl.download(url);
        response = response.substring(3, response.length() - 1);
        try {
            JsonArray collection = ((JsonArray)JsonParser.array().from(response)).getArray(1, new JsonArray());
            for (Object suggestion : collection) {
                String suggestionStr;
                if (!(suggestion instanceof JsonArray) || (suggestionStr = ((JsonArray)suggestion).getString(0)) == null) continue;
                suggestions.add(suggestionStr);
            }
            return suggestions;
        }
        catch (JsonParserException e) {
            throw new ParsingException("Could not parse json response", e);
        }
    }
}

