/*
 * Decompiled with CFR 0.152.
 */
package org.schabi.newpipe.extractor.services.youtube;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.schabi.newpipe.extractor.Downloader;
import org.schabi.newpipe.extractor.NewPipe;
import org.schabi.newpipe.extractor.UrlIdHandler;
import org.schabi.newpipe.extractor.exceptions.FoundAdException;
import org.schabi.newpipe.extractor.exceptions.ParsingException;
import org.schabi.newpipe.extractor.exceptions.ReCaptchaException;
import org.schabi.newpipe.extractor.utils.Parser;

public class YoutubeStreamUrlIdHandler
implements UrlIdHandler {
    private static final YoutubeStreamUrlIdHandler instance = new YoutubeStreamUrlIdHandler();
    private static final String ID_PATTERN = "([\\-a-zA-Z0-9_]{11})";

    private YoutubeStreamUrlIdHandler() {
    }

    public static YoutubeStreamUrlIdHandler getInstance() {
        return instance;
    }

    @Override
    public String getUrl(String id) {
        return "https://www.youtube.com/watch?v=" + id;
    }

    @Override
    public String getId(String url) throws ParsingException, IllegalArgumentException {
        String id;
        if (url.isEmpty()) {
            throw new IllegalArgumentException("The url parameter should not be empty");
        }
        String lowercaseUrl = url.toLowerCase();
        if (lowercaseUrl.contains("youtube")) {
            if (url.contains("attribution_link")) {
                try {
                    String escapedQuery = Parser.matchGroup1("u=(.[^&|$]*)", url);
                    String query = URLDecoder.decode(escapedQuery, "UTF-8");
                    id = Parser.matchGroup1("v=([\\-a-zA-Z0-9_]{11})", query);
                }
                catch (UnsupportedEncodingException uee) {
                    throw new ParsingException("Could not parse attribution_link", uee);
                }
            } else {
                if (lowercaseUrl.contains("youtube.com/shared?ci=")) {
                    return this.getRealIdFromSharedLink(url);
                }
                if (url.contains("vnd.youtube")) {
                    id = Parser.matchGroup1(ID_PATTERN, url);
                } else if (url.contains("embed")) {
                    id = Parser.matchGroup1("embed/([\\-a-zA-Z0-9_]{11})", url);
                } else {
                    if (url.contains("googleads")) {
                        throw new FoundAdException("Error found add: " + url);
                    }
                    id = Parser.matchGroup1("[?&]v=([\\-a-zA-Z0-9_]{11})", url);
                }
            }
        } else if (lowercaseUrl.contains("youtu.be")) {
            id = url.contains("v=") ? Parser.matchGroup1("v=([\\-a-zA-Z0-9_]{11})", url) : Parser.matchGroup1("[Yy][Oo][Uu][Tt][Uu]\\.[Bb][Ee]/([\\-a-zA-Z0-9_]{11})", url);
        } else {
            throw new ParsingException("Error no suitable url: " + url);
        }
        if (!id.isEmpty()) {
            return id;
        }
        throw new ParsingException("Error could not parse url: " + url);
    }

    private String getRealIdFromSharedLink(String url) throws ParsingException {
        String content;
        URI uri;
        try {
            uri = new URI(url);
        }
        catch (URISyntaxException e) {
            throw new ParsingException("Invalid shared link", e);
        }
        String sharedId = this.getSharedId(uri);
        Downloader downloader = NewPipe.getDownloader();
        try {
            content = downloader.download("https://www.youtube.com/shared?ci=" + sharedId);
        }
        catch (IOException | ReCaptchaException e) {
            throw new ParsingException("Unable to resolve shared link", e);
        }
        Document document = Jsoup.parse((String)content);
        Element element = document.select("link[rel=\"canonical\"]").first();
        String urlWithRealId = element != null ? element.attr("abs:href") : document.select("meta[property=\"og:url\"]").first().attr("abs:content");
        String realId = Parser.matchGroup1(ID_PATTERN, urlWithRealId);
        if (sharedId.equals(realId)) {
            throw new ParsingException("Got same id for as shared info_id: " + sharedId);
        }
        return realId;
    }

    private String getSharedId(URI uri) throws ParsingException {
        if (!"/shared".equals(uri.getPath())) {
            throw new ParsingException("Not a shared link: " + uri.toString() + " (path != " + uri.getPath() + ")");
        }
        return Parser.matchGroup1("ci=([\\-a-zA-Z0-9_]{11})", uri.getQuery());
    }

    @Override
    public String cleanUrl(String complexUrl) throws ParsingException {
        return this.getUrl(this.getId(complexUrl));
    }

    @Override
    public boolean acceptUrl(String url) {
        String lowercaseUrl = url.toLowerCase();
        if (lowercaseUrl.contains("youtube") || lowercaseUrl.contains("youtu.be")) {
            try {
                this.getId(url);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }
}

