/*
 * Decompiled with CFR 0.152.
 */
package org.schabi.newpipe.extractor.services.youtube;

import java.io.IOException;
import org.schabi.newpipe.extractor.StreamingService;
import org.schabi.newpipe.extractor.SuggestionExtractor;
import org.schabi.newpipe.extractor.UrlIdHandler;
import org.schabi.newpipe.extractor.channel.ChannelExtractor;
import org.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.schabi.newpipe.extractor.kiosk.KioskExtractor;
import org.schabi.newpipe.extractor.kiosk.KioskList;
import org.schabi.newpipe.extractor.playlist.PlaylistExtractor;
import org.schabi.newpipe.extractor.search.SearchEngine;
import org.schabi.newpipe.extractor.services.youtube.YoutubeChannelExtractor;
import org.schabi.newpipe.extractor.services.youtube.YoutubeChannelUrlIdHandler;
import org.schabi.newpipe.extractor.services.youtube.YoutubePlaylistExtractor;
import org.schabi.newpipe.extractor.services.youtube.YoutubePlaylistUrlIdHandler;
import org.schabi.newpipe.extractor.services.youtube.YoutubeSearchEngine;
import org.schabi.newpipe.extractor.services.youtube.YoutubeStreamExtractor;
import org.schabi.newpipe.extractor.services.youtube.YoutubeStreamUrlIdHandler;
import org.schabi.newpipe.extractor.services.youtube.YoutubeSuggestionExtractor;
import org.schabi.newpipe.extractor.services.youtube.YoutubeTrendingExtractor;
import org.schabi.newpipe.extractor.services.youtube.YoutubeTrendingUrlIdHandler;
import org.schabi.newpipe.extractor.stream.StreamExtractor;

public class YoutubeService
extends StreamingService {
    public YoutubeService(int id, String name) {
        super(id, name);
    }

    @Override
    public SearchEngine getSearchEngine() {
        return new YoutubeSearchEngine(this.getServiceId());
    }

    @Override
    public UrlIdHandler getStreamUrlIdHandler() {
        return YoutubeStreamUrlIdHandler.getInstance();
    }

    @Override
    public UrlIdHandler getChannelUrlIdHandler() {
        return YoutubeChannelUrlIdHandler.getInstance();
    }

    @Override
    public UrlIdHandler getPlaylistUrlIdHandler() {
        return YoutubePlaylistUrlIdHandler.getInstance();
    }

    @Override
    public StreamExtractor getStreamExtractor(String url) throws IOException, ExtractionException {
        return new YoutubeStreamExtractor(this, url);
    }

    @Override
    public ChannelExtractor getChannelExtractor(String url, String nextStreamsUrl) throws IOException, ExtractionException {
        return new YoutubeChannelExtractor(this, url, nextStreamsUrl);
    }

    @Override
    public PlaylistExtractor getPlaylistExtractor(String url, String nextStreamsUrl) throws IOException, ExtractionException {
        return new YoutubePlaylistExtractor(this, url, nextStreamsUrl);
    }

    @Override
    public SuggestionExtractor getSuggestionExtractor() {
        return new YoutubeSuggestionExtractor(this.getServiceId());
    }

    @Override
    public KioskList getKioskList() throws ExtractionException {
        KioskList list = new KioskList(this.getServiceId());
        try {
            list.addKioskEntry(new KioskList.KioskExtractorFactory(){

                @Override
                public KioskExtractor createNewKiosk(StreamingService streamingService, String url, String nextStreamUrl, String id) throws ExtractionException, IOException {
                    return new YoutubeTrendingExtractor(YoutubeService.this, url, nextStreamUrl, id);
                }
            }, new YoutubeTrendingUrlIdHandler(), "Trending");
            list.setDefaultKiosk("Trending");
        }
        catch (Exception e) {
            throw new ExtractionException(e);
        }
        return list;
    }
}

