/*
 * Decompiled with CFR 0.152.
 */
package org.schabi.newpipe.extractor.services.youtube;

import java.io.IOException;
import java.net.URLEncoder;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.schabi.newpipe.extractor.Downloader;
import org.schabi.newpipe.extractor.NewPipe;
import org.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.schabi.newpipe.extractor.search.InfoItemSearchCollector;
import org.schabi.newpipe.extractor.search.SearchEngine;
import org.schabi.newpipe.extractor.services.youtube.YoutubeChannelInfoItemExtractor;
import org.schabi.newpipe.extractor.services.youtube.YoutubePlaylistInfoItemExtractor;
import org.schabi.newpipe.extractor.services.youtube.YoutubeStreamInfoItemExtractor;

public class YoutubeSearchEngine
extends SearchEngine {
    private static final String TAG = YoutubeSearchEngine.class.toString();
    public static final String CHARSET_UTF_8 = "UTF-8";

    public YoutubeSearchEngine(int serviceId) {
        super(serviceId);
    }

    @Override
    public InfoItemSearchCollector search(String query, int page, String languageCode, SearchEngine.Filter filter) throws IOException, ExtractionException {
        InfoItemSearchCollector collector = this.getInfoItemSearchCollector();
        Downloader downloader = NewPipe.getDownloader();
        String url = "https://www.youtube.com/results?q=" + URLEncoder.encode(query, CHARSET_UTF_8) + "&page=" + Integer.toString(page + 1);
        switch (filter) {
            case STREAM: {
                url = url + "&sp=EgIQAVAU";
                break;
            }
            case CHANNEL: {
                url = url + "&sp=EgIQAlAU";
                break;
            }
            case PLAYLIST: {
                url = url + "&sp=EgIQA1AU";
                break;
            }
        }
        String site = !languageCode.isEmpty() ? downloader.download(url, languageCode) : downloader.download(url);
        Document doc = Jsoup.parse((String)site, (String)url);
        Element list = doc.select("ol[class=\"item-section\"]").first();
        for (Element item : list.children()) {
            Element el = item.select("div[class*=\"spell-correction\"]").first();
            if (el != null) {
                collector.setSuggestion(el.select("a").first().text());
                if (list.children().size() != 1) continue;
                throw new SearchEngine.NothingFoundException("Did you mean: " + el.select("a").first().text());
            }
            el = item.select("div[class*=\"search-message\"]").first();
            if (el != null) {
                throw new SearchEngine.NothingFoundException(el.text());
            }
            el = item.select("div[class*=\"yt-lockup-video\"]").first();
            if (el != null) {
                collector.commit(new YoutubeStreamInfoItemExtractor(el));
                continue;
            }
            el = item.select("div[class*=\"yt-lockup-channel\"]").first();
            if (el != null) {
                collector.commit(new YoutubeChannelInfoItemExtractor(el));
                continue;
            }
            el = item.select("div[class*=\"yt-lockup-playlist\"]").first();
            if (el == null || !item.select(".yt-pl-icon-mix").isEmpty()) continue;
            collector.commit(new YoutubePlaylistInfoItemExtractor(el));
        }
        return collector;
    }
}

