/*
 * Decompiled with CFR 0.152.
 */
package org.schabi.newpipe.extractor.services.youtube;

import com.grack.nanojson.JsonObject;
import com.grack.nanojson.JsonParser;
import com.grack.nanojson.JsonParserException;
import java.io.IOException;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.schabi.newpipe.extractor.Downloader;
import org.schabi.newpipe.extractor.ListExtractor;
import org.schabi.newpipe.extractor.NewPipe;
import org.schabi.newpipe.extractor.StreamingService;
import org.schabi.newpipe.extractor.UrlIdHandler;
import org.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.schabi.newpipe.extractor.exceptions.ParsingException;
import org.schabi.newpipe.extractor.exceptions.ReCaptchaException;
import org.schabi.newpipe.extractor.playlist.PlaylistExtractor;
import org.schabi.newpipe.extractor.services.youtube.YoutubeParsingHelper;
import org.schabi.newpipe.extractor.services.youtube.YoutubeStreamInfoItemExtractor;
import org.schabi.newpipe.extractor.stream.StreamInfoItemCollector;
import org.schabi.newpipe.extractor.stream.StreamType;
import org.schabi.newpipe.extractor.utils.Parser;
import org.schabi.newpipe.extractor.utils.Utils;

public class YoutubePlaylistExtractor
extends PlaylistExtractor {
    private Document doc;
    private Document nextStreamsAjax;

    public YoutubePlaylistExtractor(StreamingService service, String url, String nextStreamsUrl) throws IOException, ExtractionException {
        super(service, url, nextStreamsUrl);
    }

    @Override
    public void fetchPage() throws IOException, ExtractionException {
        Downloader downloader = NewPipe.getDownloader();
        String pageContent = downloader.download(this.getCleanUrl());
        this.doc = Jsoup.parse((String)pageContent, (String)this.getCleanUrl());
        this.nextStreamsUrl = this.getNextStreamsUrlFrom(this.doc);
        this.nextStreamsAjax = null;
    }

    @Override
    public String getId() throws ParsingException {
        try {
            return this.getUrlIdHandler().getId(this.getCleanUrl());
        }
        catch (Exception e) {
            throw new ParsingException("Could not get playlist id");
        }
    }

    @Override
    public String getName() throws ParsingException {
        try {
            return this.doc.select("div[id=pl-header] h1[class=pl-header-title]").first().text();
        }
        catch (Exception e) {
            throw new ParsingException("Could not get playlist name");
        }
    }

    @Override
    public String getThumbnailUrl() throws ParsingException {
        try {
            return this.doc.select("div[id=pl-header] div[class=pl-header-thumb] img").first().attr("abs:src");
        }
        catch (Exception e) {
            throw new ParsingException("Could not get playlist thumbnail");
        }
    }

    @Override
    public String getBannerUrl() throws ParsingException {
        try {
            Element el = this.doc.select("div[id=\"gh-banner\"] style").first();
            String cssContent = el.html();
            String url = "https:" + Parser.matchGroup1("url\\((.*)\\)", cssContent);
            if (url.contains("s.ytimg.com")) {
                return null;
            }
            return url.substring(0, url.indexOf(");"));
        }
        catch (Exception e) {
            throw new ParsingException("Could not get playlist Banner");
        }
    }

    @Override
    public String getUploaderUrl() throws ParsingException {
        try {
            return this.doc.select("ul[class=\"pl-header-details\"] li").first().select("a").first().attr("abs:href");
        }
        catch (Exception e) {
            throw new ParsingException("Could not get playlist uploader name");
        }
    }

    @Override
    public String getUploaderName() throws ParsingException {
        try {
            return this.doc.select("span[class=\"qualified-channel-title-text\"]").first().select("a").first().text();
        }
        catch (Exception e) {
            throw new ParsingException("Could not get playlist uploader name");
        }
    }

    @Override
    public String getUploaderAvatarUrl() throws ParsingException {
        try {
            return this.doc.select("div[id=gh-banner] img[class=channel-header-profile-image]").first().attr("abs:src");
        }
        catch (Exception e) {
            throw new ParsingException("Could not get playlist uploader avatar");
        }
    }

    @Override
    public long getStreamCount() throws ParsingException {
        String input;
        try {
            input = ((Element)this.doc.select("ul[class=\"pl-header-details\"] li").get(1)).text();
        }
        catch (IndexOutOfBoundsException e) {
            throw new ParsingException("Could not get video count from playlist", e);
        }
        try {
            return Long.parseLong(Utils.removeNonDigitCharacters(input));
        }
        catch (NumberFormatException e) {
            if (!input.isEmpty()) {
                return 0L;
            }
            throw new ParsingException("Could not handle input: " + input, e);
        }
    }

    @Override
    public StreamInfoItemCollector getStreams() throws IOException, ExtractionException {
        StreamInfoItemCollector collector = new StreamInfoItemCollector(this.getServiceId());
        Element tbody = this.doc.select("tbody[id=\"pl-load-more-destination\"]").first();
        this.collectStreamsFrom(collector, tbody);
        return collector;
    }

    @Override
    public ListExtractor.NextItemsResult getNextStreams() throws IOException, ExtractionException {
        if (!this.hasMoreStreams()) {
            throw new ExtractionException("Playlist doesn't have more streams");
        }
        StreamInfoItemCollector collector = new StreamInfoItemCollector(this.getServiceId());
        this.setupNextStreamsAjax(NewPipe.getDownloader());
        this.collectStreamsFrom(collector, this.nextStreamsAjax.select("tbody[id=\"pl-load-more-destination\"]").first());
        return new ListExtractor.NextItemsResult(collector, this.nextStreamsUrl);
    }

    private void setupNextStreamsAjax(Downloader downloader) throws IOException, ReCaptchaException, ParsingException {
        String ajaxDataRaw = downloader.download(this.nextStreamsUrl);
        try {
            JsonObject ajaxData = (JsonObject)JsonParser.object().from(ajaxDataRaw);
            String htmlDataRaw = "<table><tbody id=\"pl-load-more-destination\">" + ajaxData.getString("content_html") + "</tbody></table>";
            this.nextStreamsAjax = Jsoup.parse((String)htmlDataRaw, (String)this.nextStreamsUrl);
            String nextStreamsHtmlDataRaw = ajaxData.getString("load_more_widget_html");
            this.nextStreamsUrl = !nextStreamsHtmlDataRaw.isEmpty() ? this.getNextStreamsUrlFrom(Jsoup.parse((String)nextStreamsHtmlDataRaw, (String)this.nextStreamsUrl)) : "";
        }
        catch (JsonParserException e) {
            throw new ParsingException("Could not parse json data for next streams", e);
        }
    }

    private String getNextStreamsUrlFrom(Document d) throws ParsingException {
        try {
            Element button = d.select("button[class*=\"yt-uix-load-more\"]").first();
            if (button != null) {
                return button.attr("abs:data-uix-load-more-href");
            }
            return "";
        }
        catch (Exception e) {
            throw new ParsingException("could not get next streams' url", e);
        }
    }

    private void collectStreamsFrom(StreamInfoItemCollector collector, Element element) throws ParsingException {
        collector.getItemList().clear();
        final UrlIdHandler streamUrlIdHandler = this.getService().getStreamUrlIdHandler();
        for (final Element li : element.children()) {
            collector.commit(new YoutubeStreamInfoItemExtractor(li){

                @Override
                public boolean isAd() throws ParsingException {
                    return false;
                }

                @Override
                public String getUrl() throws ParsingException {
                    try {
                        return streamUrlIdHandler.getUrl(li.attr("data-video-id"));
                    }
                    catch (Exception e) {
                        throw new ParsingException("Could not get web page url for the video", e);
                    }
                }

                @Override
                public String getName() throws ParsingException {
                    try {
                        return li.attr("data-title");
                    }
                    catch (Exception e) {
                        throw new ParsingException("Could not get title", e);
                    }
                }

                @Override
                public long getDuration() throws ParsingException {
                    try {
                        if (this.getStreamType() == StreamType.LIVE_STREAM) {
                            return -1L;
                        }
                        Element first = li.select("div[class=\"timestamp\"] span").first();
                        if (first == null) {
                            return -1L;
                        }
                        return YoutubeParsingHelper.parseDurationString(first.text());
                    }
                    catch (Exception e) {
                        throw new ParsingException("Could not get duration" + this.getUrl(), e);
                    }
                }

                @Override
                public String getUploaderName() throws ParsingException {
                    return li.select("div[class=pl-video-owner] a").text();
                }

                @Override
                public String getUploadDate() throws ParsingException {
                    return "";
                }

                @Override
                public long getViewCount() throws ParsingException {
                    return -1L;
                }

                @Override
                public String getThumbnailUrl() throws ParsingException {
                    try {
                        return "https://i.ytimg.com/vi/" + streamUrlIdHandler.getId(this.getUrl()) + "/hqdefault.jpg";
                    }
                    catch (Exception e) {
                        throw new ParsingException("Could not get thumbnail url", e);
                    }
                }
            });
        }
    }
}

