/*
 * Decompiled with CFR 0.152.
 */
package org.schabi.newpipe.extractor.services.youtube;

import org.schabi.newpipe.extractor.UrlIdHandler;
import org.schabi.newpipe.extractor.exceptions.ParsingException;
import org.schabi.newpipe.extractor.utils.Parser;

public class YoutubeChannelUrlIdHandler
implements UrlIdHandler {
    private static final YoutubeChannelUrlIdHandler instance = new YoutubeChannelUrlIdHandler();
    private static final String ID_PATTERN = "/(user/[A-Za-z0-9_-]*|channel/[A-Za-z0-9_-]*)";

    public static YoutubeChannelUrlIdHandler getInstance() {
        return instance;
    }

    @Override
    public String getUrl(String id) {
        return "https://www.youtube.com/" + id;
    }

    @Override
    public String getId(String url) throws ParsingException {
        return Parser.matchGroup1(ID_PATTERN, url);
    }

    @Override
    public String cleanUrl(String complexUrl) throws ParsingException {
        return this.getUrl(this.getId(complexUrl));
    }

    @Override
    public boolean acceptUrl(String url) {
        return !(!url.contains("youtube") && !url.contains("youtu.be") || !url.contains("/user/") && !url.contains("/channel/"));
    }
}

