/*
 * Decompiled with CFR 0.152.
 */
package org.schabi.newpipe.extractor.services.youtube;

import org.jsoup.nodes.Element;
import org.schabi.newpipe.extractor.channel.ChannelInfoItemExtractor;
import org.schabi.newpipe.extractor.exceptions.ParsingException;
import org.schabi.newpipe.extractor.utils.Utils;

public class YoutubeChannelInfoItemExtractor
implements ChannelInfoItemExtractor {
    private Element el;

    public YoutubeChannelInfoItemExtractor(Element el) {
        this.el = el;
    }

    @Override
    public String getThumbnailUrl() throws ParsingException {
        Element img = this.el.select("span[class*=\"yt-thumb-simple\"]").first().select("img").first();
        String url = img.attr("abs:src");
        if (url.contains("gif")) {
            url = img.attr("abs:data-thumb");
        }
        return url;
    }

    @Override
    public String getName() throws ParsingException {
        return this.el.select("a[class*=\"yt-uix-tile-link\"]").first().text();
    }

    @Override
    public String getUrl() throws ParsingException {
        return this.el.select("a[class*=\"yt-uix-tile-link\"]").first().attr("abs:href");
    }

    @Override
    public long getSubscriberCount() throws ParsingException {
        Element subsEl = this.el.select("span[class*=\"yt-subscriber-count\"]").first();
        if (subsEl == null) {
            return 0L;
        }
        return Long.parseLong(Utils.removeNonDigitCharacters(subsEl.text()));
    }

    @Override
    public long getStreamCount() throws ParsingException {
        Element metaEl = this.el.select("ul[class*=\"yt-lockup-meta-info\"]").first();
        if (metaEl == null) {
            return 0L;
        }
        return Long.parseLong(Utils.removeNonDigitCharacters(metaEl.text()));
    }

    @Override
    public String getDescription() throws ParsingException {
        Element desEl = this.el.select("div[class*=\"yt-lockup-description\"]").first();
        if (desEl == null) {
            return "";
        }
        return desEl.text();
    }
}

