/*
 * Decompiled with CFR 0.152.
 */
package org.schabi.newpipe.extractor.services.youtube;

import com.grack.nanojson.JsonObject;
import com.grack.nanojson.JsonParser;
import com.grack.nanojson.JsonParserException;
import java.io.IOException;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.schabi.newpipe.extractor.Downloader;
import org.schabi.newpipe.extractor.ListExtractor;
import org.schabi.newpipe.extractor.NewPipe;
import org.schabi.newpipe.extractor.StreamingService;
import org.schabi.newpipe.extractor.channel.ChannelExtractor;
import org.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.schabi.newpipe.extractor.exceptions.ParsingException;
import org.schabi.newpipe.extractor.exceptions.ReCaptchaException;
import org.schabi.newpipe.extractor.services.youtube.YoutubeStreamInfoItemExtractor;
import org.schabi.newpipe.extractor.stream.StreamInfoItemCollector;
import org.schabi.newpipe.extractor.utils.Parser;
import org.schabi.newpipe.extractor.utils.Utils;

public class YoutubeChannelExtractor
extends ChannelExtractor {
    private static final String CHANNEL_FEED_BASE = "https://www.youtube.com/feeds/videos.xml?channel_id=";
    private static final String CHANNEL_URL_PARAMETERS = "/videos?view=0&flow=list&sort=dd&live_view=10000";
    private Document doc;
    private Document nextStreamsAjax;
    private boolean fetchingNextStreams;

    public YoutubeChannelExtractor(StreamingService service, String url, String nextStreamsUrl) throws IOException, ExtractionException {
        super(service, url, nextStreamsUrl);
    }

    @Override
    public void fetchPage() throws IOException, ExtractionException {
        Downloader downloader = NewPipe.getDownloader();
        String channelUrl = super.getCleanUrl() + CHANNEL_URL_PARAMETERS;
        String pageContent = downloader.download(channelUrl);
        this.doc = Jsoup.parse((String)pageContent, (String)channelUrl);
        if (!this.fetchingNextStreams) {
            this.nextStreamsUrl = this.getNextStreamsUrlFrom(this.doc);
        }
        this.nextStreamsAjax = null;
    }

    @Override
    protected boolean fetchPageUponCreation() {
        this.fetchingNextStreams = this.nextStreamsUrl != null && !this.nextStreamsUrl.isEmpty();
        return true;
    }

    @Override
    public String getCleanUrl() {
        try {
            return "https://www.youtube.com/channel/" + this.getId();
        }
        catch (ParsingException e) {
            return super.getCleanUrl();
        }
    }

    @Override
    public String getId() throws ParsingException {
        try {
            Element element = this.doc.getElementsByClass("yt-uix-subscription-button").first();
            if (element == null) {
                element = this.doc.getElementsByClass("yt-uix-subscription-preferences-button").first();
            }
            return element.attr("data-channel-external-id");
        }
        catch (Exception e) {
            throw new ParsingException("Could not get channel id", e);
        }
    }

    @Override
    public String getName() throws ParsingException {
        try {
            return this.doc.select("meta[property=\"og:title\"]").first().attr("content");
        }
        catch (Exception e) {
            throw new ParsingException("Could not get channel name", e);
        }
    }

    @Override
    public String getAvatarUrl() throws ParsingException {
        try {
            return this.doc.select("img[class=\"channel-header-profile-image\"]").first().attr("abs:src");
        }
        catch (Exception e) {
            throw new ParsingException("Could not get avatar", e);
        }
    }

    @Override
    public String getBannerUrl() throws ParsingException {
        try {
            Element el = this.doc.select("div[id=\"gh-banner\"]").first().select("style").first();
            String cssContent = el.html();
            String url = "https:" + Parser.matchGroup1("url\\(([^)]+)\\)", cssContent);
            return url.contains("s.ytimg.com") || url.contains("default_banner") ? null : url;
        }
        catch (Exception e) {
            throw new ParsingException("Could not get Banner", e);
        }
    }

    @Override
    public String getFeedUrl() throws ParsingException {
        try {
            return CHANNEL_FEED_BASE + this.getId();
        }
        catch (Exception e) {
            throw new ParsingException("Could not get feed url", e);
        }
    }

    @Override
    public long getSubscriberCount() throws ParsingException {
        Element el = this.doc.select("span[class*=\"yt-subscription-button-subscriber-count\"]").first();
        if (el != null) {
            return Long.parseLong(Utils.removeNonDigitCharacters(el.text()));
        }
        throw new ParsingException("Could not get subscriber count");
    }

    @Override
    public String getDescription() throws ParsingException {
        try {
            return this.doc.select("meta[name=\"description\"]").first().attr("content");
        }
        catch (Exception e) {
            throw new ParsingException("Could not get channel description", e);
        }
    }

    @Override
    public StreamInfoItemCollector getStreams() throws IOException, ExtractionException {
        StreamInfoItemCollector collector = new StreamInfoItemCollector(this.getServiceId());
        Element ul = this.doc.select("ul[id=\"browse-items-primary\"]").first();
        this.collectStreamsFrom(collector, ul);
        return collector;
    }

    @Override
    public ListExtractor.NextItemsResult getNextStreams() throws IOException, ExtractionException {
        if (!this.hasMoreStreams()) {
            throw new ExtractionException("Channel doesn't have more streams");
        }
        StreamInfoItemCollector collector = new StreamInfoItemCollector(this.getServiceId());
        this.setupNextStreamsAjax(NewPipe.getDownloader());
        this.collectStreamsFrom(collector, this.nextStreamsAjax.select("body").first());
        return new ListExtractor.NextItemsResult(collector, this.nextStreamsUrl);
    }

    private void setupNextStreamsAjax(Downloader downloader) throws IOException, ReCaptchaException, ParsingException {
        String ajaxDataRaw = downloader.download(this.nextStreamsUrl);
        try {
            JsonObject ajaxData = (JsonObject)JsonParser.object().from(ajaxDataRaw);
            String htmlDataRaw = ajaxData.getString("content_html");
            this.nextStreamsAjax = Jsoup.parse((String)htmlDataRaw, (String)this.nextStreamsUrl);
            String nextStreamsHtmlDataRaw = ajaxData.getString("load_more_widget_html");
            this.nextStreamsUrl = !nextStreamsHtmlDataRaw.isEmpty() ? this.getNextStreamsUrlFrom(Jsoup.parse((String)nextStreamsHtmlDataRaw, (String)this.nextStreamsUrl)) : "";
        }
        catch (JsonParserException e) {
            throw new ParsingException("Could not parse json data for next streams", e);
        }
    }

    private String getNextStreamsUrlFrom(Document d) throws ParsingException {
        try {
            Element button = d.select("button[class*=\"yt-uix-load-more\"]").first();
            if (button != null) {
                return button.attr("abs:data-uix-load-more-href");
            }
            return "";
        }
        catch (Exception e) {
            throw new ParsingException("could not get next streams' url", e);
        }
    }

    private void collectStreamsFrom(StreamInfoItemCollector collector, Element element) throws ParsingException {
        collector.getItemList().clear();
        final String uploaderName = this.getName();
        for (final Element li : element.children()) {
            if (li.select("div[class=\"feed-item-dismissable\"]").first() == null) continue;
            collector.commit(new YoutubeStreamInfoItemExtractor(li){

                @Override
                public String getUrl() throws ParsingException {
                    try {
                        Element el = li.select("div[class=\"feed-item-dismissable\"]").first();
                        Element dl = el.select("h3").first().select("a").first();
                        return dl.attr("abs:href");
                    }
                    catch (Exception e) {
                        throw new ParsingException("Could not get web page url for the video", e);
                    }
                }

                @Override
                public String getName() throws ParsingException {
                    try {
                        Element el = li.select("div[class=\"feed-item-dismissable\"]").first();
                        Element dl = el.select("h3").first().select("a").first();
                        return dl.text();
                    }
                    catch (Exception e) {
                        throw new ParsingException("Could not get title", e);
                    }
                }

                @Override
                public String getUploaderName() throws ParsingException {
                    return uploaderName;
                }

                @Override
                public String getThumbnailUrl() throws ParsingException {
                    try {
                        Element te = li.select("span[class=\"yt-thumb-clip\"]").first().select("img").first();
                        String url = te.attr("abs:src");
                        if (url.contains(".gif")) {
                            url = te.attr("abs:data-thumb");
                        }
                        return url;
                    }
                    catch (Exception e) {
                        throw new ParsingException("Could not get thumbnail url", e);
                    }
                }
            });
        }
    }
}

