/*
 * Decompiled with CFR 0.152.
 */
package org.schabi.newpipe.extractor.services.soundcloud;

import java.io.IOException;
import org.schabi.newpipe.extractor.StreamingService;
import org.schabi.newpipe.extractor.SuggestionExtractor;
import org.schabi.newpipe.extractor.UrlIdHandler;
import org.schabi.newpipe.extractor.channel.ChannelExtractor;
import org.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.schabi.newpipe.extractor.kiosk.KioskExtractor;
import org.schabi.newpipe.extractor.kiosk.KioskList;
import org.schabi.newpipe.extractor.playlist.PlaylistExtractor;
import org.schabi.newpipe.extractor.search.SearchEngine;
import org.schabi.newpipe.extractor.services.soundcloud.SoundcloudChannelExtractor;
import org.schabi.newpipe.extractor.services.soundcloud.SoundcloudChannelUrlIdHandler;
import org.schabi.newpipe.extractor.services.soundcloud.SoundcloudChartsExtractor;
import org.schabi.newpipe.extractor.services.soundcloud.SoundcloudChartsUrlIdHandler;
import org.schabi.newpipe.extractor.services.soundcloud.SoundcloudPlaylistExtractor;
import org.schabi.newpipe.extractor.services.soundcloud.SoundcloudPlaylistUrlIdHandler;
import org.schabi.newpipe.extractor.services.soundcloud.SoundcloudSearchEngine;
import org.schabi.newpipe.extractor.services.soundcloud.SoundcloudStreamExtractor;
import org.schabi.newpipe.extractor.services.soundcloud.SoundcloudStreamUrlIdHandler;
import org.schabi.newpipe.extractor.services.soundcloud.SoundcloudSuggestionExtractor;
import org.schabi.newpipe.extractor.stream.StreamExtractor;

public class SoundcloudService
extends StreamingService {
    public SoundcloudService(int id, String name) {
        super(id, name);
    }

    @Override
    public SearchEngine getSearchEngine() {
        return new SoundcloudSearchEngine(this.getServiceId());
    }

    @Override
    public UrlIdHandler getStreamUrlIdHandler() {
        return SoundcloudStreamUrlIdHandler.getInstance();
    }

    @Override
    public UrlIdHandler getChannelUrlIdHandler() {
        return SoundcloudChannelUrlIdHandler.getInstance();
    }

    @Override
    public UrlIdHandler getPlaylistUrlIdHandler() {
        return SoundcloudPlaylistUrlIdHandler.getInstance();
    }

    @Override
    public StreamExtractor getStreamExtractor(String url) throws IOException, ExtractionException {
        return new SoundcloudStreamExtractor(this, url);
    }

    @Override
    public ChannelExtractor getChannelExtractor(String url, String nextStreamsUrl) throws IOException, ExtractionException {
        return new SoundcloudChannelExtractor(this, url, nextStreamsUrl);
    }

    @Override
    public PlaylistExtractor getPlaylistExtractor(String url, String nextStreamsUrl) throws IOException, ExtractionException {
        return new SoundcloudPlaylistExtractor(this, url, nextStreamsUrl);
    }

    @Override
    public SuggestionExtractor getSuggestionExtractor() {
        return new SoundcloudSuggestionExtractor(this.getServiceId());
    }

    @Override
    public KioskList getKioskList() throws ExtractionException {
        KioskList.KioskExtractorFactory chartsFactory = new KioskList.KioskExtractorFactory(){

            @Override
            public KioskExtractor createNewKiosk(StreamingService streamingService, String url, String nextStreamUrl, String id) throws ExtractionException, IOException {
                return new SoundcloudChartsExtractor(SoundcloudService.this, url, nextStreamUrl, id);
            }
        };
        KioskList list = new KioskList(this.getServiceId());
        SoundcloudChartsUrlIdHandler h = new SoundcloudChartsUrlIdHandler();
        try {
            list.addKioskEntry(chartsFactory, h, "Top 50");
            list.addKioskEntry(chartsFactory, h, "New & hot");
        }
        catch (Exception e) {
            throw new ExtractionException(e);
        }
        return list;
    }
}

