/*
 * Decompiled with CFR 0.152.
 */
package org.schabi.newpipe.extractor.services.soundcloud;

import com.grack.nanojson.JsonArray;
import com.grack.nanojson.JsonObject;
import com.grack.nanojson.JsonParser;
import com.grack.nanojson.JsonParserException;
import java.io.IOException;
import java.net.URLEncoder;
import org.schabi.newpipe.extractor.Downloader;
import org.schabi.newpipe.extractor.NewPipe;
import org.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.schabi.newpipe.extractor.exceptions.ParsingException;
import org.schabi.newpipe.extractor.search.InfoItemSearchCollector;
import org.schabi.newpipe.extractor.search.SearchEngine;
import org.schabi.newpipe.extractor.services.soundcloud.SoundcloudChannelInfoItemExtractor;
import org.schabi.newpipe.extractor.services.soundcloud.SoundcloudParsingHelper;
import org.schabi.newpipe.extractor.services.soundcloud.SoundcloudPlaylistInfoItemExtractor;
import org.schabi.newpipe.extractor.services.soundcloud.SoundcloudStreamInfoItemExtractor;

public class SoundcloudSearchEngine
extends SearchEngine {
    public static final String CHARSET_UTF_8 = "UTF-8";

    public SoundcloudSearchEngine(int serviceId) {
        super(serviceId);
    }

    @Override
    public InfoItemSearchCollector search(String query, int page, String languageCode, SearchEngine.Filter filter) throws IOException, ExtractionException {
        JsonArray searchCollection;
        InfoItemSearchCollector collector = this.getInfoItemSearchCollector();
        Downloader dl = NewPipe.getDownloader();
        String url = "https://api-v2.soundcloud.com/search";
        switch (filter) {
            case STREAM: {
                url = url + "/tracks";
                break;
            }
            case CHANNEL: {
                url = url + "/users";
                break;
            }
            case PLAYLIST: {
                url = url + "/playlists";
                break;
            }
        }
        url = url + "?q=" + URLEncoder.encode(query, CHARSET_UTF_8) + "&client_id=" + SoundcloudParsingHelper.clientId() + "&limit=10&offset=" + Integer.toString(page * 10);
        try {
            searchCollection = ((JsonObject)JsonParser.object().from(dl.download(url))).getArray("collection");
        }
        catch (JsonParserException e) {
            throw new ParsingException("Could not parse json response", e);
        }
        if (searchCollection.size() == 0) {
            throw new SearchEngine.NothingFoundException("Nothing found");
        }
        for (Object result : searchCollection) {
            String kind;
            if (!(result instanceof JsonObject)) continue;
            JsonObject searchResult = (JsonObject)result;
            switch (kind = searchResult.getString("kind", "")) {
                case "user": {
                    collector.commit(new SoundcloudChannelInfoItemExtractor(searchResult));
                    break;
                }
                case "track": {
                    collector.commit(new SoundcloudStreamInfoItemExtractor(searchResult));
                    break;
                }
                case "playlist": {
                    collector.commit(new SoundcloudPlaylistInfoItemExtractor(searchResult));
                }
            }
        }
        return collector;
    }
}

