/*
 * Decompiled with CFR 0.152.
 */
package org.schabi.newpipe.extractor.services.soundcloud;

import com.grack.nanojson.JsonObject;
import org.schabi.newpipe.extractor.exceptions.ParsingException;
import org.schabi.newpipe.extractor.playlist.PlaylistInfoItemExtractor;

public class SoundcloudPlaylistInfoItemExtractor
implements PlaylistInfoItemExtractor {
    private static final String USER_KEY = "user";
    private static final String AVATAR_URL_KEY = "avatar_url";
    private static final String ARTWORK_URL_KEY = "artwork_url";
    private JsonObject searchResult;

    public SoundcloudPlaylistInfoItemExtractor(JsonObject searchResult) {
        this.searchResult = searchResult;
    }

    @Override
    public String getName() throws ParsingException {
        return this.searchResult.getString("title");
    }

    @Override
    public String getUrl() throws ParsingException {
        return this.searchResult.getString("permalink_url");
    }

    @Override
    public String getThumbnailUrl() throws ParsingException {
        Object artworkUrl22;
        if (this.searchResult.isString(ARTWORK_URL_KEY) && !((String)(artworkUrl22 = this.searchResult.getString(ARTWORK_URL_KEY, ""))).isEmpty()) {
            return artworkUrl22;
        }
        try {
            for (Object track : this.searchResult.getArray("tracks")) {
                String url;
                JsonObject trackObject = (JsonObject)track;
                if (trackObject.isString(ARTWORK_URL_KEY) && !(url = trackObject.getString(ARTWORK_URL_KEY, "")).isEmpty()) {
                    return url;
                }
                JsonObject creator = trackObject.getObject(USER_KEY, new JsonObject());
                String creatorAvatar = creator.getString(AVATAR_URL_KEY, "");
                if (creatorAvatar.isEmpty()) continue;
                return creatorAvatar;
            }
        }
        catch (Exception artworkUrl22) {
            // empty catch block
        }
        try {
            return this.searchResult.getObject(USER_KEY).getString(AVATAR_URL_KEY, "");
        }
        catch (Exception e) {
            throw new ParsingException("Failed to extract playlist thumbnail url", e);
        }
    }

    @Override
    public String getUploaderName() throws ParsingException {
        try {
            return this.searchResult.getObject(USER_KEY).getString("username");
        }
        catch (Exception e) {
            throw new ParsingException("Failed to extract playlist uploader", e);
        }
    }

    @Override
    public long getStreamCount() throws ParsingException {
        return this.searchResult.getNumber("track_count", (Number)0).longValue();
    }
}

