/*
 * Decompiled with CFR 0.152.
 */
package org.schabi.newpipe.extractor.services.soundcloud;

import com.grack.nanojson.JsonObject;
import com.grack.nanojson.JsonParser;
import com.grack.nanojson.JsonParserException;
import java.io.IOException;
import org.schabi.newpipe.extractor.Downloader;
import org.schabi.newpipe.extractor.ListExtractor;
import org.schabi.newpipe.extractor.NewPipe;
import org.schabi.newpipe.extractor.StreamingService;
import org.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.schabi.newpipe.extractor.exceptions.ParsingException;
import org.schabi.newpipe.extractor.playlist.PlaylistExtractor;
import org.schabi.newpipe.extractor.services.soundcloud.SoundcloudParsingHelper;
import org.schabi.newpipe.extractor.stream.StreamInfoItemCollector;

public class SoundcloudPlaylistExtractor
extends PlaylistExtractor {
    private String playlistId;
    private JsonObject playlist;

    public SoundcloudPlaylistExtractor(StreamingService service, String url, String nextStreamsUrl) throws IOException, ExtractionException {
        super(service, url, nextStreamsUrl);
    }

    @Override
    public void fetchPage() throws IOException, ExtractionException {
        Downloader dl = NewPipe.getDownloader();
        this.playlistId = this.getUrlIdHandler().getId(this.getOriginalUrl());
        String apiUrl = "https://api.soundcloud.com/playlists/" + this.playlistId + "?client_id=" + SoundcloudParsingHelper.clientId() + "&representation=compact";
        String response = dl.download(apiUrl);
        try {
            this.playlist = (JsonObject)JsonParser.object().from(response);
        }
        catch (JsonParserException e) {
            throw new ParsingException("Could not parse json response", e);
        }
    }

    @Override
    public String getCleanUrl() {
        return this.playlist.isString("permalink_url") ? this.playlist.getString("permalink_url") : this.getOriginalUrl();
    }

    @Override
    public String getId() {
        return this.playlistId;
    }

    @Override
    public String getName() {
        return this.playlist.getString("title");
    }

    @Override
    public String getThumbnailUrl() {
        return this.playlist.getString("artwork_url");
    }

    @Override
    public String getBannerUrl() {
        return null;
    }

    @Override
    public String getUploaderUrl() {
        return this.playlist.getObject("user").getString("permalink_url", "");
    }

    @Override
    public String getUploaderName() {
        return this.playlist.getObject("user").getString("username", "");
    }

    @Override
    public String getUploaderAvatarUrl() {
        return this.playlist.getObject("user", new JsonObject()).getString("avatar_url", "");
    }

    @Override
    public long getStreamCount() {
        return this.playlist.getNumber("track_count", (Number)0).longValue();
    }

    @Override
    public StreamInfoItemCollector getStreams() throws IOException, ExtractionException {
        StreamInfoItemCollector collector = new StreamInfoItemCollector(this.getServiceId());
        String apiUrl = "https://api.soundcloud.com/playlists/" + this.getId() + "/tracks?client_id=" + SoundcloudParsingHelper.clientId() + "&limit=20&linked_partitioning=1";
        this.nextStreamsUrl = SoundcloudParsingHelper.getStreamsFromApiMinItems(15, collector, apiUrl);
        return collector;
    }

    @Override
    public ListExtractor.NextItemsResult getNextStreams() throws IOException, ExtractionException {
        if (!this.hasMoreStreams()) {
            throw new ExtractionException("Playlist doesn't have more streams");
        }
        StreamInfoItemCollector collector = new StreamInfoItemCollector(this.getServiceId());
        this.nextStreamsUrl = SoundcloudParsingHelper.getStreamsFromApiMinItems(15, collector, this.nextStreamsUrl);
        return new ListExtractor.NextItemsResult(collector, this.nextStreamsUrl);
    }
}

