/*
 * Decompiled with CFR 0.152.
 */
package org.schabi.newpipe.extractor.services.soundcloud;

import com.grack.nanojson.JsonArray;
import com.grack.nanojson.JsonObject;
import com.grack.nanojson.JsonParser;
import com.grack.nanojson.JsonParserException;
import java.io.IOException;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.schabi.newpipe.extractor.Downloader;
import org.schabi.newpipe.extractor.NewPipe;
import org.schabi.newpipe.extractor.exceptions.ParsingException;
import org.schabi.newpipe.extractor.exceptions.ReCaptchaException;
import org.schabi.newpipe.extractor.services.soundcloud.SoundcloudStreamInfoItemExtractor;
import org.schabi.newpipe.extractor.stream.StreamInfoItemCollector;
import org.schabi.newpipe.extractor.utils.Parser;

public class SoundcloudParsingHelper {
    private static String clientId;

    private SoundcloudParsingHelper() {
    }

    public static String clientId() throws ReCaptchaException, IOException, Parser.RegexException {
        if (clientId != null && !clientId.isEmpty()) {
            return clientId;
        }
        Downloader dl = NewPipe.getDownloader();
        String response = dl.download("https://soundcloud.com");
        Document doc = Jsoup.parse((String)response);
        Element jsElement = doc.select("script[src^=https://a-v2.sndcdn.com/assets/app]").first();
        String js = dl.download(jsElement.attr("src"));
        clientId = Parser.matchGroup1(",client_id:\"(.*?)\"", js);
        return clientId;
    }

    public static String toDateString(String time) throws ParsingException {
        try {
            Date date;
            try {
                date = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").parse(time);
            }
            catch (Exception e) {
                date = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss +0000").parse(time);
            }
            SimpleDateFormat newDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            return newDateFormat.format(date);
        }
        catch (ParseException e) {
            throw new ParsingException(e.getMessage(), e);
        }
    }

    public static JsonObject resolveFor(String url) throws IOException, ReCaptchaException, ParsingException {
        String apiUrl = "https://api.soundcloud.com/resolve?url=" + URLEncoder.encode(url, "UTF-8") + "&client_id=" + SoundcloudParsingHelper.clientId();
        try {
            return (JsonObject)JsonParser.object().from(NewPipe.getDownloader().download(apiUrl));
        }
        catch (JsonParserException e) {
            throw new ParsingException("Could not parse json response", e);
        }
    }

    public static String resolveUrlWithEmbedPlayer(String apiUrl) throws IOException, ReCaptchaException, ParsingException {
        String response = NewPipe.getDownloader().download("https://w.soundcloud.com/player/?url=" + URLEncoder.encode(apiUrl, "UTF-8"));
        return Jsoup.parse((String)response).select("link[rel=\"canonical\"]").first().attr("abs:href");
    }

    public static String resolveIdWithEmbedPlayer(String url) throws IOException, ReCaptchaException, ParsingException {
        String response = NewPipe.getDownloader().download("https://w.soundcloud.com/player/?url=" + URLEncoder.encode(url, "UTF-8"));
        return Parser.matchGroup1(",\"id\":(.*?),", response);
    }

    public static String getStreamsFromApiMinItems(int minItems, StreamInfoItemCollector collector, String apiUrl) throws IOException, ReCaptchaException, ParsingException {
        String nextStreamsUrl = SoundcloudParsingHelper.getStreamsFromApi(collector, apiUrl);
        while (!nextStreamsUrl.isEmpty() && collector.getItemList().size() < minItems) {
            nextStreamsUrl = SoundcloudParsingHelper.getStreamsFromApi(collector, nextStreamsUrl);
        }
        return nextStreamsUrl;
    }

    public static String getStreamsFromApi(StreamInfoItemCollector collector, String apiUrl, boolean charts) throws IOException, ReCaptchaException, ParsingException {
        String nextStreamsUrl;
        JsonObject responseObject;
        String response = NewPipe.getDownloader().download(apiUrl);
        try {
            responseObject = (JsonObject)JsonParser.object().from(response);
        }
        catch (JsonParserException e) {
            throw new ParsingException("Could not parse json response", e);
        }
        JsonArray responseCollection = responseObject.getArray("collection");
        for (Object o : responseCollection) {
            if (!(o instanceof JsonObject)) continue;
            JsonObject object = (JsonObject)o;
            collector.commit(new SoundcloudStreamInfoItemExtractor(charts ? object.getObject("track") : object));
        }
        try {
            nextStreamsUrl = responseObject.getString("next_href");
            if (!nextStreamsUrl.contains("client_id=")) {
                nextStreamsUrl = nextStreamsUrl + "&client_id=" + SoundcloudParsingHelper.clientId();
            }
        }
        catch (Exception ignored) {
            nextStreamsUrl = "";
        }
        return nextStreamsUrl;
    }

    public static String getStreamsFromApi(StreamInfoItemCollector collector, String apiUrl) throws ReCaptchaException, ParsingException, IOException {
        return SoundcloudParsingHelper.getStreamsFromApi(collector, apiUrl, false);
    }
}

