/*
 * Decompiled with CFR 0.152.
 */
package org.schabi.newpipe.extractor.services.soundcloud;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.schabi.newpipe.extractor.ListExtractor;
import org.schabi.newpipe.extractor.StreamingService;
import org.schabi.newpipe.extractor.UrlIdHandler;
import org.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.schabi.newpipe.extractor.exceptions.ParsingException;
import org.schabi.newpipe.extractor.kiosk.KioskExtractor;
import org.schabi.newpipe.extractor.services.soundcloud.SoundcloudChartsUrlIdHandler;
import org.schabi.newpipe.extractor.services.soundcloud.SoundcloudParsingHelper;
import org.schabi.newpipe.extractor.stream.StreamInfoItemCollector;

public class SoundcloudChartsExtractor
extends KioskExtractor {
    private String url;

    public SoundcloudChartsExtractor(StreamingService service, String url, String nextStreamsUrl, String kioskId) throws IOException, ExtractionException {
        super(service, url, nextStreamsUrl, kioskId);
        this.url = url;
    }

    @Override
    public void fetchPage() {
    }

    @Override
    public String getName() throws ParsingException {
        return "< Implement me (\u2665_\u2665) >";
    }

    @Override
    public UrlIdHandler getUrlIdHandler() {
        return new SoundcloudChartsUrlIdHandler();
    }

    @Override
    public ListExtractor.NextItemsResult getNextStreams() throws IOException, ExtractionException {
        if (!this.hasMoreStreams()) {
            throw new ExtractionException("Chart doesn't have more streams");
        }
        StreamInfoItemCollector collector = new StreamInfoItemCollector(this.getServiceId());
        this.nextStreamsUrl = SoundcloudParsingHelper.getStreamsFromApi(collector, this.nextStreamsUrl, true);
        return new ListExtractor.NextItemsResult(collector, this.nextStreamsUrl);
    }

    @Override
    public StreamInfoItemCollector getStreams() throws IOException, ExtractionException {
        String contentCountry;
        StreamInfoItemCollector collector = new StreamInfoItemCollector(this.getServiceId());
        String apiUrl = "https://api-v2.soundcloud.com/charts?genre=soundcloud:genres:all-music&client_id=" + SoundcloudParsingHelper.clientId();
        apiUrl = this.getId().equals("Top 50") ? apiUrl + "&kind=top" : apiUrl + "&kind=new";
        List<String> supportedCountries = Arrays.asList("AU", "CA", "FR", "DE", "IE", "NL", "NZ", "GB", "US");
        if (supportedCountries.contains(contentCountry = this.getContentCountry())) {
            apiUrl = apiUrl + "&region=soundcloud:regions:" + contentCountry;
        }
        this.nextStreamsUrl = SoundcloudParsingHelper.getStreamsFromApi(collector, apiUrl, true);
        return collector;
    }
}

