/*
 * Decompiled with CFR 0.152.
 */
package org.schabi.newpipe.extractor.services.soundcloud;

import com.grack.nanojson.JsonObject;
import com.grack.nanojson.JsonParser;
import com.grack.nanojson.JsonParserException;
import java.io.IOException;
import org.schabi.newpipe.extractor.Downloader;
import org.schabi.newpipe.extractor.ListExtractor;
import org.schabi.newpipe.extractor.NewPipe;
import org.schabi.newpipe.extractor.StreamingService;
import org.schabi.newpipe.extractor.channel.ChannelExtractor;
import org.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.schabi.newpipe.extractor.exceptions.ParsingException;
import org.schabi.newpipe.extractor.services.soundcloud.SoundcloudParsingHelper;
import org.schabi.newpipe.extractor.stream.StreamInfoItemCollector;

public class SoundcloudChannelExtractor
extends ChannelExtractor {
    private String userId;
    private JsonObject user;

    public SoundcloudChannelExtractor(StreamingService service, String url, String nextStreamsUrl) throws IOException, ExtractionException {
        super(service, url, nextStreamsUrl);
    }

    @Override
    public void fetchPage() throws IOException, ExtractionException {
        Downloader dl = NewPipe.getDownloader();
        this.userId = this.getUrlIdHandler().getId(this.getOriginalUrl());
        String apiUrl = "https://api.soundcloud.com/users/" + this.userId + "?client_id=" + SoundcloudParsingHelper.clientId();
        String response = dl.download(apiUrl);
        try {
            this.user = (JsonObject)JsonParser.object().from(response);
        }
        catch (JsonParserException e) {
            throw new ParsingException("Could not parse json response", e);
        }
    }

    @Override
    public String getCleanUrl() {
        return this.user.isString("permalink_url") ? this.user.getString("permalink_url") : this.getOriginalUrl();
    }

    @Override
    public String getId() {
        return this.userId;
    }

    @Override
    public String getName() {
        return this.user.getString("username");
    }

    @Override
    public String getAvatarUrl() {
        return this.user.getString("avatar_url");
    }

    @Override
    public String getBannerUrl() {
        try {
            return this.user.getObject("visuals").getArray("visuals").getObject(0).getString("visual_url", "");
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    @Override
    public String getFeedUrl() {
        return null;
    }

    @Override
    public long getSubscriberCount() {
        return this.user.getNumber("followers_count", (Number)0).longValue();
    }

    @Override
    public String getDescription() throws ParsingException {
        return this.user.getString("description", "");
    }

    @Override
    public StreamInfoItemCollector getStreams() throws IOException, ExtractionException {
        StreamInfoItemCollector collector = new StreamInfoItemCollector(this.getServiceId());
        String apiUrl = "https://api-v2.soundcloud.com/users/" + this.getId() + "/tracks?client_id=" + SoundcloudParsingHelper.clientId() + "&limit=20&linked_partitioning=1";
        this.nextStreamsUrl = SoundcloudParsingHelper.getStreamsFromApiMinItems(15, collector, apiUrl);
        return collector;
    }

    @Override
    public ListExtractor.NextItemsResult getNextStreams() throws IOException, ExtractionException {
        if (!this.hasMoreStreams()) {
            throw new ExtractionException("Channel doesn't have more streams");
        }
        StreamInfoItemCollector collector = new StreamInfoItemCollector(this.getServiceId());
        this.nextStreamsUrl = SoundcloudParsingHelper.getStreamsFromApiMinItems(15, collector, this.nextStreamsUrl);
        return new ListExtractor.NextItemsResult(collector, this.nextStreamsUrl);
    }
}

