/*
 * Decompiled with CFR 0.152.
 */
package org.schabi.newpipe.extractor.search;

import org.schabi.newpipe.extractor.InfoItemCollector;
import org.schabi.newpipe.extractor.channel.ChannelInfoItemCollector;
import org.schabi.newpipe.extractor.channel.ChannelInfoItemExtractor;
import org.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.schabi.newpipe.extractor.exceptions.FoundAdException;
import org.schabi.newpipe.extractor.playlist.PlaylistInfoItemCollector;
import org.schabi.newpipe.extractor.playlist.PlaylistInfoItemExtractor;
import org.schabi.newpipe.extractor.search.SearchResult;
import org.schabi.newpipe.extractor.stream.StreamInfoItemCollector;
import org.schabi.newpipe.extractor.stream.StreamInfoItemExtractor;

public class InfoItemSearchCollector
extends InfoItemCollector {
    private String suggestion = "";
    private StreamInfoItemCollector streamCollector;
    private ChannelInfoItemCollector userCollector;
    private PlaylistInfoItemCollector playlistCollector;
    private SearchResult result = new SearchResult();

    InfoItemSearchCollector(int serviceId) {
        super(serviceId);
        this.streamCollector = new StreamInfoItemCollector(serviceId);
        this.userCollector = new ChannelInfoItemCollector(serviceId);
        this.playlistCollector = new PlaylistInfoItemCollector(serviceId);
    }

    public void setSuggestion(String suggestion) {
        this.suggestion = suggestion;
    }

    public SearchResult getSearchResult() throws ExtractionException {
        this.addFromCollector(this.userCollector);
        this.addFromCollector(this.streamCollector);
        this.addFromCollector(this.playlistCollector);
        this.result.suggestion = this.suggestion;
        this.result.errors = this.getErrors();
        return this.result;
    }

    public void commit(StreamInfoItemExtractor extractor) {
        try {
            this.result.resultList.add(this.streamCollector.extract(extractor));
        }
        catch (FoundAdException ae) {
            System.err.println("Found ad");
        }
        catch (Exception e) {
            this.addError(e);
        }
    }

    public void commit(ChannelInfoItemExtractor extractor) {
        try {
            this.result.resultList.add(this.userCollector.extract(extractor));
        }
        catch (FoundAdException ae) {
            System.err.println("Found ad");
        }
        catch (Exception e) {
            this.addError(e);
        }
    }

    public void commit(PlaylistInfoItemExtractor extractor) {
        try {
            this.result.resultList.add(this.playlistCollector.extract(extractor));
        }
        catch (FoundAdException ae) {
            System.err.println("Found ad");
        }
        catch (Exception e) {
            this.addError(e);
        }
    }
}

