/*
 * Decompiled with CFR 0.152.
 */
package org.schabi.newpipe.extractor.playlist;

import org.schabi.newpipe.extractor.InfoItemCollector;
import org.schabi.newpipe.extractor.exceptions.ParsingException;
import org.schabi.newpipe.extractor.playlist.PlaylistInfoItem;
import org.schabi.newpipe.extractor.playlist.PlaylistInfoItemExtractor;

public class PlaylistInfoItemCollector
extends InfoItemCollector {
    public PlaylistInfoItemCollector(int serviceId) {
        super(serviceId);
    }

    public PlaylistInfoItem extract(PlaylistInfoItemExtractor extractor) throws ParsingException {
        PlaylistInfoItem resultItem = new PlaylistInfoItem();
        resultItem.name = extractor.getName();
        resultItem.service_id = this.getServiceId();
        resultItem.url = extractor.getUrl();
        try {
            resultItem.uploader_name = extractor.getUploaderName();
        }
        catch (Exception e) {
            this.addError(e);
        }
        try {
            resultItem.thumbnail_url = extractor.getThumbnailUrl();
        }
        catch (Exception e) {
            this.addError(e);
        }
        try {
            resultItem.stream_count = extractor.getStreamCount();
        }
        catch (Exception e) {
            this.addError(e);
        }
        return resultItem;
    }

    public void commit(PlaylistInfoItemExtractor extractor) throws ParsingException {
        try {
            this.addItem(this.extract(extractor));
        }
        catch (Exception e) {
            this.addError(e);
        }
    }
}

