/*
 * Decompiled with CFR 0.152.
 */
package org.schabi.newpipe.extractor.channel;

import java.io.IOException;
import java.util.ArrayList;
import org.schabi.newpipe.extractor.ListExtractor;
import org.schabi.newpipe.extractor.ListInfo;
import org.schabi.newpipe.extractor.NewPipe;
import org.schabi.newpipe.extractor.ServiceList;
import org.schabi.newpipe.extractor.StreamingService;
import org.schabi.newpipe.extractor.channel.ChannelExtractor;
import org.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.schabi.newpipe.extractor.exceptions.ParsingException;
import org.schabi.newpipe.extractor.stream.StreamInfoItemCollector;

public class ChannelInfo
extends ListInfo {
    public String avatar_url;
    public String banner_url;
    public String feed_url;
    public long subscriber_count = -1L;
    public String description;

    public static ListExtractor.NextItemsResult getMoreItems(ServiceList serviceItem, String url, String nextStreamsUrl) throws IOException, ExtractionException {
        return ChannelInfo.getMoreItems(serviceItem.getService(), url, nextStreamsUrl);
    }

    public static ListExtractor.NextItemsResult getMoreItems(StreamingService service, String url, String nextStreamsUrl) throws IOException, ExtractionException {
        return service.getChannelExtractor(url, nextStreamsUrl).getNextStreams();
    }

    public static ChannelInfo getInfo(String url) throws IOException, ExtractionException {
        return ChannelInfo.getInfo(NewPipe.getServiceByUrl(url), url);
    }

    public static ChannelInfo getInfo(ServiceList serviceItem, String url) throws IOException, ExtractionException {
        return ChannelInfo.getInfo(serviceItem.getService(), url);
    }

    public static ChannelInfo getInfo(StreamingService service, String url) throws IOException, ExtractionException {
        return ChannelInfo.getInfo(service.getChannelExtractor(url));
    }

    public static ChannelInfo getInfo(ChannelExtractor extractor) throws ParsingException {
        ChannelInfo info = new ChannelInfo();
        info.service_id = extractor.getServiceId();
        info.url = extractor.getCleanUrl();
        info.id = extractor.getId();
        info.name = extractor.getName();
        try {
            info.avatar_url = extractor.getAvatarUrl();
        }
        catch (Exception e) {
            info.errors.add(e);
        }
        try {
            info.banner_url = extractor.getBannerUrl();
        }
        catch (Exception e) {
            info.errors.add(e);
        }
        try {
            info.feed_url = extractor.getFeedUrl();
        }
        catch (Exception e) {
            info.errors.add(e);
        }
        try {
            StreamInfoItemCollector c = extractor.getStreams();
            info.related_streams = c.getItemList();
            info.errors.addAll(c.getErrors());
        }
        catch (Exception e) {
            info.errors.add(e);
        }
        try {
            info.subscriber_count = extractor.getSubscriberCount();
        }
        catch (Exception e) {
            info.errors.add(e);
        }
        try {
            info.description = extractor.getDescription();
        }
        catch (Exception e) {
            info.errors.add(e);
        }
        if (info.related_streams == null) {
            info.related_streams = new ArrayList();
        }
        info.has_more_streams = extractor.hasMoreStreams();
        info.next_streams_url = extractor.getNextStreamsUrl();
        return info;
    }
}

