/*
 * Decompiled with CFR 0.152.
 */
package org.schabi.newpipe.extractor;

import java.io.IOException;
import org.schabi.newpipe.extractor.SuggestionExtractor;
import org.schabi.newpipe.extractor.UrlIdHandler;
import org.schabi.newpipe.extractor.channel.ChannelExtractor;
import org.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.schabi.newpipe.extractor.kiosk.KioskList;
import org.schabi.newpipe.extractor.playlist.PlaylistExtractor;
import org.schabi.newpipe.extractor.search.SearchEngine;
import org.schabi.newpipe.extractor.stream.StreamExtractor;

public abstract class StreamingService {
    private final int serviceId;
    private final ServiceInfo serviceInfo;

    public StreamingService(int id, String name) {
        this.serviceId = id;
        this.serviceInfo = new ServiceInfo(name);
    }

    public final int getServiceId() {
        return this.serviceId;
    }

    public ServiceInfo getServiceInfo() {
        return this.serviceInfo;
    }

    public abstract UrlIdHandler getStreamUrlIdHandler();

    public abstract UrlIdHandler getChannelUrlIdHandler();

    public abstract UrlIdHandler getPlaylistUrlIdHandler();

    public abstract SearchEngine getSearchEngine();

    public abstract SuggestionExtractor getSuggestionExtractor();

    public abstract StreamExtractor getStreamExtractor(String var1) throws IOException, ExtractionException;

    public abstract ChannelExtractor getChannelExtractor(String var1, String var2) throws IOException, ExtractionException;

    public abstract PlaylistExtractor getPlaylistExtractor(String var1, String var2) throws IOException, ExtractionException;

    public abstract KioskList getKioskList() throws ExtractionException;

    public ChannelExtractor getChannelExtractor(String url) throws IOException, ExtractionException {
        return this.getChannelExtractor(url, null);
    }

    public PlaylistExtractor getPlaylistExtractor(String url) throws IOException, ExtractionException {
        return this.getPlaylistExtractor(url, null);
    }

    public final LinkType getLinkTypeByUrl(String url) {
        UrlIdHandler sH = this.getStreamUrlIdHandler();
        UrlIdHandler cH = this.getChannelUrlIdHandler();
        UrlIdHandler pH = this.getPlaylistUrlIdHandler();
        if (sH.acceptUrl(url)) {
            return LinkType.STREAM;
        }
        if (cH.acceptUrl(url)) {
            return LinkType.CHANNEL;
        }
        if (pH.acceptUrl(url)) {
            return LinkType.PLAYLIST;
        }
        return LinkType.NONE;
    }

    public static enum LinkType {
        NONE,
        STREAM,
        CHANNEL,
        PLAYLIST;

    }

    public class ServiceInfo {
        public final String name;

        public ServiceInfo(String name) {
            this.name = name;
        }
    }
}

