/*
 * Decompiled with CFR 0.152.
 */
package org.schabi.newpipe.extractor;

public enum MediaFormat {
    MPEG_4(0, "MPEG-4", "mp4", "video/mp4"),
    v3GPP(1, "3GPP", "3gp", "video/3gpp"),
    WEBM(2, "WebM", "webm", "video/webm"),
    M4A(3, "m4a", "m4a", "audio/mp4"),
    WEBMA(4, "WebM", "webm", "audio/webm"),
    MP3(5, "MP3", "mp3", "audio/mpeg");

    public final int id;
    public final String name;
    public final String suffix;
    public final String mimeType;

    private MediaFormat(int id, String name, String suffix, String mimeType) {
        this.id = id;
        this.name = name;
        this.suffix = suffix;
        this.mimeType = mimeType;
    }

    public static String getNameById(int ident) {
        for (MediaFormat vf : MediaFormat.values()) {
            if (vf.id != ident) continue;
            return vf.name;
        }
        return "";
    }

    public static String getSuffixById(int ident) {
        for (MediaFormat vf : MediaFormat.values()) {
            if (vf.id != ident) continue;
            return vf.suffix;
        }
        return "";
    }

    public static String getMimeById(int ident) {
        for (MediaFormat vf : MediaFormat.values()) {
            if (vf.id != ident) continue;
            return vf.mimeType;
        }
        return "";
    }

    public static MediaFormat getFromMimeType(String mimeType) {
        for (MediaFormat vf : MediaFormat.values()) {
            if (!vf.mimeType.equals(mimeType)) continue;
            return vf;
        }
        return null;
    }
}

