/*
 * Decompiled with CFR 0.152.
 */
package net.rithms.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;

public final class RiotApiUtil {
    public static String normalizeSummonerName(String summonerName) {
        Objects.requireNonNull(summonerName);
        summonerName = summonerName.replaceAll("\u0130", "i");
        return summonerName.toLowerCase().replaceAll("\\s+", "");
    }

    public static String[] normalizeSummonerNames(String ... summonerNames) {
        Objects.requireNonNull(summonerNames);
        for (int i = 0; i < summonerNames.length; ++i) {
            summonerNames[i] = RiotApiUtil.normalizeSummonerName(summonerNames[i]);
        }
        return summonerNames;
    }

    public static <T> Map<String, T> normalizeSummonerNames(Map<String, T> summonerNames) {
        Objects.requireNonNull(summonerNames);
        HashMap<String, T> map = new HashMap<String, T>(summonerNames);
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry pair = it.next();
            String normalizedKey = RiotApiUtil.normalizeSummonerName((String)pair.getKey());
            if (((String)pair.getKey()).equals(normalizedKey)) continue;
            it.remove();
            map.put(normalizedKey, pair.getValue());
        }
        return map;
    }

    public static String joinString(CharSequence delimiter, Object ... elements) {
        Objects.requireNonNull(delimiter);
        Objects.requireNonNull(elements);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < elements.length - 1; ++i) {
            sb.append(elements[i]).append(delimiter);
        }
        sb.append(elements[elements.length - 1]);
        return sb.toString();
    }

    public static String joinString(CharSequence delimiter, CharSequence ... elements) {
        return RiotApiUtil.joinString(delimiter, (Object[])elements);
    }

    public static String requireValidSummonerName(String summonerName) throws IllegalArgumentException {
        if (summonerName.trim().isEmpty()) {
            throw new IllegalArgumentException("Invalid summoner name \"" + summonerName + "\"");
        }
        return summonerName;
    }
}

