/*
 * Decompiled with CFR 0.152.
 */
package net.rithms.riot.constant;

import java.util.NoSuchElementException;
import net.rithms.riot.api.RiotApi;

public enum Platform {
    BR("BR1", "br"),
    EUNE("EUN1", "eune"),
    EUW("EUW1", "euw"),
    JP("JP1", "jp"),
    KR("KR", "kr"),
    LAN("LA1", "lan"),
    LAS("LA2", "las"),
    NA("NA1", "na"),
    OCE("OC1", "oce"),
    RU("RU", "ru"),
    TR("TR1", "tr");

    private String id;
    private String name;

    public static Platform getPlatformById(String id) {
        for (Platform platform : Platform.values()) {
            if (!platform.getId().toLowerCase().equals(id.toLowerCase())) continue;
            return platform;
        }
        RiotApi.log.warning("Unknown platform ID: " + id);
        throw new NoSuchElementException("Unknown platform ID: " + id);
    }

    public static Platform getPlatformByName(String name) {
        for (Platform platform : Platform.values()) {
            if (!platform.getName().toLowerCase().equals(name.toLowerCase())) continue;
            return platform;
        }
        RiotApi.log.warning("Unknown platform name: " + name);
        throw new NoSuchElementException("Unknown platform name: " + name);
    }

    private Platform(String id, String name) {
        this.id = id;
        this.name = name;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getHost() {
        return "https://" + this.getId().toLowerCase() + ".api.riotgames.com";
    }

    public String toString() {
        return this.getId();
    }
}

