/*
 * Decompiled with CFR 0.152.
 */
package net.rithms.riot.api.request.ratelimit;

import net.rithms.riot.api.RiotApiException;

public class RateLimitException
extends RiotApiException {
    private static final long serialVersionUID = 8523329282717166886L;
    private final int retryAfter;
    private final String rateLimitType;

    public RateLimitException(int retryAfter, String rateLimitType) {
        super(429, RateLimitException.getMessage(429) + " (Type: " + rateLimitType + "; Retry After: " + retryAfter + ")");
        this.retryAfter = retryAfter;
        this.rateLimitType = rateLimitType;
    }

    protected RateLimitException(String message, int retryAfter, String rateLimitType) {
        super(429, message);
        this.retryAfter = retryAfter;
        this.rateLimitType = rateLimitType;
    }

    public String getRateLimitType() {
        return this.rateLimitType;
    }

    public int getRetryAfter() {
        return this.retryAfter;
    }
}

