/*
 * Decompiled with CFR 0.152.
 */
package net.rithms.riot.api.request.ratelimit;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.rithms.riot.api.ApiMethod;
import net.rithms.riot.api.RiotApi;
import net.rithms.riot.api.request.Request;
import net.rithms.riot.api.request.RequestResponse;
import net.rithms.riot.api.request.ratelimit.DefaultRateLimitHandler;

public class BufferedRateLimitHandler
extends DefaultRateLimitHandler {
    protected final double threshold;
    protected final int cooldown;

    public BufferedRateLimitHandler(double threshold, int cooldown) {
        this.threshold = threshold;
        this.cooldown = cooldown;
    }

    protected Map<Integer, Integer> getIntervalCountMapFromHeaderField(List<String> headerField) {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        if (headerField != null) {
            for (String rateLimitField : headerField) {
                String[] split = rateLimitField.split(":");
                if (split.length != 2) continue;
                map.put(Integer.valueOf(split[1]), Integer.valueOf(split[0]));
            }
        }
        return map;
    }

    @Override
    public void onRequestDone(Request request) {
        int limit;
        int count;
        int interval;
        super.onRequestDone(request);
        RequestResponse response = request.getResponse();
        ApiMethod object = request.getObject();
        Map<Integer, Integer> appCounts = this.getIntervalCountMapFromHeaderField(response.getHeaderFields().get("X-App-Rate-Limit-Count"));
        Map<Integer, Integer> appLimits = this.getIntervalCountMapFromHeaderField(response.getHeaderFields().get("X-App-Rate-Limit"));
        Map<Integer, Integer> methodCounts = this.getIntervalCountMapFromHeaderField(response.getHeaderFields().get("X-Method-Rate-Limit-Count"));
        Map<Integer, Integer> methodLimits = this.getIntervalCountMapFromHeaderField(response.getHeaderFields().get("X-Method-Rate-Limit"));
        for (Map.Entry<Integer, Integer> entry : appCounts.entrySet()) {
            interval = entry.getKey();
            count = entry.getValue();
            if (!appLimits.containsKey(interval) || !((double)count / (double)(limit = appLimits.get(interval).intValue()) > this.threshold)) continue;
            this.rateLimitList.setRateLimit(object.getPlatform(), object.getService(), object.getClass().getName(), "app", this.cooldown);
            RiotApi.log.fine("[BufferedRateLimitHandler] App limit threshhold " + this.threshold + " exceeded (" + count + "/" + limit + "). Soft rate limiting for " + this.cooldown + "s");
        }
        for (Map.Entry<Integer, Integer> entry : methodCounts.entrySet()) {
            interval = entry.getKey();
            count = entry.getValue();
            if (!methodLimits.containsKey(interval) || !((double)count / (double)(limit = methodLimits.get(interval).intValue()) > this.threshold)) continue;
            this.rateLimitList.setRateLimit(object.getPlatform(), object.getService(), object.getClass().getName(), "app", this.cooldown);
            RiotApi.log.fine("[BufferedRateLimitHandler] Method limit threshhold " + this.threshold + " exceeded (" + count + "/" + limit + ") for " + object.getClass().getName() + ". Soft rate limiting for " + this.cooldown + "s");
        }
    }
}

