/*
 * Decompiled with CFR 0.152.
 */
package net.rithms.riot.api.endpoints.match.dto;

import java.io.Serializable;
import java.util.List;
import net.rithms.riot.api.Dto;
import net.rithms.riot.api.endpoints.match.dto.Participant;
import net.rithms.riot.api.endpoints.match.dto.ParticipantIdentity;
import net.rithms.riot.api.endpoints.match.dto.Player;
import net.rithms.riot.api.endpoints.match.dto.TeamStats;

public class Match
extends Dto
implements Serializable {
    private static final long serialVersionUID = 2606895296338330266L;
    private long gameCreation;
    private long gameDuration;
    private long gameId;
    private String gameMode;
    private String gameType;
    private String gameVersion;
    private int mapId;
    private List<ParticipantIdentity> participantIdentities;
    private List<Participant> participants;
    private String platformId;
    private int queueId;
    private int seasonId;
    private List<TeamStats> teams;

    public long getGameCreation() {
        return this.gameCreation;
    }

    public long getGameDuration() {
        return this.gameDuration;
    }

    public long getGameId() {
        return this.gameId;
    }

    public String getGameMode() {
        return this.gameMode;
    }

    public String getGameType() {
        return this.gameType;
    }

    public String getGameVersion() {
        return this.gameVersion;
    }

    public int getMapId() {
        return this.mapId;
    }

    public Participant getParticipantByAccountId(long accountId) {
        List<ParticipantIdentity> participantIdentities = this.getParticipantIdentities();
        if (participantIdentities != null) {
            for (ParticipantIdentity participantIdentity : participantIdentities) {
                Player player = participantIdentity.getPlayer();
                if (player == null || player.getAccountId() != accountId) continue;
                return this.getParticipantByParticipantId(participantIdentity.getParticipantId());
            }
        }
        return null;
    }

    public Participant getParticipantByParticipantId(int participantId) {
        List<Participant> participants = this.getParticipants();
        if (participants != null) {
            for (Participant participant : participants) {
                if (participant.getParticipantId() != participantId) continue;
                return participant;
            }
        }
        return null;
    }

    public Participant getParticipantBySummonerId(long summonerId) {
        List<ParticipantIdentity> participantIdentities = this.getParticipantIdentities();
        if (participantIdentities != null) {
            for (ParticipantIdentity participantIdentity : participantIdentities) {
                Player player = participantIdentity.getPlayer();
                if (player == null || player.getSummonerId() != summonerId) continue;
                return this.getParticipantByParticipantId(participantIdentity.getParticipantId());
            }
        }
        return null;
    }

    public Participant getParticipantBySummonerName(String summonerName) {
        List<ParticipantIdentity> participantIdentities = this.getParticipantIdentities();
        if (participantIdentities != null) {
            for (ParticipantIdentity participantIdentity : participantIdentities) {
                Player player = participantIdentity.getPlayer();
                if (player == null || !player.getSummonerName().equalsIgnoreCase(summonerName)) continue;
                return this.getParticipantByParticipantId(participantIdentity.getParticipantId());
            }
        }
        return null;
    }

    public List<ParticipantIdentity> getParticipantIdentities() {
        return this.participantIdentities;
    }

    public List<Participant> getParticipants() {
        return this.participants;
    }

    public String getPlatformId() {
        return this.platformId;
    }

    public int getQueueId() {
        return this.queueId;
    }

    public int getSeasonId() {
        return this.seasonId;
    }

    public TeamStats getTeamByTeamId(int teamId) {
        List<TeamStats> teams = this.getTeams();
        if (teams != null) {
            for (TeamStats team : teams) {
                if (team.getTeamId() != teamId) continue;
                return team;
            }
        }
        return null;
    }

    public List<TeamStats> getTeams() {
        return this.teams;
    }

    public String toString() {
        return String.valueOf(this.getGameId());
    }
}

