/*
 * Decompiled with CFR 0.152.
 */
package net.rithms.riot.api;

import net.rithms.riot.api.request.RiotApiError;

public class RiotApiException
extends Exception {
    private static final long serialVersionUID = 2658256159686373725L;
    public static final int BAD_REQUEST = 400;
    public static final int UNAUTHORIZED = 401;
    public static final int FORBIDDEN = 403;
    public static final int DATA_NOT_FOUND = 404;
    public static final int METHOD_NOT_ALLOWED = 405;
    public static final int UNSUPPORTED_MEDIA_TYPE = 415;
    public static final int UNPROCESSABLE_ENTITY = 422;
    public static final int RATE_LIMITED = 429;
    public static final int SERVER_ERROR = 500;
    public static final int NOT_IMPLEMENTED = 501;
    public static final int BAD_GATEWAY = 502;
    public static final int UNAVAILABLE = 503;
    public static final int GATEWAY_TIMEOUT = 504;
    public static final int PARSE_FAILURE = 600;
    public static final int IOEXCEPTION = 601;
    public static final int NULLPOINTEREXCEPTION = 602;
    public static final int TIMEOUT_EXCEPTION = 603;
    public static final int MISSING_API_KEY = 611;
    public static final int MISSING_TOURNAMENT_API_KEY = 612;
    private final int errorCode;
    private final RiotApiError errorDto;

    public RiotApiException(int errorCode, RiotApiError errorDto) {
        this.errorCode = errorCode;
        this.errorDto = errorDto;
    }

    public RiotApiException(int errorCode, String message) {
        super(message);
        this.errorCode = errorCode;
        this.errorDto = null;
    }

    public RiotApiException(int errorCode) {
        this(errorCode, RiotApiException.getMessage(errorCode));
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public RiotApiError getErrorDto() {
        return this.errorDto;
    }

    @Override
    public String getMessage() {
        if (this.errorDto != null) {
            return this.errorDto.toString();
        }
        return super.getMessage();
    }

    public static String getMessage(int errorCode) {
        switch (errorCode) {
            case 502: {
                return "Bad gateway";
            }
            case 400: {
                return "Bad request";
            }
            case 403: {
                return "Forbidden";
            }
            case 404: {
                return "Requested data not found";
            }
            case 504: {
                return "Gateway timeout";
            }
            case 601: {
                return "I/O Exception thrown";
            }
            case 405: {
                return "Method not allowed";
            }
            case 611: {
                return "Api Key is required but missing";
            }
            case 612: {
                return "Tournament Api Key is required but missing";
            }
            case 602: {
                return "NullPointerException thrown";
            }
            case 600: {
                return "Failed to parse the JSON response";
            }
            case 429: {
                return "Rate limit exceeded";
            }
            case 500: {
                return "Internal server error";
            }
            case 603: {
                return "Request timed out";
            }
            case 401: {
                return "Unauthorized";
            }
            case 503: {
                return "Service unavailable";
            }
            case 422: {
                return "Summoner has an entry, but hasn't played since the start of 2013";
            }
            case 415: {
                return "Unsupported media type";
            }
        }
        return "Unknown API error (Code " + errorCode + ")";
    }
}

