/*
 * Decompiled with CFR 0.152.
 */
package net.rithms.riot.api;

import java.util.Objects;
import java.util.Set;
import net.rithms.riot.api.ApiConfig;
import net.rithms.riot.api.ApiMethod;
import net.rithms.riot.api.EndpointManager;
import net.rithms.riot.api.RiotApiException;
import net.rithms.riot.api.endpoints.champion.methods.GetChampion;
import net.rithms.riot.api.endpoints.champion.methods.GetChampions;
import net.rithms.riot.api.endpoints.champion_mastery.methods.GetChampionMasteriesBySummoner;
import net.rithms.riot.api.endpoints.champion_mastery.methods.GetChampionMasteriesBySummonerByChampion;
import net.rithms.riot.api.endpoints.champion_mastery.methods.GetChampionMasteryScoresBySummoner;
import net.rithms.riot.api.endpoints.league.constant.LeagueQueue;
import net.rithms.riot.api.endpoints.league.methods.GetChallengerLeagueByQueue;
import net.rithms.riot.api.endpoints.league.methods.GetLeagueById;
import net.rithms.riot.api.endpoints.league.methods.GetLeaguePositionsBySummonerId;
import net.rithms.riot.api.endpoints.league.methods.GetMasterLeagueByQueue;
import net.rithms.riot.api.endpoints.lol_status.methods.GetShardData;
import net.rithms.riot.api.endpoints.match.methods.GetMatch;
import net.rithms.riot.api.endpoints.match.methods.GetMatchByMatchIdAndTournamentCode;
import net.rithms.riot.api.endpoints.match.methods.GetMatchIdsByTournamentCode;
import net.rithms.riot.api.endpoints.match.methods.GetMatchListByAccountId;
import net.rithms.riot.api.endpoints.match.methods.GetTimelineByMatchId;
import net.rithms.riot.api.endpoints.spectator.methods.GetActiveGameBySummoner;
import net.rithms.riot.api.endpoints.spectator.methods.GetFeaturedGames;
import net.rithms.riot.api.endpoints.static_data.constant.ChampionListTags;
import net.rithms.riot.api.endpoints.static_data.constant.ChampionTags;
import net.rithms.riot.api.endpoints.static_data.constant.ItemListTags;
import net.rithms.riot.api.endpoints.static_data.constant.ItemTags;
import net.rithms.riot.api.endpoints.static_data.constant.Locale;
import net.rithms.riot.api.endpoints.static_data.constant.MasteryListTags;
import net.rithms.riot.api.endpoints.static_data.constant.MasteryTags;
import net.rithms.riot.api.endpoints.static_data.constant.RuneListTags;
import net.rithms.riot.api.endpoints.static_data.constant.RuneTags;
import net.rithms.riot.api.endpoints.static_data.constant.SpellListTags;
import net.rithms.riot.api.endpoints.static_data.constant.SpellTags;
import net.rithms.riot.api.endpoints.static_data.methods.GetDataChampion;
import net.rithms.riot.api.endpoints.static_data.methods.GetDataChampionList;
import net.rithms.riot.api.endpoints.static_data.methods.GetDataItem;
import net.rithms.riot.api.endpoints.static_data.methods.GetDataItemList;
import net.rithms.riot.api.endpoints.static_data.methods.GetDataLanguageStrings;
import net.rithms.riot.api.endpoints.static_data.methods.GetDataLanguages;
import net.rithms.riot.api.endpoints.static_data.methods.GetDataMaps;
import net.rithms.riot.api.endpoints.static_data.methods.GetDataMastery;
import net.rithms.riot.api.endpoints.static_data.methods.GetDataMasteryList;
import net.rithms.riot.api.endpoints.static_data.methods.GetDataProfileIcons;
import net.rithms.riot.api.endpoints.static_data.methods.GetDataRealm;
import net.rithms.riot.api.endpoints.static_data.methods.GetDataReforgedRune;
import net.rithms.riot.api.endpoints.static_data.methods.GetDataReforgedRuneList;
import net.rithms.riot.api.endpoints.static_data.methods.GetDataReforgedRunePath;
import net.rithms.riot.api.endpoints.static_data.methods.GetDataReforgedRunePathList;
import net.rithms.riot.api.endpoints.static_data.methods.GetDataRune;
import net.rithms.riot.api.endpoints.static_data.methods.GetDataRuneList;
import net.rithms.riot.api.endpoints.static_data.methods.GetDataSummonerSpell;
import net.rithms.riot.api.endpoints.static_data.methods.GetDataSummonerSpellList;
import net.rithms.riot.api.endpoints.static_data.methods.GetDataTarballLinks;
import net.rithms.riot.api.endpoints.static_data.methods.GetDataVersions;
import net.rithms.riot.api.endpoints.summoner.methods.GetSummoner;
import net.rithms.riot.api.endpoints.summoner.methods.GetSummonerByAccount;
import net.rithms.riot.api.endpoints.summoner.methods.GetSummonerByName;
import net.rithms.riot.api.endpoints.third_party_code.methods.GetThirdPartyCodeBySummoner;
import net.rithms.riot.api.endpoints.tournament.constant.PickType;
import net.rithms.riot.api.endpoints.tournament.constant.SpectatorType;
import net.rithms.riot.api.endpoints.tournament.constant.TournamentMap;
import net.rithms.riot.api.endpoints.tournament.methods.CreateTournament;
import net.rithms.riot.api.endpoints.tournament.methods.CreateTournamentCodes;
import net.rithms.riot.api.endpoints.tournament.methods.CreateTournamentProvider;
import net.rithms.riot.api.endpoints.tournament.methods.GetLobbyEventsByCode;
import net.rithms.riot.api.endpoints.tournament.methods.GetTournamentCode;
import net.rithms.riot.api.endpoints.tournament.methods.UpdateTournamentCode;
import net.rithms.riot.api.request.AsyncRequest;
import net.rithms.riot.api.request.RequestListener;
import net.rithms.riot.constant.Platform;
import net.rithms.util.RiotApiUtil;

public class RiotApiAsync {
    private final ApiConfig config;
    private final EndpointManager endpointManager;

    RiotApiAsync(ApiConfig config, EndpointManager endpointManager) {
        this.config = config;
        this.endpointManager = endpointManager;
    }

    public void addListeners(RequestListener ... listeners) {
        this.endpointManager.addListeners(listeners);
    }

    public void awaitAll() throws InterruptedException {
        this.endpointManager.awaitAll();
    }

    public AsyncRequest callCustomApiMethod(ApiMethod method) throws RiotApiException {
        Objects.requireNonNull(method);
        return this.endpointManager.callMethodAsynchronously(method);
    }

    public AsyncRequest createTournament(String tournamentName, int providerId) {
        CreateTournament method = new CreateTournament(this.getConfig(), tournamentName, providerId);
        return this.endpointManager.callMethodAsynchronously(method);
    }

    public AsyncRequest createTournament(int providerId) {
        return this.createTournament(null, providerId);
    }

    public AsyncRequest createTournamentCodes(int tournamentId, int count, int teamSize, TournamentMap mapType, PickType pickType, SpectatorType spectatorType, String metaData, long ... allowedSummonerIds) {
        Objects.requireNonNull(mapType);
        Objects.requireNonNull(pickType);
        Objects.requireNonNull(spectatorType);
        CreateTournamentCodes method = new CreateTournamentCodes(this.getConfig(), tournamentId, count, teamSize, mapType, pickType, spectatorType, metaData, allowedSummonerIds);
        return this.endpointManager.callMethodAsynchronously(method);
    }

    public AsyncRequest createTournamentCodes(int tournamentId, int count, int teamSize, TournamentMap mapType, PickType pickType, SpectatorType spectatorType, long ... allowedSummonerIds) {
        return this.createTournamentCodes(tournamentId, count, teamSize, mapType, pickType, spectatorType, null, allowedSummonerIds);
    }

    public AsyncRequest createTournamentProvider(String region, String callbackUrl) {
        Objects.requireNonNull(region);
        Objects.requireNonNull(callbackUrl);
        CreateTournamentProvider method = new CreateTournamentProvider(this.getConfig(), region, callbackUrl);
        return this.endpointManager.callMethodAsynchronously(method);
    }

    public AsyncRequest getActiveGameBySummoner(Platform platform, long summonerId) {
        Objects.requireNonNull(platform);
        Objects.requireNonNull(summonerId);
        GetActiveGameBySummoner method = new GetActiveGameBySummoner(this.getConfig(), platform, summonerId);
        return this.endpointManager.callMethodAsynchronously(method);
    }

    public AsyncRequest getChallengerLeagueByQueue(Platform platform, String queue) {
        Objects.requireNonNull(platform);
        Objects.requireNonNull(queue);
        GetChallengerLeagueByQueue method = new GetChallengerLeagueByQueue(this.getConfig(), platform, queue);
        return this.endpointManager.callMethodAsynchronously(method);
    }

    public AsyncRequest getChallengerLeagueByQueue(Platform platform, LeagueQueue queue) {
        Objects.requireNonNull(queue);
        return this.getChallengerLeagueByQueue(platform, queue.toString());
    }

    public AsyncRequest getChampion(Platform platform, int id) {
        Objects.requireNonNull(platform);
        GetChampion method = new GetChampion(this.getConfig(), platform, id);
        return this.endpointManager.callMethodAsynchronously(method);
    }

    public AsyncRequest getChampionMasteriesBySummoner(Platform platform, long summonerId) {
        Objects.requireNonNull(platform);
        GetChampionMasteriesBySummoner method = new GetChampionMasteriesBySummoner(this.getConfig(), platform, summonerId);
        return this.endpointManager.callMethodAsynchronously(method);
    }

    public AsyncRequest getChampionMasteriesBySummonerByChampion(Platform platform, long summonerId, int championId) {
        Objects.requireNonNull(platform);
        GetChampionMasteriesBySummonerByChampion method = new GetChampionMasteriesBySummonerByChampion(this.getConfig(), platform, summonerId, championId);
        return this.endpointManager.callMethodAsynchronously(method);
    }

    public AsyncRequest getChampionMasteryScoresBySummoner(Platform platform, long summonerId) {
        Objects.requireNonNull(platform);
        GetChampionMasteryScoresBySummoner method = new GetChampionMasteryScoresBySummoner(this.getConfig(), platform, summonerId);
        return this.endpointManager.callMethodAsynchronously(method);
    }

    public AsyncRequest getChampions(Platform platform, boolean freeToPlay) {
        Objects.requireNonNull(platform);
        GetChampions method = new GetChampions(this.getConfig(), platform, freeToPlay);
        return this.endpointManager.callMethodAsynchronously(method);
    }

    public AsyncRequest getChampions(Platform platform) {
        return this.getChampions(platform, false);
    }

    protected ApiConfig getConfig() {
        return this.config;
    }

    public AsyncRequest getDataChampion(Platform platform, int id, Locale locale, String version, ChampionTags ... tags) {
        Objects.requireNonNull(platform);
        GetDataChampion method = new GetDataChampion(this.getConfig(), platform, id, locale, version, tags);
        return this.endpointManager.callMethodAsynchronously(method);
    }

    public AsyncRequest getDataChampion(Platform platform, int id) {
        return this.getDataChampion(platform, id, null, null, new ChampionTags[0]);
    }

    public AsyncRequest getDataChampionList(Platform platform, Locale locale, String version, boolean dataById, ChampionListTags ... tags) {
        Objects.requireNonNull(platform);
        GetDataChampionList method = new GetDataChampionList(this.getConfig(), platform, locale, version, dataById, tags);
        return this.endpointManager.callMethodAsynchronously(method);
    }

    public AsyncRequest getDataChampionList(Platform platform) {
        return this.getDataChampionList(platform, null, null, false, new ChampionListTags[0]);
    }

    public AsyncRequest getDataItem(Platform platform, int id, Locale locale, String version, ItemTags ... tags) {
        Objects.requireNonNull(platform);
        GetDataItem method = new GetDataItem(this.getConfig(), platform, id, locale, version, tags);
        return this.endpointManager.callMethodAsynchronously(method);
    }

    public AsyncRequest getDataItem(Platform platform, int id) {
        return this.getDataItem(platform, id, null, null, new ItemTags[0]);
    }

    public AsyncRequest getDataItemList(Platform platform, Locale locale, String version, ItemListTags ... tags) {
        Objects.requireNonNull(platform);
        GetDataItemList method = new GetDataItemList(this.getConfig(), platform, locale, version, tags);
        return this.endpointManager.callMethodAsynchronously(method);
    }

    public AsyncRequest getDataItemList(Platform platform) {
        return this.getDataItemList(platform, null, null, new ItemListTags[0]);
    }

    public AsyncRequest getDataLanguages(Platform platform) {
        Objects.requireNonNull(platform);
        GetDataLanguages method = new GetDataLanguages(this.getConfig(), platform);
        return this.endpointManager.callMethodAsynchronously(method);
    }

    public AsyncRequest getDataLanguageStrings(Platform platform, Locale locale, String version) {
        Objects.requireNonNull(platform);
        GetDataLanguageStrings method = new GetDataLanguageStrings(this.getConfig(), platform, locale, version);
        return this.endpointManager.callMethodAsynchronously(method);
    }

    public AsyncRequest getDataLanguageStrings(Platform platform) {
        return this.getDataLanguageStrings(platform, null, null);
    }

    public AsyncRequest getDataMaps(Platform platform, Locale locale, String version) {
        Objects.requireNonNull(platform);
        GetDataMaps method = new GetDataMaps(this.getConfig(), platform, locale, version);
        return this.endpointManager.callMethodAsynchronously(method);
    }

    public AsyncRequest getDataMaps(Platform platform) {
        return this.getDataMaps(platform, null, null);
    }

    public AsyncRequest getDataMastery(Platform platform, int id, Locale locale, String version, MasteryTags ... tags) {
        Objects.requireNonNull(platform);
        GetDataMastery method = new GetDataMastery(this.getConfig(), platform, id, locale, version, tags);
        return this.endpointManager.callMethodAsynchronously(method);
    }

    public AsyncRequest getDataMastery(Platform platform, int id) {
        return this.getDataMastery(platform, id, null, null, new MasteryTags[0]);
    }

    public AsyncRequest getDataMasteryList(Platform platform, Locale locale, String version, MasteryListTags ... tags) {
        Objects.requireNonNull(platform);
        GetDataMasteryList method = new GetDataMasteryList(this.getConfig(), platform, locale, version, tags);
        return this.endpointManager.callMethodAsynchronously(method);
    }

    public AsyncRequest getDataMasteryList(Platform platform) {
        return this.getDataMasteryList(platform, null, null, new MasteryListTags[0]);
    }

    public AsyncRequest getDataProfileIcons(Platform platform, Locale locale, String version) {
        Objects.requireNonNull(platform);
        GetDataProfileIcons method = new GetDataProfileIcons(this.getConfig(), platform, locale, version);
        return this.endpointManager.callMethodAsynchronously(method);
    }

    public AsyncRequest getDataProfileIcons(Platform platform) {
        return this.getDataProfileIcons(platform, null, null);
    }

    public AsyncRequest getDataRealm(Platform platform) {
        Objects.requireNonNull(platform);
        GetDataRealm method = new GetDataRealm(this.getConfig(), platform);
        return this.endpointManager.callMethodAsynchronously(method);
    }

    public AsyncRequest getDataReforgedRune(Platform platform, int id, Locale locale, String version) throws RiotApiException {
        Objects.requireNonNull(platform);
        GetDataReforgedRune method = new GetDataReforgedRune(this.getConfig(), platform, id, locale, version);
        return this.endpointManager.callMethodAsynchronously(method);
    }

    public AsyncRequest getDataReforgedRune(Platform platform, int id) throws RiotApiException {
        return this.getDataReforgedRune(platform, id, null, null);
    }

    public AsyncRequest getDataReforgedRuneList(Platform platform, Locale locale, String version) {
        Objects.requireNonNull(platform);
        GetDataReforgedRuneList method = new GetDataReforgedRuneList(this.getConfig(), platform, locale, version);
        return this.endpointManager.callMethodAsynchronously(method);
    }

    public AsyncRequest getDataReforgedRuneList(Platform platform) {
        return this.getDataReforgedRuneList(platform, null, null);
    }

    public AsyncRequest getDataReforgedRunePath(Platform platform, int id, Locale locale, String version) {
        Objects.requireNonNull(platform);
        GetDataReforgedRunePath method = new GetDataReforgedRunePath(this.getConfig(), platform, id, locale, version);
        return this.endpointManager.callMethodAsynchronously(method);
    }

    public AsyncRequest getDataReforgedRunePath(Platform platform, int id) {
        return this.getDataReforgedRunePath(platform, id, null, null);
    }

    public AsyncRequest getDataReforgedRunePathList(Platform platform, Locale locale, String version) {
        Objects.requireNonNull(platform);
        GetDataReforgedRunePathList method = new GetDataReforgedRunePathList(this.getConfig(), platform, locale, version);
        return this.endpointManager.callMethodAsynchronously(method);
    }

    public AsyncRequest getDataReforgedRunePathList(Platform platform) {
        return this.getDataReforgedRunePathList(platform, null, null);
    }

    public AsyncRequest getDataRune(Platform platform, int id, Locale locale, String version, RuneTags ... tags) {
        Objects.requireNonNull(platform);
        GetDataRune method = new GetDataRune(this.getConfig(), platform, id, locale, version, tags);
        return this.endpointManager.callMethodAsynchronously(method);
    }

    public AsyncRequest getDataRune(Platform platform, int id) {
        return this.getDataRune(platform, id, null, null, new RuneTags[0]);
    }

    public AsyncRequest getDataRuneList(Platform platform, Locale locale, String version, RuneListTags ... tags) {
        Objects.requireNonNull(platform);
        GetDataRuneList method = new GetDataRuneList(this.getConfig(), platform, locale, version, tags);
        return this.endpointManager.callMethodAsynchronously(method);
    }

    public AsyncRequest getDataRuneList(Platform platform) {
        return this.getDataRuneList(platform, null, null, new RuneListTags[0]);
    }

    public AsyncRequest getDataSummonerSpell(Platform platform, int id, Locale locale, String version, SpellTags ... tags) {
        Objects.requireNonNull(platform);
        GetDataSummonerSpell method = new GetDataSummonerSpell(this.getConfig(), platform, id, locale, version, tags);
        return this.endpointManager.callMethodAsynchronously(method);
    }

    public AsyncRequest getDataSummonerSpell(Platform platform, int id) {
        return this.getDataSummonerSpell(platform, id, null, null, new SpellTags[0]);
    }

    public AsyncRequest getDataSummonerSpellList(Platform platform, Locale locale, String version, boolean dataById, SpellListTags ... tags) {
        Objects.requireNonNull(platform);
        GetDataSummonerSpellList method = new GetDataSummonerSpellList(this.getConfig(), platform, locale, version, dataById, tags);
        return this.endpointManager.callMethodAsynchronously(method);
    }

    public AsyncRequest getDataSummonerSpellList(Platform platform) {
        return this.getDataSummonerSpellList(platform, null, null, false, new SpellListTags[0]);
    }

    public AsyncRequest getDataTarballLinks(Platform platform, String version) throws RiotApiException {
        Objects.requireNonNull(platform);
        GetDataTarballLinks method = new GetDataTarballLinks(this.getConfig(), platform, version);
        return this.endpointManager.callMethodAsynchronously(method);
    }

    public AsyncRequest getDataTarballLinks(Platform platform) throws RiotApiException {
        Objects.requireNonNull(platform);
        return this.getDataTarballLinks(platform, null);
    }

    public AsyncRequest getDataVersions(Platform platform) {
        Objects.requireNonNull(platform);
        GetDataVersions method = new GetDataVersions(this.getConfig(), platform);
        return this.endpointManager.callMethodAsynchronously(method);
    }

    public AsyncRequest getFeaturedGames(Platform platform) {
        Objects.requireNonNull(platform);
        GetFeaturedGames method = new GetFeaturedGames(this.getConfig(), platform);
        return this.endpointManager.callMethodAsynchronously(method);
    }

    public AsyncRequest getLeagueById(Platform platform, String leagueId) throws RiotApiException {
        Objects.requireNonNull(platform);
        Objects.requireNonNull(leagueId);
        GetLeagueById method = new GetLeagueById(this.getConfig(), platform, leagueId);
        return this.endpointManager.callMethodAsynchronously(method);
    }

    public AsyncRequest getLeaguePositionsBySummonerId(Platform platform, long summonerId) {
        Objects.requireNonNull(platform);
        GetLeaguePositionsBySummonerId method = new GetLeaguePositionsBySummonerId(this.getConfig(), platform, summonerId);
        return this.endpointManager.callMethodAsynchronously(method);
    }

    public AsyncRequest getLobbyEventsByTournament(String tournamentCode) {
        Objects.requireNonNull(tournamentCode);
        GetLobbyEventsByCode method = new GetLobbyEventsByCode(this.getConfig(), tournamentCode);
        return this.endpointManager.callMethodAsynchronously(method);
    }

    public AsyncRequest getMasterLeagueByQueue(Platform platform, String queue) {
        Objects.requireNonNull(platform);
        Objects.requireNonNull(queue);
        GetMasterLeagueByQueue method = new GetMasterLeagueByQueue(this.getConfig(), platform, queue);
        return this.endpointManager.callMethodAsynchronously(method);
    }

    public AsyncRequest getMasterLeagueByQueue(Platform platform, LeagueQueue queue) {
        Objects.requireNonNull(queue);
        return this.getMasterLeagueByQueue(platform, queue.toString());
    }

    public AsyncRequest getMatch(Platform platform, long matchId, long forAccountId) {
        Objects.requireNonNull(platform);
        GetMatch method = new GetMatch(this.getConfig(), platform, matchId, forAccountId);
        return this.endpointManager.callMethodAsynchronously(method);
    }

    public AsyncRequest getMatch(Platform platform, long matchId) {
        return this.getMatch(platform, matchId, -1L);
    }

    public AsyncRequest getMatchIdsByTournamentCode(Platform platform, String tournamentCode) {
        Objects.requireNonNull(platform);
        Objects.requireNonNull(tournamentCode);
        GetMatchIdsByTournamentCode method = new GetMatchIdsByTournamentCode(this.getConfig(), platform, tournamentCode);
        return this.endpointManager.callMethodAsynchronously(method);
    }

    public AsyncRequest getMatchByMatchIdAndTournamentCode(Platform platform, long matchId, String tournamentCode) {
        Objects.requireNonNull(platform);
        Objects.requireNonNull(tournamentCode);
        GetMatchByMatchIdAndTournamentCode method = new GetMatchByMatchIdAndTournamentCode(this.getConfig(), platform, matchId, tournamentCode);
        return this.endpointManager.callMethodAsynchronously(method);
    }

    public AsyncRequest getMatchListByAccountId(Platform platform, long accountId, Set<Integer> champion, Set<Integer> queue, Set<Integer> season, long beginTime, long endTime, int beginIndex, int endIndex) {
        Objects.requireNonNull(platform);
        GetMatchListByAccountId method = new GetMatchListByAccountId(this.getConfig(), platform, accountId, champion, queue, season, beginTime, endTime, beginIndex, endIndex);
        return this.endpointManager.callMethodAsynchronously(method);
    }

    public AsyncRequest getMatchListByAccountId(Platform platform, long accountId, Set<Integer> champion, Set<Integer> queue, Set<Integer> season) {
        return this.getMatchListByAccountId(platform, accountId, champion, queue, season, -1L, -1L, -1, -1);
    }

    public AsyncRequest getMatchListByAccountId(Platform platform, long accountId) {
        return this.getMatchListByAccountId(platform, accountId, null, null, null);
    }

    public int getPoolSize() {
        return this.endpointManager.getPoolSize();
    }

    public int getQueueSize() {
        return this.endpointManager.getQueueSize();
    }

    public AsyncRequest getShardData(Platform platform) {
        Objects.requireNonNull(platform);
        GetShardData method = new GetShardData(this.getConfig(), platform);
        return this.endpointManager.callMethodAsynchronously(method);
    }

    public AsyncRequest getSummonerByAccount(Platform platform, long accountId) {
        Objects.requireNonNull(platform);
        GetSummonerByAccount method = new GetSummonerByAccount(this.getConfig(), platform, accountId);
        return this.endpointManager.callMethodAsynchronously(method);
    }

    public AsyncRequest getSummoner(Platform platform, long summonerId) {
        Objects.requireNonNull(platform);
        GetSummoner method = new GetSummoner(this.getConfig(), platform, summonerId);
        return this.endpointManager.callMethodAsynchronously(method);
    }

    public AsyncRequest getSummonerByName(Platform platform, String summonerName) {
        Objects.requireNonNull(platform);
        Objects.requireNonNull(summonerName);
        RiotApiUtil.requireValidSummonerName(summonerName);
        GetSummonerByName method = new GetSummonerByName(this.getConfig(), platform, summonerName);
        return this.endpointManager.callMethodAsynchronously(method);
    }

    public AsyncRequest getThirdPartyCodeBySummoner(Platform platform, long summonerId) {
        Objects.requireNonNull(platform);
        GetThirdPartyCodeBySummoner method = new GetThirdPartyCodeBySummoner(this.getConfig(), platform, summonerId);
        return this.endpointManager.callMethodAsynchronously(method);
    }

    public AsyncRequest getTimelineByMatchId(Platform platform, long matchId) {
        Objects.requireNonNull(platform);
        GetTimelineByMatchId method = new GetTimelineByMatchId(this.getConfig(), platform, matchId);
        return this.endpointManager.callMethodAsynchronously(method);
    }

    public AsyncRequest getTournamentCode(String tournamentCode) {
        Objects.requireNonNull(tournamentCode);
        GetTournamentCode method = new GetTournamentCode(this.getConfig(), tournamentCode);
        return this.endpointManager.callMethodAsynchronously(method);
    }

    public void removeListeners(RequestListener ... listeners) {
        this.endpointManager.removeListeners(listeners);
    }

    public void updateTournamentCode(String tournamentCode, TournamentMap mapType, PickType pickType, SpectatorType spectatorType, long ... allowedSummonerIds) {
        Objects.requireNonNull(tournamentCode);
        UpdateTournamentCode method = new UpdateTournamentCode(this.getConfig(), tournamentCode, mapType, pickType, spectatorType, allowedSummonerIds);
        this.endpointManager.callMethodAsynchronously(method);
    }
}

