/*
 * Decompiled with CFR 0.152.
 */
package com.tarek360.instacapture.screenshot;

import android.app.Activity;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Xfermode;
import android.opengl.GLSurfaceView;
import android.os.Build;
import android.support.annotation.RequiresApi;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import com.tarek360.instacapture.screenshot.FieldHelper;
import com.tarek360.instacapture.screenshot.RootViewInfo;
import com.tarek360.instacapture.utility.Logger;
import java.nio.Buffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import javax.microedition.khronos.egl.EGL;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.opengles.GL;
import javax.microedition.khronos.opengles.GL10;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J/\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0010\u0010\u000e\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0010\u0018\u00010\u000fH\u0002\u00a2\u0006\u0002\u0010\u0011J5\u0010\u0012\u001a\u00020\u00042\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00142\u0006\u0010\f\u001a\u00020\r2\u0010\u0010\u000e\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0010\u0018\u00010\u000fH\u0002\u00a2\u0006\u0002\u0010\u0015J\u0018\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0007\u001a\u00020\bH\u0003J\u001e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00100\u001a2\u0006\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\bH\u0002J)\u0010\u001c\u001a\u0004\u0018\u00010\r2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0010\u0010\u000e\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0010\u0018\u00010\u000f\u00a2\u0006\u0002\u0010\u001f\u00a8\u0006 "}, d2={"Lcom/tarek360/instacapture/screenshot/ScreenshotTaker;", "", "()V", "drawGLSurfaceView", "", "surfaceView", "Landroid/opengl/GLSurfaceView;", "canvas", "Landroid/graphics/Canvas;", "drawRootToBitmap", "rootViewInfo", "Lcom/tarek360/instacapture/screenshot/RootViewInfo;", "bitmap", "Landroid/graphics/Bitmap;", "ignoredViews", "", "Landroid/view/View;", "(Lcom/tarek360/instacapture/screenshot/RootViewInfo;Landroid/graphics/Bitmap;[Landroid/view/View;)V", "drawRootsToBitmap", "viewRoots", "", "(Ljava/util/List;Landroid/graphics/Bitmap;[Landroid/view/View;)V", "drawTextureView", "textureView", "Landroid/view/TextureView;", "drawUnDrawableViews", "Ljava/util/ArrayList;", "v", "getScreenshotBitmap", "activity", "Landroid/app/Activity;", "(Landroid/app/Activity;[Landroid/view/View;)Landroid/graphics/Bitmap;", "instacapture_release"})
public final class ScreenshotTaker {
    public static final ScreenshotTaker INSTANCE;

    @Nullable
    public final Bitmap getScreenshotBitmap(@Nullable Activity activity, @Nullable View[] ignoredViews) {
        Bitmap bitmap;
        if (activity == null) {
            throw (Throwable)new IllegalArgumentException("Parameter activity cannot be null.");
        }
        Object paramsObject = new Object();
        boolean cfr_ignored_0 = paramsObject instanceof List;
        List<RootViewInfo> viewRoots = FieldHelper.INSTANCE.getRootViews(activity);
        Window window = activity.getWindow();
        Intrinsics.checkExpressionValueIsNotNull((Object)window, (String)"activity.window");
        View main = window.getDecorView();
        try {
            View view = main;
            Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"main");
            Bitmap bitmap2 = Bitmap.createBitmap((int)view.getWidth(), (int)main.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Intrinsics.checkExpressionValueIsNotNull((Object)bitmap2, (String)"Bitmap.createBitmap(main\u2026 Bitmap.Config.ARGB_8888)");
            bitmap = bitmap2;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        this.drawRootsToBitmap(viewRoots, bitmap, ignoredViews);
        return bitmap;
    }

    private final void drawRootsToBitmap(List<RootViewInfo> viewRoots, Bitmap bitmap, View[] ignoredViews) {
        for (RootViewInfo rootData : viewRoots) {
            this.drawRootToBitmap(rootData, bitmap, ignoredViews);
        }
    }

    private final void drawRootToBitmap(RootViewInfo rootViewInfo, Bitmap bitmap, View[] ignoredViews) {
        WindowManager.LayoutParams layoutParams = rootViewInfo.getLayoutParams();
        if (layoutParams == null) {
            Intrinsics.throwNpe();
        }
        if ((layoutParams.flags & 2) == 2) {
            Canvas dimCanvas = new Canvas(bitmap);
            int alpha = (int)((float)255 * rootViewInfo.getLayoutParams().dimAmount);
            dimCanvas.drawARGB(alpha, 0, 0, 0);
        }
        Canvas canvas = new Canvas(bitmap);
        canvas.translate((float)rootViewInfo.getLeft(), (float)rootViewInfo.getTop());
        if (ignoredViews != null) {
            int i;
            int[] ignoredViewsVisibility = new int[ignoredViews.length];
            int n = 0;
            int n2 = ignoredViews.length;
            while (n < n2) {
                ignoredViewsVisibility[i] = ignoredViews[i].getVisibility();
                ignoredViews[i].setVisibility(4);
                ++i;
            }
            rootViewInfo.getView().draw(canvas);
            this.drawUnDrawableViews(rootViewInfo.getView(), canvas);
            n2 = ignoredViews.length;
            for (i = 0; i < n2; ++i) {
                ignoredViews[i].setVisibility(ignoredViewsVisibility[i]);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final ArrayList<View> drawUnDrawableViews(View v, Canvas canvas) {
        if (!(v instanceof ViewGroup)) {
            ArrayList<View> viewArrayList = new ArrayList<View>();
            viewArrayList.add(v);
            return viewArrayList;
        }
        ArrayList<View> result = new ArrayList<View>();
        View viewGroup = v;
        int n = 0;
        int n2 = ((ViewGroup)viewGroup).getChildCount();
        while (n < n2) {
            void i;
            View child = ((ViewGroup)viewGroup).getChildAt((int)i);
            ArrayList<View> viewArrayList = new ArrayList<View>();
            viewArrayList.add(v);
            View view = child;
            Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"child");
            viewArrayList.addAll((Collection)this.drawUnDrawableViews(view, canvas));
            if (Build.VERSION.SDK_INT >= 14 && child instanceof TextureView) {
                this.drawTextureView((TextureView)child, canvas);
            }
            if (child instanceof GLSurfaceView) {
                this.drawGLSurfaceView((GLSurfaceView)child, canvas);
            }
            result.addAll((Collection<View>)viewArrayList);
            ++i;
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private final void drawGLSurfaceView(GLSurfaceView surfaceView, Canvas canvas) {
        Logger.INSTANCE.d("Drawing GLSurfaceView");
        if (surfaceView.getWindowToken() != null) {
            int[] location = new int[2];
            surfaceView.getLocationOnScreen(location);
            int width = surfaceView.getWidth();
            int height = surfaceView.getHeight();
            int x = 0;
            int y = 0;
            int[] b = new int[width * (y + height)];
            IntBuffer ib = IntBuffer.wrap(b);
            ib.position(0);
            CountDownLatch countDownLatch = new CountDownLatch(1);
            surfaceView.queueEvent(new Runnable(x, width, y, height, ib, countDownLatch){
                final /* synthetic */ int $x;
                final /* synthetic */ int $width;
                final /* synthetic */ int $y;
                final /* synthetic */ int $height;
                final /* synthetic */ IntBuffer $ib;
                final /* synthetic */ CountDownLatch $countDownLatch;

                public final void run() {
                    EGL eGL = EGLContext.getEGL();
                    if (eGL == null) {
                        throw new TypeCastException("null cannot be cast to non-null type javax.microedition.khronos.egl.EGL10");
                    }
                    EGL10 egl = (EGL10)eGL;
                    egl.eglWaitGL();
                    EGLContext eGLContext = egl.eglGetCurrentContext();
                    Intrinsics.checkExpressionValueIsNotNull((Object)eGLContext, (String)"egl.eglGetCurrentContext()");
                    GL gL = eGLContext.getGL();
                    if (gL == null) {
                        throw new TypeCastException("null cannot be cast to non-null type javax.microedition.khronos.opengles.GL10");
                    }
                    GL10 gl = (GL10)gL;
                    gl.glFinish();
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    gl.glReadPixels(this.$x, 0, this.$width, this.$y + this.$height, 6408, 5121, (Buffer)this.$ib);
                    this.$countDownLatch.countDown();
                }
                {
                    this.$x = n;
                    this.$width = n2;
                    this.$y = n3;
                    this.$height = n4;
                    this.$ib = intBuffer;
                    this.$countDownLatch = countDownLatch;
                }
            });
            try {
                countDownLatch.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            int[] bt = new int[width * height];
            int i = 0;
            int k = 0;
            while (i < height) {
                int n = 0;
                int n2 = width;
                while (n < n2) {
                    int pix1;
                    void j;
                    int pix = b[i * width + j];
                    int pb = pix >> 16 & 0xFF;
                    int pr = pix << 16 & 0xFF0000;
                    bt[(height - k - 1) * width + j] = pix1 = pix & (int)0xFF00FF00L | pr | pb;
                    ++j;
                }
                ++i;
                ++k;
            }
            Bitmap sb = Bitmap.createBitmap((int[])bt, (int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Paint paint = new Paint();
            paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_ATOP));
            canvas.drawBitmap(sb, (float)location[0], (float)location[1], paint);
            sb.recycle();
        }
    }

    @RequiresApi(api=14)
    private final void drawTextureView(TextureView textureView, Canvas canvas) {
        Logger.INSTANCE.d("Drawing TextureView");
        int[] textureViewLocation = new int[2];
        textureView.getLocationOnScreen(textureViewLocation);
        Bitmap textureViewBitmap = textureView.getBitmap();
        if (textureViewBitmap != null) {
            Paint paint = new Paint();
            paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_ATOP));
            canvas.drawBitmap(textureViewBitmap, (float)textureViewLocation[0], (float)textureViewLocation[1], paint);
            textureViewBitmap.recycle();
        }
    }

    private ScreenshotTaker() {
    }

    static {
        ScreenshotTaker screenshotTaker;
        INSTANCE = screenshotTaker = new ScreenshotTaker();
    }
}

