/*
 * Decompiled with CFR 0.152.
 */
package com.tarek360.instacapture.screenshot;

import android.content.Context;
import android.graphics.Bitmap;
import android.support.annotation.NonNull;
import com.tarek360.instacapture.utility.Logger;
import com.tarek360.instacapture.utility.Utility;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import rx.Observable;
import rx.functions.Func1;
import rx.schedulers.Schedulers;

final class ScreenshotFileObservable {
    private static final int JPEG_COMPRESSION_QUALITY = 75;

    private ScreenshotFileObservable() {
    }

    static Observable<File> get(@NonNull Observable<Bitmap> screenshotBitmapObservable, final @NonNull Context context, final File file) {
        return screenshotBitmapObservable.observeOn(Schedulers.io()).switchMap((Func1)new Func1<Bitmap, Observable<File>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Observable<File> call(Bitmap bitmap) {
                Observable observable;
                OutputStream outputStream = null;
                try {
                    File screenshotFile = file == null ? Utility.getScreenshotFile(context) : file;
                    outputStream = new BufferedOutputStream(new FileOutputStream(screenshotFile));
                    bitmap.compress(Bitmap.CompressFormat.JPEG, 75, outputStream);
                    outputStream.flush();
                    observable = Observable.just((Object)screenshotFile);
                    Logger.d("Screenshot saved to " + screenshotFile.getAbsolutePath());
                }
                catch (IOException e) {
                    observable = Observable.error((Throwable)e);
                }
                finally {
                    if (outputStream != null) {
                        try {
                            outputStream.close();
                        }
                        catch (IOException ignored) {
                            Logger.e("Failed to close OutputStream.");
                        }
                    }
                }
                return observable;
            }
        });
    }
}

