/*
 * Decompiled with CFR 0.152.
 */
package com.tarek360.instacapture;

import android.app.Activity;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.lang.ref.WeakReference;

public final class ActivityReferenceManager {
    @Nullable
    private WeakReference<Activity> mActivity;

    public void setActivity(@NonNull Activity activity) {
        this.mActivity = new WeakReference<Activity>(activity);
    }

    @Nullable
    public Activity getValidatedActivity() {
        if (this.mActivity == null) {
            return null;
        }
        Activity activity = (Activity)this.mActivity.get();
        if (!this.isActivityValid(activity)) {
            return null;
        }
        return activity;
    }

    private boolean isActivityValid(@Nullable Activity activity) {
        if (activity == null) {
            return false;
        }
        if (Build.VERSION.SDK_INT >= 17) {
            return !activity.isFinishing() && !activity.isDestroyed();
        }
        return !activity.isFinishing();
    }
}

