/*
 * Decompiled with CFR 0.152.
 */
package com.tarek360.instacapture.screenshot.nonMaps;

import android.app.Activity;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.view.View;
import com.tarek360.instacapture.screenshot.nonMaps.FieldHelper;
import com.tarek360.instacapture.screenshot.nonMaps.RootViewInfo;
import com.tarek360.instacapture.utility.Logger;
import java.util.List;

public final class NonMapScreenshotTaker {
    private NonMapScreenshotTaker() {
    }

    public static Bitmap getScreenshotBitmap(Activity activity, View[] ignoredViews) {
        Bitmap bitmap;
        if (activity == null) {
            throw new IllegalArgumentException("Parameter activity cannot be null.");
        }
        List<RootViewInfo> viewRoots = FieldHelper.getRootViews(activity);
        View main = activity.getWindow().getDecorView();
        try {
            bitmap = Bitmap.createBitmap((int)main.getWidth(), (int)main.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        NonMapScreenshotTaker.drawRootsToBitmap(viewRoots, bitmap, ignoredViews);
        return bitmap;
    }

    private static void drawRootsToBitmap(List<RootViewInfo> viewRoots, Bitmap bitmap, View[] ignoredViews) {
        for (RootViewInfo rootData : viewRoots) {
            NonMapScreenshotTaker.drawRootToBitmap(rootData, bitmap, ignoredViews);
        }
    }

    private static void drawRootToBitmap(RootViewInfo rootViewInfo, Bitmap bitmap, View[] ignoredViews) {
        if ((rootViewInfo.getLayoutParams().flags & 2) == 2) {
            Canvas dimCanvas = new Canvas(bitmap);
            int alpha = (int)(255.0f * rootViewInfo.getLayoutParams().dimAmount);
            dimCanvas.drawARGB(alpha, 0, 0, 0);
        }
        Canvas canvas = new Canvas(bitmap);
        canvas.translate((float)rootViewInfo.getRect().left, (float)rootViewInfo.getRect().top);
        if (ignoredViews != null) {
            for (View ignoreView : ignoredViews) {
                View view;
                if (ignoreView == null) continue;
                int ignoreViewId = ignoreView.getId();
                if (ignoreViewId == -1) {
                    Logger.e("The view which has no id will not be ignored.");
                }
                if ((view = rootViewInfo.getView().findViewById(ignoreViewId)) == null) continue;
                view.setVisibility(8);
            }
        }
        rootViewInfo.getView().draw(canvas);
        if (ignoredViews != null) {
            for (View ignoreView : ignoredViews) {
                View view;
                if (ignoreView == null || (view = rootViewInfo.getView().findViewById(ignoreView.getId())) == null) continue;
                view.setVisibility(0);
            }
        }
    }
}

