/*
 * Decompiled with CFR 0.152.
 */
package com.tamsiree.rxkit;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.CountDownTimer;
import android.os.Handler;
import android.os.HandlerThread;
import android.text.Editable;
import android.text.InputFilter;
import android.text.Spanned;
import android.text.TextWatcher;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.tamsiree.rxkit.RxVibrateTool;
import com.tamsiree.rxkit.TLog;
import com.tamsiree.rxkit.crash.TCrashProfile;
import com.tamsiree.rxkit.interfaces.OnDoListener;
import com.tamsiree.rxkit.interfaces.OnSimpleListener;
import com.tamsiree.rxkit.view.RxToast;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0007J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J*\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\n2\b\u0010\u0017\u001a\u0004\u0018\u00010\fH\u0007J\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u001aJ\u0018\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\n2\u0006\u0010!\u001a\u00020\"H\u0007J\u0010\u0010#\u001a\u00020\u00122\u0006\u0010$\u001a\u00020%H\u0007J\b\u0010&\u001a\u00020\bH\u0007J$\u0010'\u001a\u00020(2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010)\u001a\u0004\u0018\u00010\f2\b\u0010*\u001a\u0004\u0018\u00010\fH\u0007J\u0010\u0010+\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u001a\u0010,\u001a\u00020\u00122\b\u0010-\u001a\u0004\u0018\u00010\b2\u0006\u0010.\u001a\u00020/H\u0007J\u0010\u00100\u001a\u00020\u001a2\u0006\u00101\u001a\u00020(H\u0007J\u0018\u00102\u001a\u00020\u00122\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020(H\u0007J\u0010\u00106\u001a\u00020\u00122\u0006\u00103\u001a\u000204H\u0007J\u0010\u00107\u001a\u00020\u00122\u0006\u00103\u001a\u000204H\u0007J \u00108\u001a\u00020\u00122\u0006\u00103\u001a\u0002042\u0006\u00109\u001a\u00020(2\u0006\u0010:\u001a\u00020\u001aH\u0007J \u0010;\u001a\u00020\u00122\u0006\u00103\u001a\u0002042\u0006\u00109\u001a\u00020(2\u0006\u0010:\u001a\u00020\u001aH\u0007J\u0012\u0010<\u001a\u00020\f2\b\u0010=\u001a\u0004\u0018\u00010\fH\u0007R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u0004\u0018\u00010\b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lcom/tamsiree/rxkit/RxTool;", "", "()V", "backgroundHandler", "Landroid/os/Handler;", "getBackgroundHandler", "()Landroid/os/Handler;", "context", "Landroid/content/Context;", "lastClickTime", "", "Md5", "", "MStr", "bytesToHexString", "bytes", "", "countDown", "", "textView", "Landroid/widget/TextView;", "waitTime", "interval", "hint", "crashLogFile", "switch", "", "crashProfile", "Lcom/tamsiree/rxkit/crash/TCrashProfile$Builder;", "debugLog", "debugLogFile", "delayToDo", "delayTime", "onSimpleListener", "Lcom/tamsiree/rxkit/interfaces/OnSimpleListener;", "fixListViewHeight", "listView", "Landroid/widget/ListView;", "getContext", "getResIdByName", "", "name", "defType", "init", "initFastClickAndVibrate", "mContext", "onRxSimple", "Lcom/tamsiree/rxkit/interfaces/OnDoListener;", "isFastClick", "millisecond", "setEdDecimal", "editText", "Landroid/widget/EditText;", "count", "setEdTwoDecimal", "setEdType", "setEditNumber", "number", "isStartForZero", "setEditNumberAuto", "stringFilter", "str", "RxKit_release"})
public final class RxTool {
    @NotNull
    public static final RxTool INSTANCE = new RxTool();
    @SuppressLint(value={"StaticFieldLeak"})
    @Nullable
    private static Context context;
    private static long lastClickTime;

    private RxTool() {
    }

    @JvmStatic
    @NotNull
    public static final RxTool init(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        RxTool.context = context.getApplicationContext();
        TLog.init(context);
        return INSTANCE;
    }

    @JvmStatic
    @NotNull
    public static final Context getContext() {
        if (context != null) {
            Context context = RxTool.context;
            if (context == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.content.Context");
            }
            return context;
        }
        throw new NullPointerException("\u8bf7\u5148\u8c03\u7528init()\u65b9\u6cd5");
    }

    @NotNull
    public final RxTool debugLog(boolean bl) {
        TLog.INSTANCE.switchLog(bl);
        return INSTANCE;
    }

    @NotNull
    public final RxTool debugLogFile(boolean bl) {
        TLog.INSTANCE.switch2File(bl);
        return INSTANCE;
    }

    @NotNull
    public final RxTool crashLogFile(boolean bl) {
        TLog.INSTANCE.switchCrashFile(bl);
        return INSTANCE;
    }

    @NotNull
    public final TCrashProfile.Builder crashProfile() {
        return TCrashProfile.Builder.Companion.create();
    }

    @JvmStatic
    public static final void delayToDo(long delayTime, @NotNull OnSimpleListener onSimpleListener) {
        Intrinsics.checkNotNullParameter((Object)onSimpleListener, (String)"onSimpleListener");
        new Handler().postDelayed(() -> RxTool.delayToDo$lambda-0(onSimpleListener), delayTime);
    }

    @JvmStatic
    public static final void countDown(@NotNull TextView textView, long waitTime, long interval, @Nullable String hint) {
        Intrinsics.checkNotNullParameter((Object)textView, (String)"textView");
        textView.setEnabled(false);
        CountDownTimer timer2 = new CountDownTimer(textView, hint, waitTime, interval){
            final /* synthetic */ TextView $textView;
            final /* synthetic */ String $hint;
            final /* synthetic */ long $waitTime;
            final /* synthetic */ long $interval;
            {
                this.$textView = $textView;
                this.$hint = $hint;
                this.$waitTime = $waitTime;
                this.$interval = $interval;
                super($waitTime, $interval);
            }

            @SuppressLint(value={"DefaultLocale"})
            public void onTick(long millisUntilFinished) {
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string = "\u5269\u4e0b %d S";
                Object[] objectArray = new Object[]{millisUntilFinished / (long)1000};
                boolean bl = false;
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
                this.$textView.setText((CharSequence)string2);
            }

            public void onFinish() {
                this.$textView.setEnabled(true);
                this.$textView.setText((CharSequence)this.$hint);
            }
        };
        timer2.start();
    }

    @JvmStatic
    public static final void fixListViewHeight(@NotNull ListView listView) {
        Intrinsics.checkNotNullParameter((Object)listView, (String)"listView");
        ListAdapter listAdapter = listView.getAdapter();
        int totalHeight = 0;
        if (listAdapter == null) {
            return;
        }
        int index = 0;
        int len = listAdapter.getCount();
        while (index < len) {
            View listViewItem = listAdapter.getView(index, null, (ViewGroup)listView);
            listViewItem.measure(0, 0);
            totalHeight += listViewItem.getMeasuredHeight();
            int n = index;
            index = n + 1;
        }
        ViewGroup.LayoutParams params = listView.getLayoutParams();
        params.height = totalHeight + listView.getDividerHeight() * (listAdapter.getCount() - 1);
        listView.setLayoutParams(params);
    }

    @JvmStatic
    @NotNull
    public static final String Md5(@NotNull String MStr) {
        String string;
        Intrinsics.checkNotNullParameter((Object)MStr, (String)"MStr");
        try {
            MessageDigest mDigest = MessageDigest.getInstance("MD5");
            Object object = MStr;
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            byte[] byArray = ((String)object).getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            mDigest.update(byArray);
            object = mDigest.digest();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"mDigest.digest()");
            string = INSTANCE.bytesToHexString((byte[])object);
        }
        catch (NoSuchAlgorithmException e) {
            string = String.valueOf(MStr.hashCode());
        }
        return string;
    }

    private final String bytesToHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        int n = 0;
        int n2 = bytes.length + -1;
        if (n <= n2) {
            do {
                int i = n++;
                String string = Integer.toHexString(0xFF & bytes[i]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toHexString(0xFF and bytes[i].toInt())");
                String hex = string;
                if (hex.length() == 1) {
                    sb.append('0');
                }
                sb.append(hex);
            } while (n <= n2);
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    @JvmStatic
    public static final int getResIdByName(@NotNull Context context, @Nullable String name, @Nullable String defType) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return context.getResources().getIdentifier(name, defType, context.getPackageName());
    }

    @JvmStatic
    public static final boolean isFastClick(int millisecond) {
        long curClickTime = System.currentTimeMillis();
        long interval = curClickTime - lastClickTime;
        if (0L < interval && interval < (long)millisecond) {
            return true;
        }
        lastClickTime = curClickTime;
        return false;
    }

    @JvmStatic
    public static final void setEdTwoDecimal(@NotNull EditText editText) {
        Intrinsics.checkNotNullParameter((Object)editText, (String)"editText");
        RxTool.setEdDecimal(editText, 2);
    }

    @JvmStatic
    public static final void setEdType(@NotNull EditText editText) {
        Intrinsics.checkNotNullParameter((Object)editText, (String)"editText");
        editText.addTextChangedListener(new TextWatcher(editText){
            final /* synthetic */ EditText $editText;
            {
                this.$editText = $editText;
            }

            public void beforeTextChanged(@NotNull CharSequence s, int start, int count, int after) {
                Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            }

            public void onTextChanged(@NotNull CharSequence s, int start, int before, int count) {
                Intrinsics.checkNotNullParameter((Object)s, (String)"s");
                String editable = this.$editText.getText().toString();
                String str = RxTool.stringFilter(editable);
                if (!Intrinsics.areEqual((Object)editable, (Object)str)) {
                    this.$editText.setText((CharSequence)str);
                    this.$editText.setSelection(str.length());
                }
            }

            public void afterTextChanged(@NotNull Editable s) {
                Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            }
        });
    }

    @JvmStatic
    @NotNull
    public static final String stringFilter(@Nullable String str) throws PatternSyntaxException {
        String regEx = "[^0-9\u4e00-\u9fa5]";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(str);
        String string = m.replaceAll("");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"m.replaceAll(\"\")");
        String $this$trim$iv = string;
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = $this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        return ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
    }

    @JvmStatic
    public static final void setEdDecimal(@NotNull EditText editText, int count) {
        Intrinsics.checkNotNullParameter((Object)editText, (String)"editText");
        int count2 = count;
        if (count2 < 0) {
            count2 = 0;
        }
        editText.setInputType(8194);
        int finalCount = ++count2;
        InputFilter[] inputFilterArray = new InputFilter[]{(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5) -> RxTool.setEdDecimal$lambda-2(finalCount, arg_0, arg_1, arg_2, arg_3, arg_4, arg_5)};
        editText.setFilters(inputFilterArray);
    }

    @JvmStatic
    public static final void setEditNumberAuto(@NotNull EditText editText, int number, boolean isStartForZero) {
        Intrinsics.checkNotNullParameter((Object)editText, (String)"editText");
        editText.setOnFocusChangeListener((arg_0, arg_1) -> RxTool.setEditNumberAuto$lambda-3(editText, number, isStartForZero, arg_0, arg_1));
    }

    @JvmStatic
    public static final void setEditNumber(@NotNull EditText editText, int number, boolean isStartForZero) {
        Intrinsics.checkNotNullParameter((Object)editText, (String)"editText");
        StringBuilder s = new StringBuilder(editText.getText().toString());
        StringBuilder temp = new StringBuilder();
        int i = 0;
        for (i = s.length(); i < number; ++i) {
            s.insert(0, "0");
        }
        if (!isStartForZero) {
            for (i = 0; i < number; ++i) {
                temp.append("0");
            }
            if (Intrinsics.areEqual((Object)s.toString(), (Object)temp.toString())) {
                s = new StringBuilder(Intrinsics.stringPlus((String)temp.substring(1), (Object)"1"));
            }
        }
        editText.setText((CharSequence)s.toString());
    }

    @NotNull
    public final Handler getBackgroundHandler() {
        HandlerThread thread = new HandlerThread("background");
        thread.start();
        return new Handler(thread.getLooper());
    }

    @JvmStatic
    public static final void initFastClickAndVibrate(@Nullable Context mContext, @NotNull OnDoListener onRxSimple) {
        Intrinsics.checkNotNullParameter((Object)onRxSimple, (String)"onRxSimple");
        if (RxTool.isFastClick(100)) {
            RxToast.normal("\u8bf7\u4e0d\u8981\u91cd\u590d\u70b9\u51fb");
            return;
        }
        Intrinsics.checkNotNull((Object)mContext);
        RxVibrateTool.vibrateOnce(mContext, 100);
        onRxSimple.doSomething();
    }

    private static final void delayToDo$lambda-0(OnSimpleListener $onSimpleListener) {
        Intrinsics.checkNotNullParameter((Object)$onSimpleListener, (String)"$onSimpleListener");
        $onSimpleListener.doSomething();
    }

    private static final CharSequence setEdDecimal$lambda-2(int $finalCount, CharSequence source, int start, int end, Spanned dest, int dstart, int dend) {
        String string = ".";
        Intrinsics.checkNotNullExpressionValue((Object)source, (String)"source");
        CharSequence charSequence = source;
        boolean bl = false;
        if (string.contentEquals(charSequence) && dest.toString().length() == 0) {
            return "0.";
        }
        if (StringsKt.contains$default((CharSequence)dest.toString(), (CharSequence)".", (boolean)false, (int)2, null)) {
            int index = StringsKt.indexOf$default((CharSequence)dest.toString(), (String)".", (int)0, (boolean)false, (int)6, null);
            String string2 = dest.toString();
            boolean bl2 = false;
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(index);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
            int mlength = string4.length();
            if (mlength == $finalCount) {
                return "";
            }
        }
        return Intrinsics.areEqual((Object)dest.toString(), (Object)"0") && Intrinsics.areEqual((Object)source, (Object)"0") ? (CharSequence)"" : null;
    }

    private static final void setEditNumberAuto$lambda-3(EditText $editText, int $number, boolean $isStartForZero, View v, boolean hasFocus) {
        Intrinsics.checkNotNullParameter((Object)$editText, (String)"$editText");
        if (!hasFocus) {
            RxTool.setEditNumber($editText, $number, $isStartForZero);
        }
    }
}

