/*
 * Decompiled with CFR 0.152.
 */
package com.tamsiree.rxkit;

import android.os.Build;
import android.text.Html;
import android.util.Base64;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0007J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0007J\u0012\u0010\u0007\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0007J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0012\u0010\b\u001a\u00020\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0007J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0012\u0010\n\u001a\u00020\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0007J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u001c\u0010\f\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u0006H\u0007J\u001c\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u0006H\u0007\u00a8\u0006\u000f"}, d2={"Lcom/tamsiree/rxkit/RxEncodeTool;", "", "()V", "base64Decode", "", "input", "", "base64Encode", "base64Encode2String", "base64UrlSafeEncode", "htmlDecode", "htmlEncode", "urlDecode", "charset", "urlEncode", "RxKit_release"})
public final class RxEncodeTool {
    @NotNull
    public static final RxEncodeTool INSTANCE = new RxEncodeTool();

    private RxEncodeTool() {
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String urlEncode(@NotNull String input, @Nullable String charset) {
        String string;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        try {
            string = URLEncoder.encode(input, charset);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"{\n            URLEncoder.encode(input, charset)\n        }");
        }
        catch (UnsupportedEncodingException e) {
            string = input;
        }
        return string;
    }

    public static /* synthetic */ String urlEncode$default(String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "UTF-8";
        }
        return RxEncodeTool.urlEncode(string, string2);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String urlDecode(@NotNull String input, @Nullable String charset) {
        String string;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        try {
            string = URLDecoder.decode(input, charset);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"{\n            URLDecoder.decode(input, charset)\n        }");
        }
        catch (UnsupportedEncodingException e) {
            string = input;
        }
        return string;
    }

    public static /* synthetic */ String urlDecode$default(String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "UTF-8";
        }
        return RxEncodeTool.urlDecode(string, string2);
    }

    @JvmStatic
    @NotNull
    public static final byte[] base64Encode(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        String string = input;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        return RxEncodeTool.base64Encode(byArray);
    }

    @JvmStatic
    @NotNull
    public static final byte[] base64Encode(@Nullable byte[] input) {
        byte[] byArray = Base64.encode((byte[])input, (int)2);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"encode(input, Base64.NO_WRAP)");
        return byArray;
    }

    @JvmStatic
    @NotNull
    public static final String base64Encode2String(@Nullable byte[] input) {
        String string = Base64.encodeToString((byte[])input, (int)2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encodeToString(input, Base64.NO_WRAP)");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final byte[] base64Decode(@Nullable String input) {
        byte[] byArray = Base64.decode((String)input, (int)2);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decode(input, Base64.NO_WRAP)");
        return byArray;
    }

    @JvmStatic
    @NotNull
    public static final byte[] base64Decode(@Nullable byte[] input) {
        byte[] byArray = Base64.decode((byte[])input, (int)2);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decode(input, Base64.NO_WRAP)");
        return byArray;
    }

    @JvmStatic
    @NotNull
    public static final byte[] base64UrlSafeEncode(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        String string = input;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = Base64.encode((byte[])byArray, (int)8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"encode(input.toByteArray(), Base64.URL_SAFE)");
        return byArray2;
    }

    @JvmStatic
    @NotNull
    public static final String htmlEncode(@NotNull String input) {
        String string;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        if (Build.VERSION.SDK_INT >= 16) {
            String string2 = Html.escapeHtml((CharSequence)input);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"{\n            Html.escapeHtml(input)\n        }");
            string = string2;
        } else {
            StringBuilder out = new StringBuilder();
            int i = 0;
            int len = input.length();
            while (i < len) {
                int n;
                char c = input.charAt(i);
                if (c == '<') {
                    out.append("&lt;");
                } else if (c == '>') {
                    out.append("&gt;");
                } else if (c == '&') {
                    out.append("&amp;");
                } else if (c >= '\ud800' && c <= '\udfff') {
                    char d;
                    if (c < '\udc00' && i + 1 < len && (d = input.charAt(i + 1)) >= '\udc00' && d <= '\udfff') {
                        int n2 = i;
                        i = n2 + 1;
                        int codepoint = 0x10000 | c - 55296 << 10 | d - 56320;
                        out.append("&#").append(codepoint).append(";");
                    }
                } else if (c > '~' || Intrinsics.compare((int)c, (int)32) < 0) {
                    out.append("&#").append((int)c).append(";");
                } else if (c == ' ') {
                    while (i + 1 < len && input.charAt(i + 1) == ' ') {
                        out.append("&nbsp;");
                        n = i;
                        i = n + 1;
                    }
                    out.append(' ');
                } else {
                    out.append(c);
                }
                n = i;
                i = n + 1;
            }
            String string3 = out.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"{\n            // \u53c2\u7167Html.escapeHtml()\u4e2d\u4ee3\u7801\n            val out = StringBuilder()\n            var i = 0\n            val len = input.length\n            while (i < len) {\n                val c = input[i]\n                if (c == '<') {\n                    out.append(\"&lt;\")\n                } else if (c == '>') {\n                    out.append(\"&gt;\")\n                } else if (c == '&') {\n                    out.append(\"&amp;\")\n                } else if (c.toInt() >= 0xD800 && c.toInt() <= 0xDFFF) {\n                    if (c.toInt() < 0xDC00 && i + 1 < len) {\n                        val d = input[i + 1]\n                        if (d.toInt() >= 0xDC00 && d.toInt() <= 0xDFFF) {\n                            i++\n                            val codepoint = 0x010000 or (c.toInt() - 0xD800 shl 10) or d.toInt() - 0xDC00\n                            out.append(\"&#\").append(codepoint).append(\";\")\n                        }\n                    }\n                } else if (c.toInt() > 0x7E || c < ' ') {\n                    out.append(\"&#\").append(c.toInt()).append(\";\")\n                } else if (c == ' ') {\n                    while (i + 1 < len && input[i + 1] == ' ') {\n                        out.append(\"&nbsp;\")\n                        i++\n                    }\n                    out.append(' ')\n                } else {\n                    out.append(c)\n                }\n                i++\n            }\n            out.toString()\n        }");
            string = string3;
        }
        return string;
    }

    @JvmStatic
    @NotNull
    public static final String htmlDecode(@Nullable String input) {
        return Html.fromHtml((String)input).toString();
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String urlEncode(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return RxEncodeTool.urlEncode$default(input, null, 2, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String urlDecode(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return RxEncodeTool.urlDecode$default(input, null, 2, null);
    }
}

