/*
 * Decompiled with CFR 0.152.
 */
package com.tamsiree.rxkit;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.ActivityManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import com.tamsiree.rxkit.RxDataTool;
import com.tamsiree.rxkit.RxEncryptTool;
import com.tamsiree.rxkit.RxFileTool;
import com.tamsiree.rxkit.RxIntentTool;
import com.tamsiree.rxkit.RxProcessTool;
import com.tamsiree.rxkit.RxShellTool;
import com.tamsiree.rxkit.TLog;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001<B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J-\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0016\u0010\n\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\f0\u000b\"\u0004\u0018\u00010\fH\u0007\u00a2\u0006\u0002\u0010\rJ-\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0016\u0010\u000e\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u000f0\u000b\"\u0004\u0018\u00010\u000fH\u0007\u00a2\u0006\u0002\u0010\u0010J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\tH\u0007J\u001a\u0010\u0014\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\t2\b\u0010\u0016\u001a\u0004\u0018\u00010\u000fH\u0007J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\b\u001a\u00020\tH\u0007J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u000fH\u0007J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00132\u0006\u0010\b\u001a\u00020\tH\u0007J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\b\u001a\u00020\tH\u0007J\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u000fH\u0007J\u0010\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tH\u0007J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\b\u001a\u00020\tH\u0007J\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u000fH\u0007J\u001d\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u000b2\u0006\u0010\b\u001a\u00020\tH\u0007\u00a2\u0006\u0002\u0010\u001fJ%\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u000fH\u0007\u00a2\u0006\u0002\u0010 J\u0012\u0010!\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\b\u001a\u00020\tH\u0007J\u001a\u0010!\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u000fH\u0007J\u0010\u0010\"\u001a\u00020#2\u0006\u0010\b\u001a\u00020\tH\u0007J\u0018\u0010\"\u001a\u00020#2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u000fH\u0007J\u0012\u0010$\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\b\u001a\u00020\tH\u0007J\u001a\u0010$\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u000fH\u0007J\u0018\u0010%\u001a\u00020\u00132\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0003J\u0018\u0010*\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\t2\u0006\u0010+\u001a\u00020\u000fH\u0007J \u0010,\u001a\u00020\u00152\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\f2\u0006\u00100\u001a\u00020#H\u0007J\"\u0010,\u001a\u00020\u00152\u0006\u0010-\u001a\u00020.2\b\u00101\u001a\u0004\u0018\u00010\u000f2\u0006\u00100\u001a\u00020#H\u0007J\u0018\u0010,\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\t2\u0006\u0010/\u001a\u00020\fH\u0007J\u001a\u0010,\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\t2\b\u00101\u001a\u0004\u0018\u00010\u000fH\u0007J\u0018\u00102\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u00101\u001a\u00020\u000fH\u0007J\u0010\u00103\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0007J\u0010\u00104\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0007J\u0018\u00104\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u000fH\u0007J\u0010\u00105\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0007J\u0018\u00105\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u000fH\u0007J\u0018\u00106\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u000fH\u0007J\u0010\u00107\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0007J\u0018\u00107\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u000fH\u0007J \u00108\u001a\u00020\u00152\u0006\u0010-\u001a\u00020.2\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u00100\u001a\u00020#H\u0007J\u0018\u00108\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u000fH\u0007J \u00109\u001a\u00020\u00152\u0006\u0010-\u001a\u00020.2\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u00100\u001a\u00020#H\u0007J\u0018\u00109\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u000fH\u0007J \u0010:\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010;\u001a\u00020\u0004H\u0007R\u001a\u0010\u0003\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0003\u0010\u0006\u00a8\u0006="}, d2={"Lcom/tamsiree/rxkit/RxAppTool;", "", "()V", "isAppRoot", "", "isAppRoot$annotations", "()Z", "cleanAppData", "context", "Landroid/content/Context;", "dirs", "", "Ljava/io/File;", "(Landroid/content/Context;[Ljava/io/File;)Z", "dirPaths", "", "(Landroid/content/Context;[Ljava/lang/String;)Z", "getAllAppsInfo", "", "Lcom/tamsiree/rxkit/RxAppTool$AppInfo;", "getAppDetailsSettings", "", "packageName", "getAppIcon", "Landroid/graphics/drawable/Drawable;", "getAppInfo", "getAppName", "getAppPackageName", "getAppPath", "getAppSignature", "Landroid/content/pm/Signature;", "(Landroid/content/Context;)[Landroid/content/pm/Signature;", "(Landroid/content/Context;Ljava/lang/String;)[Landroid/content/pm/Signature;", "getAppSignatureSHA1", "getAppVersionCode", "", "getAppVersionName", "getBean", "pm", "Landroid/content/pm/PackageManager;", "pi", "Landroid/content/pm/PackageInfo;", "installAPK", "APK_PATH", "installApp", "activity", "Landroid/app/Activity;", "file", "requestCode", "filePath", "installAppSilent", "isAppBackground", "isAppDebug", "isAppForeground", "isInstallApp", "isSystemApp", "launchApp", "uninstallApp", "uninstallAppSilent", "isKeepData", "AppInfo", "RxKit_release"})
public final class RxAppTool {
    @NotNull
    public static final RxAppTool INSTANCE = new RxAppTool();

    private RxAppTool() {
    }

    @JvmStatic
    public static final void installApp(@NotNull Context context, @Nullable String filePath) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        context.startActivity(RxIntentTool.getInstallAppIntent(context, filePath));
    }

    @JvmStatic
    public static final void installApp(@NotNull Context context, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!RxFileTool.Companion.isFileExists(file)) {
            return;
        }
        RxAppTool.installApp(context, file.getAbsolutePath());
    }

    @JvmStatic
    public static final void installApp(@NotNull Activity activity, @Nullable String filePath, int requestCode) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        activity.startActivityForResult(RxIntentTool.getInstallAppIntent((Context)activity, filePath), requestCode);
    }

    @JvmStatic
    public static final void installApp(@NotNull Activity activity, @NotNull File file, int requestCode) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!RxFileTool.Companion.isFileExists(file)) {
            return;
        }
        RxAppTool.installApp(activity, file.getAbsolutePath(), requestCode);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final boolean installAppSilent(@NotNull Context context, @NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        File file = RxFileTool.Companion.getFileByPath(filePath);
        if (!RxFileTool.Companion.isFileExists(file)) {
            return false;
        }
        String command = Intrinsics.stringPlus((String)"LD_LIBRARY_PATH=/vendor/lib:/system/lib pm install ", (Object)filePath);
        RxShellTool.CommandResult commandResult = RxShellTool.execCmd(command, !RxAppTool.isSystemApp(context), true);
        if (commandResult.getSuccessMsg() == null) return false;
        String string = commandResult.getSuccessMsg();
        Intrinsics.checkNotNull((Object)string);
        Locale locale = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
        boolean bl = false;
        String string2 = string;
        boolean bl2 = false;
        String string3 = string2.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase(locale)");
        if (!StringsKt.contains$default((CharSequence)string3, (CharSequence)"success", (boolean)false, (int)2, null)) return false;
        return true;
    }

    @JvmStatic
    public static final boolean isSystemApp(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String string = context.getPackageName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.packageName");
        return RxAppTool.isSystemApp(context, string);
    }

    @JvmStatic
    public static final boolean isSystemApp(@NotNull Context context, @NotNull String packageName) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        if (RxDataTool.Companion.isNullString(packageName)) {
            bl = false;
        } else {
            boolean bl2;
            try {
                PackageManager pm = context.getPackageManager();
                ApplicationInfo ai = pm.getApplicationInfo(packageName, 0);
                bl2 = (ai.flags & 1) != 0;
            }
            catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
                bl2 = false;
            }
            bl = bl2;
        }
        return bl;
    }

    @JvmStatic
    public static final void uninstallApp(@NotNull Context context, @NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        if (RxDataTool.Companion.isNullString(packageName)) {
            return;
        }
        context.startActivity(RxIntentTool.getUninstallAppIntent(packageName));
    }

    @JvmStatic
    public static final void uninstallApp(@NotNull Activity activity, @NotNull String packageName, int requestCode) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        if (RxDataTool.Companion.isNullString(packageName)) {
            return;
        }
        activity.startActivityForResult(RxIntentTool.getUninstallAppIntent(packageName), requestCode);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final boolean uninstallAppSilent(@NotNull Context context, @NotNull String packageName, boolean isKeepData) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        if (RxDataTool.Companion.isNullString(packageName)) {
            return false;
        }
        String command = "LD_LIBRARY_PATH=/vendor/lib:/system/lib pm uninstall " + (isKeepData ? "-k " : "") + packageName;
        RxShellTool.CommandResult commandResult = RxShellTool.execCmd(command, !RxAppTool.isSystemApp(context), true);
        if (commandResult.getSuccessMsg() == null) return false;
        String string = commandResult.getSuccessMsg();
        Intrinsics.checkNotNull((Object)string);
        boolean bl = false;
        String string2 = string.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
        if (!StringsKt.contains$default((CharSequence)string2, (CharSequence)"success", (boolean)false, (int)2, null)) return false;
        return true;
    }

    public static final boolean isAppRoot() {
        RxShellTool.CommandResult result = RxShellTool.execCmd("echo root", true);
        if (result.getResult() == 0) {
            return true;
        }
        if (result.getErrorMsg() != null) {
            TLog.d$default("isAppRoot", result.getErrorMsg(), null, 4, null);
        }
        return false;
    }

    @JvmStatic
    public static /* synthetic */ void isAppRoot$annotations() {
    }

    @JvmStatic
    public static final void launchApp(@NotNull Context context, @NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        if (RxDataTool.Companion.isNullString(packageName)) {
            return;
        }
        context.startActivity(RxIntentTool.getLaunchAppIntent(context, packageName));
    }

    @JvmStatic
    public static final void launchApp(@NotNull Activity activity, @NotNull String packageName, int requestCode) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        if (RxDataTool.Companion.isNullString(packageName)) {
            return;
        }
        activity.startActivityForResult(RxIntentTool.getLaunchAppIntent((Context)activity, packageName), requestCode);
    }

    @JvmStatic
    @NotNull
    public static final String getAppPackageName(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String string = context.getPackageName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.packageName");
        return string;
    }

    @JvmStatic
    public static final void getAppDetailsSettings(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        RxAppTool.getAppDetailsSettings(context, context.getPackageName());
    }

    @JvmStatic
    public static final void getAppDetailsSettings(@NotNull Context context, @Nullable String packageName) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (RxDataTool.Companion.isNullString(packageName)) {
            return;
        }
        context.startActivity(RxIntentTool.getAppDetailsSettingsIntent(packageName));
    }

    @JvmStatic
    @Nullable
    public static final String getAppName(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String string = context.getPackageName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.packageName");
        return RxAppTool.getAppName(context, string);
    }

    @JvmStatic
    @Nullable
    public static final String getAppName(@NotNull Context context, @NotNull String packageName) {
        String string;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        if (RxDataTool.Companion.isNullString(packageName)) {
            string = null;
        } else {
            String string2;
            try {
                ApplicationInfo applicationInfo;
                PackageManager pm = context.getPackageManager();
                PackageInfo pi = pm.getPackageInfo(packageName, 0);
                Object object = pi;
                ApplicationInfo applicationInfo2 = applicationInfo = object == null ? null : ((PackageInfo)object).applicationInfo;
                string2 = applicationInfo == null ? null : ((object = applicationInfo.loadLabel(pm)) == null ? null : object.toString());
            }
            catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
                string2 = null;
            }
            string = string2;
        }
        return string;
    }

    @JvmStatic
    @Nullable
    public static final Drawable getAppIcon(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String string = context.getPackageName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.packageName");
        return RxAppTool.getAppIcon(context, string);
    }

    @JvmStatic
    @Nullable
    public static final Drawable getAppIcon(@NotNull Context context, @NotNull String packageName) {
        Drawable drawable;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        if (RxDataTool.Companion.isNullString(packageName)) {
            drawable = null;
        } else {
            Drawable drawable2;
            try {
                ApplicationInfo applicationInfo;
                PackageInfo pi;
                PackageManager pm = context.getPackageManager();
                PackageInfo packageInfo = pi = pm.getPackageInfo(packageName, 0);
                drawable2 = packageInfo == null ? null : ((applicationInfo = packageInfo.applicationInfo) == null ? null : applicationInfo.loadIcon(pm));
            }
            catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
                drawable2 = null;
            }
            drawable = drawable2;
        }
        return drawable;
    }

    @JvmStatic
    @Nullable
    public static final String getAppPath(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String string = context.getPackageName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.packageName");
        return RxAppTool.getAppPath(context, string);
    }

    @JvmStatic
    @Nullable
    public static final String getAppPath(@NotNull Context context, @NotNull String packageName) {
        String string;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        if (RxDataTool.Companion.isNullString(packageName)) {
            string = null;
        } else {
            String string2;
            try {
                ApplicationInfo applicationInfo;
                PackageInfo pi;
                PackageManager pm = context.getPackageManager();
                PackageInfo packageInfo = pi = pm.getPackageInfo(packageName, 0);
                string2 = packageInfo == null ? null : ((applicationInfo = packageInfo.applicationInfo) == null ? null : applicationInfo.sourceDir);
            }
            catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
                string2 = null;
            }
            string = string2;
        }
        return string;
    }

    @JvmStatic
    @Nullable
    public static final String getAppVersionName(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String string = context.getPackageName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.packageName");
        return RxAppTool.getAppVersionName(context, string);
    }

    @JvmStatic
    @Nullable
    public static final String getAppVersionName(@NotNull Context context, @NotNull String packageName) {
        String string;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        if (RxDataTool.Companion.isNullString(packageName)) {
            string = null;
        } else {
            String string2;
            try {
                PackageInfo pi;
                PackageManager pm = context.getPackageManager();
                PackageInfo packageInfo = pi = pm.getPackageInfo(packageName, 0);
                string2 = packageInfo == null ? null : packageInfo.versionName;
            }
            catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
                string2 = null;
            }
            string = string2;
        }
        return string;
    }

    @JvmStatic
    public static final int getAppVersionCode(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String string = context.getPackageName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.packageName");
        return RxAppTool.getAppVersionCode(context, string);
    }

    @JvmStatic
    public static final int getAppVersionCode(@NotNull Context context, @NotNull String packageName) {
        int n;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        if (RxDataTool.Companion.isNullString(packageName)) {
            n = -1;
        } else {
            int n2;
            try {
                int n3;
                PackageInfo pi;
                PackageManager pm = context.getPackageManager();
                PackageInfo packageInfo = pi = pm.getPackageInfo(packageName, 0);
                n2 = packageInfo == null ? -1 : (n3 = packageInfo.versionCode);
            }
            catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
                n2 = -1;
            }
            n = n2;
        }
        return n;
    }

    @JvmStatic
    public static final boolean isAppDebug(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String string = context.getPackageName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.packageName");
        return RxAppTool.isAppDebug(context, string);
    }

    @JvmStatic
    public static final boolean isAppDebug(@NotNull Context context, @NotNull String packageName) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        if (RxDataTool.Companion.isNullString(packageName)) {
            bl = false;
        } else {
            boolean bl2;
            try {
                PackageManager pm = context.getPackageManager();
                ApplicationInfo ai = pm.getApplicationInfo(packageName, 0);
                bl2 = ai != null && (ai.flags & 2) != 0;
            }
            catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
                bl2 = false;
            }
            bl = bl2;
        }
        return bl;
    }

    @JvmStatic
    @Nullable
    public static final Signature[] getAppSignature(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String string = context.getPackageName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.packageName");
        return RxAppTool.getAppSignature(context, string);
    }

    @JvmStatic
    @SuppressLint(value={"PackageManagerGetSignatures"})
    @Nullable
    public static final Signature[] getAppSignature(@NotNull Context context, @NotNull String packageName) {
        Signature[] signatureArray;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        if (RxDataTool.Companion.isNullString(packageName)) {
            signatureArray = null;
        } else {
            Signature[] signatureArray2;
            try {
                PackageInfo pi;
                PackageManager pm = context.getPackageManager();
                PackageInfo packageInfo = pi = pm.getPackageInfo(packageName, 64);
                signatureArray2 = packageInfo == null ? null : packageInfo.signatures;
            }
            catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
                signatureArray2 = null;
            }
            signatureArray = signatureArray2;
        }
        return signatureArray;
    }

    @JvmStatic
    @Nullable
    public static final String getAppSignatureSHA1(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String string = context.getPackageName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.packageName");
        return RxAppTool.getAppSignatureSHA1(context, string);
    }

    @JvmStatic
    @Nullable
    public static final String getAppSignatureSHA1(@NotNull Context context, @NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Object object = RxAppTool.getAppSignature(context, packageName);
        if (object == null) {
            return null;
        }
        Signature[] signature = object;
        object = RxEncryptTool.encryptSHA1ToString(signature[0].toByteArray());
        String string = "(?<=[0-9A-F]{2})[0-9A-F]{2}";
        boolean bl = false;
        string = new Regex(string);
        String string2 = ":$0";
        boolean bl2 = false;
        return string.replace((CharSequence)object, string2);
    }

    @JvmStatic
    public static final boolean isAppForeground(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("activity");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.app.ActivityManager");
        }
        ActivityManager manager = (ActivityManager)object;
        List infos = manager.getRunningAppProcesses();
        if (infos == null || infos.size() == 0) {
            return false;
        }
        for (ActivityManager.RunningAppProcessInfo info : infos) {
            if (info.importance != 100) continue;
            return Intrinsics.areEqual((Object)info.processName, (Object)context.getPackageName());
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final boolean isAppForeground(@NotNull Context context, @NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        if (RxDataTool.Companion.isNullString(packageName)) return false;
        if (!Intrinsics.areEqual((Object)packageName, (Object)RxProcessTool.getForegroundProcessName(context))) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final boolean isInstallApp(@NotNull Context context, @NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        if (RxDataTool.Companion.isNullString(packageName)) return false;
        if (RxIntentTool.getLaunchAppIntent(context, packageName) == null) return false;
        return true;
    }

    @JvmStatic
    public static final void installAPK(@NotNull Context context, @NotNull String APK_PATH) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)APK_PATH, (String)"APK_PATH");
        Intent i = new Intent("android.intent.action.VIEW");
        i.setFlags(0x10000000);
        i.setDataAndType(Uri.parse((String)Intrinsics.stringPlus((String)"file://", (Object)APK_PATH)), "application/vnd.android.package-archive");
        context.startActivity(i);
    }

    @JvmStatic
    @Nullable
    public static final AppInfo getAppInfo(@NotNull Context context) {
        AppInfo appInfo;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        PackageManager pm = context.getPackageManager();
        PackageInfo pi = null;
        try {
            pi = pm.getPackageInfo(context.getApplicationContext().getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        PackageInfo packageInfo = pi;
        if (packageInfo == null) {
            appInfo = null;
        } else {
            PackageInfo packageInfo2 = packageInfo;
            boolean bl = false;
            boolean bl2 = false;
            PackageInfo it = packageInfo2;
            boolean bl3 = false;
            Intrinsics.checkNotNullExpressionValue((Object)pm, (String)"pm");
            appInfo = RxAppTool.getBean(pm, it);
        }
        return appInfo;
    }

    @JvmStatic
    private static final AppInfo getBean(PackageManager pm, PackageInfo pi) {
        ApplicationInfo ai = pi.applicationInfo;
        String name = ((Object)ai.loadLabel(pm)).toString();
        Drawable icon = ai.loadIcon(pm);
        String packageName = pi.packageName;
        String packagePath = ai.sourceDir;
        String versionName = pi.versionName;
        int versionCode = pi.versionCode;
        boolean isSD = (1 & ai.flags) != 1;
        boolean isUser = (1 & ai.flags) != 1;
        return new AppInfo(name, icon, packageName, packagePath, versionName, versionCode, isSD, isUser);
    }

    @JvmStatic
    @NotNull
    public static final List<AppInfo> getAllAppsInfo(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        List list = new ArrayList();
        PackageManager pm = context.getPackageManager();
        List installedPackages = pm.getInstalledPackages(0);
        for (PackageInfo pi : installedPackages) {
            if (pi == null) continue;
            Intrinsics.checkNotNullExpressionValue((Object)pm, (String)"pm");
            list.add(RxAppTool.getBean(pm, pi));
        }
        return list;
    }

    @JvmStatic
    public static final boolean isAppBackground(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("activity");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.app.ActivityManager");
        }
        ActivityManager am = (ActivityManager)object;
        List tasks = am.getRunningTasks(1);
        if (!tasks.isEmpty()) {
            ComponentName topActivity = ((ActivityManager.RunningTaskInfo)tasks.get((int)0)).topActivity;
            Intrinsics.checkNotNull((Object)topActivity);
            return !Intrinsics.areEqual((Object)topActivity.getPackageName(), (Object)context.getPackageName());
        }
        return false;
    }

    @JvmStatic
    public static final boolean cleanAppData(@NotNull Context context, String ... dirPaths) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)dirPaths, (String)"dirPaths");
        File[] dirs = new File[dirPaths.length];
        int i = 0;
        for (String dirPath : dirPaths) {
            int n = i;
            i = n + 1;
            dirs[n] = new File(dirPath);
        }
        return RxAppTool.cleanAppData(context, Arrays.copyOf(dirs, dirs.length));
    }

    @JvmStatic
    public static final boolean cleanAppData(@NotNull Context context, File ... dirs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)dirs, (String)"dirs");
        boolean isSuccess = RxFileTool.Companion.cleanInternalCache(context);
        isSuccess &= RxFileTool.Companion.cleanInternalDbs(context);
        isSuccess &= RxFileTool.Companion.cleanInternalSP(context);
        isSuccess &= RxFileTool.Companion.cleanInternalFiles(context);
        isSuccess &= RxFileTool.Companion.cleanExternalCache(context);
        File[] fileArray = dirs;
        int n = 0;
        int n2 = fileArray.length;
        while (n < n2) {
            File dir = fileArray[n];
            ++n;
            isSuccess &= RxFileTool.Companion.cleanCustomCache(dir);
        }
        return isSuccess;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0019\u0018\u00002\u00020\u0001BO\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0002\u0010\u000eR\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\r\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u0013\"\u0004\b\u0016\u0010\u0015R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0018\"\u0004\b\u001c\u0010\u001aR\u001c\u0010\u0007\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0018\"\u0004\b\u001e\u0010\u001aR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001c\u0010\b\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0018\"\u0004\b$\u0010\u001a\u00a8\u0006%"}, d2={"Lcom/tamsiree/rxkit/RxAppTool$AppInfo;", "", "name", "", "icon", "Landroid/graphics/drawable/Drawable;", "packageName", "packagePath", "versionName", "versionCode", "", "isSD", "", "isUser", "(Ljava/lang/String;Landroid/graphics/drawable/Drawable;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;IZZ)V", "getIcon", "()Landroid/graphics/drawable/Drawable;", "setIcon", "(Landroid/graphics/drawable/Drawable;)V", "()Z", "setSD", "(Z)V", "setUser", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "getPackageName", "setPackageName", "getPackagePath", "setPackagePath", "getVersionCode", "()I", "setVersionCode", "(I)V", "getVersionName", "setVersionName", "RxKit_release"})
    public static final class AppInfo {
        @Nullable
        private String name;
        @Nullable
        private Drawable icon;
        @Nullable
        private String packageName;
        @Nullable
        private String packagePath;
        @Nullable
        private String versionName;
        private int versionCode;
        private boolean isSD;
        private boolean isUser;

        public AppInfo(@Nullable String name, @Nullable Drawable icon, @Nullable String packageName, @Nullable String packagePath, @Nullable String versionName, int versionCode, boolean isSD, boolean isUser) {
            this.name = name;
            this.icon = icon;
            this.packageName = packageName;
            this.packagePath = packagePath;
            this.versionName = versionName;
            this.versionCode = versionCode;
            this.isSD = isSD;
            this.isUser = isUser;
        }

        @Nullable
        public final String getName() {
            return this.name;
        }

        public final void setName(@Nullable String string) {
            this.name = string;
        }

        @Nullable
        public final Drawable getIcon() {
            return this.icon;
        }

        public final void setIcon(@Nullable Drawable drawable) {
            this.icon = drawable;
        }

        @Nullable
        public final String getPackageName() {
            return this.packageName;
        }

        public final void setPackageName(@Nullable String string) {
            this.packageName = string;
        }

        @Nullable
        public final String getPackagePath() {
            return this.packagePath;
        }

        public final void setPackagePath(@Nullable String string) {
            this.packagePath = string;
        }

        @Nullable
        public final String getVersionName() {
            return this.versionName;
        }

        public final void setVersionName(@Nullable String string) {
            this.versionName = string;
        }

        public final int getVersionCode() {
            return this.versionCode;
        }

        public final void setVersionCode(int n) {
            this.versionCode = n;
        }

        public final boolean isSD() {
            return this.isSD;
        }

        public final void setSD(boolean bl) {
            this.isSD = bl;
        }

        public final boolean isUser() {
            return this.isUser;
        }

        public final void setUser(boolean bl) {
            this.isUser = bl;
        }
    }
}

