/*
 * Decompiled with CFR 0.152.
 */
package com.tamsiree.rxkit.crash;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.ResolveInfo;
import android.os.Build;
import android.os.Bundle;
import android.os.Process;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.tamsiree.rxkit.RxAppTool;
import com.tamsiree.rxkit.RxDataTool;
import com.tamsiree.rxkit.TLog;
import com.tamsiree.rxkit.activity.ActivityCrash;
import com.tamsiree.rxkit.crash.RxCrashConfig;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.ref.WeakReference;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayDeque;
import java.util.Date;
import java.util.Deque;
import java.util.List;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class RxCrashTool {
    private static final String TAG = "RxCrashTool";
    private static final String EXTRA_CONFIG = "com.tamsiree.rxkit.crash.rxcrashtool.EXTRA_CONFIG";
    private static final String EXTRA_STACK_TRACE = "com.tamsiree.rxkit.crash.rxcrashtool.EXTRA_STACK_TRACE";
    private static final String EXTRA_ACTIVITY_LOG = "com.tamsiree.rxkit.crash.rxcrashtool.EXTRA_ACTIVITY_LOG";
    private static final String INTENT_ACTION_ERROR_ACTIVITY = "com.tamsiree.rxkit.crash.rxcrashtool.ERROR";
    private static final String INTENT_ACTION_RESTART_ACTIVITY = "com.tamsiree.rxkit.crash.rxcrashtool.RESTART";
    private static final String CAOC_HANDLER_PACKAGE_NAME = "com.tamsiree.rxkit.crash.rxcrashtool";
    private static final String DEFAULT_HANDLER_PACKAGE_NAME = "com.android.internal.os";
    private static final int TIME_TO_CONSIDER_FOREGROUND_MS = 500;
    private static final int MAX_STACK_TRACE_SIZE = 131071;
    private static final int MAX_ACTIVITIES_IN_LOG = 50;
    private static final String SHARED_PREFERENCES_FILE = "RxCrashTool";
    private static final String SHARED_PREFERENCES_FIELD_TIMESTAMP = "last_crash_timestamp";
    private static final Deque<String> activityLog = new ArrayDeque<String>(50);
    @SuppressLint(value={"StaticFieldLeak"})
    private static Application application;
    private static RxCrashConfig config;
    private static WeakReference<Activity> lastActivityCreated;
    private static long lastActivityCreatedTimestamp;
    private static boolean isInBackground;

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static void install(@Nullable Context context) {
        try {
            if (context == null) {
                TLog.e("RxCrashTool", "Install failed: context is null!");
            } else {
                Thread.UncaughtExceptionHandler oldHandler = Thread.getDefaultUncaughtExceptionHandler();
                if (oldHandler != null && oldHandler.getClass().getName().startsWith(CAOC_HANDLER_PACKAGE_NAME)) {
                    TLog.e("RxCrashTool", "RxCrashTool was already installed, doing nothing!");
                } else {
                    if (oldHandler != null && !oldHandler.getClass().getName().startsWith(DEFAULT_HANDLER_PACKAGE_NAME)) {
                        TLog.e("RxCrashTool", "IMPORTANT WARNING! You already have an UncaughtExceptionHandler, are you sure this is correct? If you use a custom UncaughtExceptionHandler, you must initialize it AFTER RxCrashTool! Installing anyway, but your original handler will not be called.");
                    }
                    application = (Application)context.getApplicationContext();
                    Thread.setDefaultUncaughtExceptionHandler((thread, throwable) -> {
                        if (config.isEnabled()) {
                            Activity lastActivity;
                            TLog.e("RxCrashTool", "App has crashed, executing RxCrashTool's UncaughtExceptionHandler", throwable);
                            if (RxCrashTool.hasCrashedInTheLastSeconds((Context)application)) {
                                TLog.e("RxCrashTool", "App already crashed recently, not starting custom error activity because we could enter a restart loop. Are you sure that your app does not crash directly on init?", throwable);
                                if (oldHandler != null) {
                                    oldHandler.uncaughtException(thread, throwable);
                                    return;
                                }
                            } else {
                                RxCrashTool.setLastCrashTimestamp((Context)application, new Date().getTime());
                                Class<? extends Activity> errorActivityClass = config.getErrorActivityClass();
                                if (errorActivityClass == null) {
                                    errorActivityClass = RxCrashTool.guessErrorActivityClass((Context)application);
                                }
                                if (RxCrashTool.isStackTraceLikelyConflictive(throwable, errorActivityClass)) {
                                    TLog.e("RxCrashTool", "Your application class or your error activity have crashed, the custom activity will not be launched!");
                                    if (oldHandler != null) {
                                        oldHandler.uncaughtException(thread, throwable);
                                        return;
                                    }
                                } else if (config.getBackgroundMode() == 1 || !isInBackground || lastActivityCreatedTimestamp >= new Date().getTime() - 500L) {
                                    Intent intent = new Intent((Context)application, errorActivityClass);
                                    StringWriter sw = new StringWriter();
                                    PrintWriter pw = new PrintWriter(sw);
                                    throwable.printStackTrace(pw);
                                    String stackTraceString = sw.toString();
                                    if (stackTraceString.length() > 131071) {
                                        String disclaimer = " [stack trace too large]";
                                        stackTraceString = stackTraceString.substring(0, 131071 - disclaimer.length()) + disclaimer;
                                    }
                                    intent.putExtra(EXTRA_STACK_TRACE, stackTraceString);
                                    if (config.isTrackActivities()) {
                                        StringBuilder activityLogStringBuilder = new StringBuilder();
                                        while (!activityLog.isEmpty()) {
                                            activityLogStringBuilder.append(activityLog.poll());
                                        }
                                        intent.putExtra(EXTRA_ACTIVITY_LOG, activityLogStringBuilder.toString());
                                    }
                                    if (config.isShowRestartButton() && config.getRestartActivityClass() == null) {
                                        config.setRestartActivityClass(RxCrashTool.guessRestartActivityClass((Context)application));
                                    }
                                    intent.putExtra(EXTRA_CONFIG, (Serializable)config);
                                    intent.setFlags(0x10008000);
                                    if (config.getEventListener() != null) {
                                        config.getEventListener().onLaunchErrorActivity();
                                    }
                                    application.startActivity(intent);
                                } else if (config.getBackgroundMode() == 2 && oldHandler != null) {
                                    oldHandler.uncaughtException(thread, throwable);
                                    return;
                                }
                            }
                            if ((lastActivity = (Activity)lastActivityCreated.get()) != null) {
                                lastActivity.finish();
                                lastActivityCreated.clear();
                            }
                            RxCrashTool.killCurrentProcess();
                        } else if (oldHandler != null) {
                            oldHandler.uncaughtException(thread, throwable);
                        }
                    });
                    application.registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(){
                        final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.CHINA);
                        int currentlyStartedActivities = 0;

                        public void onActivityCreated(@NonNull Activity activity, Bundle savedInstanceState) {
                            if (activity.getClass() != config.getErrorActivityClass()) {
                                lastActivityCreated = new WeakReference<Activity>(activity);
                                lastActivityCreatedTimestamp = new Date().getTime();
                            }
                            if (config.isTrackActivities()) {
                                activityLog.add(this.dateFormat.format(new Date()) + ": " + activity.getClass().getSimpleName() + " created\n");
                            }
                        }

                        public void onActivityStarted(@NonNull Activity activity) {
                            ++this.currentlyStartedActivities;
                            isInBackground = this.currentlyStartedActivities == 0;
                        }

                        public void onActivityResumed(@NonNull Activity activity) {
                            if (config.isTrackActivities()) {
                                activityLog.add(this.dateFormat.format(new Date()) + ": " + activity.getClass().getSimpleName() + " resumed\n");
                            }
                        }

                        public void onActivityPaused(@NonNull Activity activity) {
                            if (config.isTrackActivities()) {
                                activityLog.add(this.dateFormat.format(new Date()) + ": " + activity.getClass().getSimpleName() + " paused\n");
                            }
                        }

                        public void onActivityStopped(@NonNull Activity activity) {
                            --this.currentlyStartedActivities;
                            isInBackground = this.currentlyStartedActivities == 0;
                        }

                        public void onActivitySaveInstanceState(@NonNull Activity activity, @NonNull Bundle outState) {
                        }

                        public void onActivityDestroyed(@NonNull Activity activity) {
                            if (config.isTrackActivities()) {
                                activityLog.add(this.dateFormat.format(new Date()) + ": " + activity.getClass().getSimpleName() + " destroyed\n");
                            }
                        }
                    });
                }
                TLog.i("RxCrashTool", "RxCrashTool has been installed.");
            }
        }
        catch (Throwable t) {
            TLog.e("RxCrashTool", "An unknown error occurred while installing RxCrashTool, it may not have been properly initialized. Please report this as a bug if needed.", t);
        }
    }

    @Nullable
    public static String getStackTraceFromIntent(@NonNull Intent intent) {
        return intent.getStringExtra(EXTRA_STACK_TRACE);
    }

    @Nullable
    public static RxCrashConfig getConfigFromIntent(@NonNull Intent intent) {
        String stackTrace;
        RxCrashConfig config = (RxCrashConfig)intent.getSerializableExtra(EXTRA_CONFIG);
        if (config != null && config.isLogErrorOnRestart() && (stackTrace = RxCrashTool.getStackTraceFromIntent(intent)) != null) {
            TLog.e("RxCrashTool", "The previous app process crashed. This is the stack trace of the crash:\n" + RxCrashTool.getStackTraceFromIntent(intent));
        }
        return config;
    }

    @Nullable
    public static String getActivityLogFromIntent(@NonNull Intent intent) {
        return intent.getStringExtra(EXTRA_ACTIVITY_LOG);
    }

    @NonNull
    public static String getAllErrorDetailsFromIntent(@NonNull Context context, @NonNull Intent intent) {
        Date currentDate = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5 HH\u70b9mm\u5206ss\u79d2", Locale.CHINA);
        String buildDateAsString = RxCrashTool.getBuildDateAsString(context, dateFormat);
        String versionName = RxCrashTool.getVersionName(context);
        String appName = RxCrashTool.getAppName(context);
        String packageName = RxCrashTool.getPackageName(context);
        String errorDetails = "";
        errorDetails = errorDetails + "Build App Name : " + appName + " \n";
        errorDetails = errorDetails + "Build version : " + versionName + " \n";
        errorDetails = errorDetails + "Build Package Name : " + packageName + " \n";
        if (buildDateAsString != null) {
            errorDetails = errorDetails + "Build date : " + buildDateAsString + " \n";
        }
        errorDetails = errorDetails + "Current date : " + dateFormat.format(currentDate) + " \n";
        errorDetails = errorDetails + "Device : " + RxCrashTool.getDeviceModelName() + " \n";
        errorDetails = errorDetails + "OS version : Android " + Build.VERSION.RELEASE + " (SDK " + Build.VERSION.SDK_INT + ") \n \n";
        errorDetails = errorDetails + "Stack trace :  \n";
        errorDetails = errorDetails + RxCrashTool.getStackTraceFromIntent(intent);
        String activityLog = RxCrashTool.getActivityLogFromIntent(intent);
        if (activityLog != null) {
            errorDetails = errorDetails + "\nUser actions : \n";
            errorDetails = errorDetails + activityLog;
        }
        return errorDetails;
    }

    public static void restartApplicationWithIntent(@NonNull Activity activity, @NonNull Intent intent, @NonNull RxCrashConfig config) {
        intent.addFlags(270565376);
        if (intent.getComponent() != null) {
            intent.setAction("android.intent.action.MAIN");
            intent.addCategory("android.intent.category.LAUNCHER");
        }
        if (config.getEventListener() != null) {
            config.getEventListener().onRestartAppFromErrorActivity();
        }
        activity.finish();
        activity.startActivity(intent);
        activity.overridePendingTransition(0x10A0000, 0x10A0001);
        RxCrashTool.killCurrentProcess();
    }

    public static void restartApplication(@NonNull Activity activity, @NonNull RxCrashConfig config) {
        Intent intent = new Intent((Context)activity, config.getRestartActivityClass());
        RxCrashTool.restartApplicationWithIntent(activity, intent, config);
    }

    public static void closeApplication(@NonNull Activity activity, @NonNull RxCrashConfig config) {
        if (config.getEventListener() != null) {
            config.getEventListener().onCloseAppFromErrorActivity();
        }
        activity.finish();
        RxCrashTool.killCurrentProcess();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @NonNull
    public static RxCrashConfig getConfig() {
        return config;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static void setConfig(@NonNull RxCrashConfig config) {
        RxCrashTool.config = config;
    }

    private static boolean isStackTraceLikelyConflictive(@NonNull Throwable throwable, @NonNull Class<? extends Activity> activityClass) {
        String process;
        try {
            BufferedReader br = new BufferedReader(new FileReader("/proc/self/cmdline"));
            process = br.readLine().trim();
            br.close();
        }
        catch (IOException e) {
            process = null;
        }
        if (process != null && process.endsWith(":error_activity")) {
            return true;
        }
        do {
            StackTraceElement[] stackTrace;
            for (StackTraceElement element : stackTrace = throwable.getStackTrace()) {
                if (!element.getClassName().equals("android.app.ActivityThread") || !element.getMethodName().equals("handleBindApplication")) continue;
                return true;
            }
        } while ((throwable = throwable.getCause()) != null);
        return false;
    }

    @Nullable
    private static String getBuildDateAsString(@NonNull Context context, @NonNull DateFormat dateFormat) {
        long buildDate;
        try {
            ApplicationInfo ai = context.getPackageManager().getApplicationInfo(context.getPackageName(), 0);
            ZipFile zf = new ZipFile(ai.sourceDir);
            ZipEntry ze = zf.getEntry("classes.dex");
            buildDate = ze.getTime();
            zf.close();
        }
        catch (Exception e) {
            buildDate = 0L;
        }
        if (buildDate > 312764400000L) {
            return dateFormat.format(new Date(buildDate));
        }
        return null;
    }

    @NonNull
    private static String getVersionName(Context context) {
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            return packageInfo.versionName;
        }
        catch (Exception e) {
            return "Unknown";
        }
    }

    public static String getAppName(Context context) {
        String appName = RxAppTool.getAppName(context);
        if (RxDataTool.isNullString(appName)) {
            return "Unknown";
        }
        return appName;
    }

    private static String getPackageName(Context context) {
        String appName = context.getPackageName();
        if (RxDataTool.isNullString(appName)) {
            return "Unknown";
        }
        return appName;
    }

    @NonNull
    private static String getDeviceModelName() {
        String model = Build.MODEL;
        String manufacturer = Build.MANUFACTURER;
        if (model.startsWith(manufacturer)) {
            return RxCrashTool.capitalize(model);
        }
        return RxCrashTool.capitalize(manufacturer) + " " + model;
    }

    @NonNull
    private static String capitalize(@Nullable String s) {
        if (s == null || s.length() == 0) {
            return "";
        }
        char first = s.charAt(0);
        if (Character.isUpperCase(first)) {
            return s;
        }
        return Character.toUpperCase(first) + s.substring(1);
    }

    @Nullable
    private static Class<? extends Activity> guessRestartActivityClass(@NonNull Context context) {
        Class<? extends Activity> resolvedActivityClass = RxCrashTool.getRestartActivityClassWithIntentFilter(context);
        if (resolvedActivityClass == null) {
            resolvedActivityClass = RxCrashTool.getLauncherActivity(context);
        }
        return resolvedActivityClass;
    }

    @Nullable
    private static Class<? extends Activity> getRestartActivityClassWithIntentFilter(@NonNull Context context) {
        Intent searchedIntent = new Intent().setAction(INTENT_ACTION_RESTART_ACTIVITY).setPackage(context.getPackageName());
        List resolveInfos = context.getPackageManager().queryIntentActivities(searchedIntent, 64);
        if (resolveInfos.size() > 0) {
            ResolveInfo resolveInfo = (ResolveInfo)resolveInfos.get(0);
            try {
                return Class.forName(resolveInfo.activityInfo.name);
            }
            catch (ClassNotFoundException e) {
                TLog.e("RxCrashTool", "Failed when resolving the restart activity class via intent filter, stack trace follows!", e);
            }
        }
        return null;
    }

    @Nullable
    private static Class<? extends Activity> getLauncherActivity(@NonNull Context context) {
        Intent intent = context.getPackageManager().getLaunchIntentForPackage(context.getPackageName());
        if (intent != null && intent.getComponent() != null) {
            try {
                return Class.forName(intent.getComponent().getClassName());
            }
            catch (ClassNotFoundException e) {
                TLog.e("RxCrashTool", "Failed when resolving the restart activity class via getLaunchIntentForPackage, stack trace follows!", e);
            }
        }
        return null;
    }

    @NonNull
    private static Class<? extends Activity> guessErrorActivityClass(@NonNull Context context) {
        Class<Object> resolvedActivityClass = RxCrashTool.getErrorActivityClassWithIntentFilter(context);
        if (resolvedActivityClass == null) {
            resolvedActivityClass = ActivityCrash.class;
        }
        return resolvedActivityClass;
    }

    @Nullable
    private static Class<? extends Activity> getErrorActivityClassWithIntentFilter(@NonNull Context context) {
        Intent searchedIntent = new Intent().setAction(INTENT_ACTION_ERROR_ACTIVITY).setPackage(context.getPackageName());
        List resolveInfos = context.getPackageManager().queryIntentActivities(searchedIntent, 64);
        if (resolveInfos.size() > 0) {
            ResolveInfo resolveInfo = (ResolveInfo)resolveInfos.get(0);
            try {
                return Class.forName(resolveInfo.activityInfo.name);
            }
            catch (ClassNotFoundException e) {
                TLog.e("RxCrashTool", "Failed when resolving the error activity class via intent filter, stack trace follows!", e);
            }
        }
        return null;
    }

    private static void killCurrentProcess() {
        Process.killProcess((int)Process.myPid());
        System.exit(10);
    }

    @SuppressLint(value={"ApplySharedPref"})
    private static void setLastCrashTimestamp(@NonNull Context context, long timestamp) {
        context.getSharedPreferences("RxCrashTool", 0).edit().putLong(SHARED_PREFERENCES_FIELD_TIMESTAMP, timestamp).commit();
    }

    private static long getLastCrashTimestamp(@NonNull Context context) {
        return context.getSharedPreferences("RxCrashTool", 0).getLong(SHARED_PREFERENCES_FIELD_TIMESTAMP, -1L);
    }

    private static boolean hasCrashedInTheLastSeconds(@NonNull Context context) {
        long currentTimestamp;
        long lastTimestamp = RxCrashTool.getLastCrashTimestamp(context);
        return lastTimestamp <= (currentTimestamp = new Date().getTime()) && currentTimestamp - lastTimestamp < (long)config.getMinTimeBetweenCrashesMs();
    }

    static {
        config = new RxCrashConfig();
        lastActivityCreated = new WeakReference<Object>(null);
        lastActivityCreatedTimestamp = 0L;
        isInBackground = true;
    }

    public static interface EventListener
    extends Serializable {
        public void onLaunchErrorActivity();

        public void onRestartAppFromErrorActivity();

        public void onCloseAppFromErrorActivity();
    }
}

