/*
 * Decompiled with CFR 0.152.
 */
package com.tamsiree.rxkit;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.renderscript.Allocation;
import android.renderscript.Element;
import android.renderscript.RenderScript;
import android.renderscript.ScriptIntrinsicBlur;
import android.renderscript.Type;
import android.widget.ImageView;
import com.tamsiree.rxkit.RxImageTool;
import com.tamsiree.rxkit.RxTool;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u0004H\u0007J,\u0010\u000f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u0007J\u0018\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\rH\u0007J \u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004H\u0007J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004H\u0007J\"\u0010\u0018\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/tamsiree/rxkit/TBlurTool;", "", "()V", "BLUR_RADIUS", "", "SCALED_HEIGHT", "", "SCALED_WIDTH", "blur", "", "imageView", "Landroid/widget/ImageView;", "bitmap", "Landroid/graphics/Bitmap;", "radius", "fastBlur", "src", "scale", "recycle", "", "getBlurBitmap", "context", "Landroid/content/Context;", "renderScriptBlur", "stackBlur", "RxKit_release"})
public final class TBlurTool {
    private static final float BLUR_RADIUS = 20.0f;
    private static final int SCALED_WIDTH = 100;
    private static final int SCALED_HEIGHT = 100;
    public static final TBlurTool INSTANCE;

    @JvmStatic
    @JvmOverloads
    public static final void blur(@NotNull ImageView imageView, @NotNull Bitmap bitmap, float radius) {
        Intrinsics.checkParameterIsNotNull((Object)imageView, (String)"imageView");
        Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
        Context context = imageView.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"imageView.context");
        imageView.setImageBitmap(TBlurTool.getBlurBitmap(context, bitmap, radius));
    }

    public static /* synthetic */ void blur$default(ImageView imageView, Bitmap bitmap, float f, int n, Object object) {
        if ((n & 4) != 0) {
            f = 20.0f;
        }
        TBlurTool.blur(imageView, bitmap, f);
    }

    @JvmStatic
    @JvmOverloads
    public static final void blur(@NotNull ImageView imageView, @NotNull Bitmap bitmap) {
        TBlurTool.blur$default(imageView, bitmap, 0.0f, 4, null);
    }

    @JvmStatic
    @NotNull
    public static final Bitmap getBlurBitmap(@NotNull Context context, @NotNull Bitmap bitmap) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
        return TBlurTool.getBlurBitmap(context, bitmap, 20.0f);
    }

    @JvmStatic
    @NotNull
    public static final Bitmap getBlurBitmap(@NotNull Context context, @NotNull Bitmap bitmap, float radius) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
        Bitmap inputBitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)100, (int)100, (boolean)false);
        Bitmap outputBitmap = Bitmap.createBitmap((Bitmap)inputBitmap);
        RenderScript rs = RenderScript.create((Context)context);
        ScriptIntrinsicBlur blurScript = ScriptIntrinsicBlur.create((RenderScript)rs, (Element)Element.U8_4((RenderScript)rs));
        Allocation tmpIn = Allocation.createFromBitmap((RenderScript)rs, (Bitmap)inputBitmap);
        Allocation tmpOut = Allocation.createFromBitmap((RenderScript)rs, (Bitmap)outputBitmap);
        blurScript.setRadius(radius);
        blurScript.setInput(tmpIn);
        blurScript.forEach(tmpOut);
        tmpOut.copyTo(outputBitmap);
        Bitmap bitmap2 = outputBitmap;
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap2, (String)"outputBitmap");
        return bitmap2;
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final Bitmap fastBlur(@NotNull Bitmap src, float scale, float radius, boolean recycle) {
        Intrinsics.checkParameterIsNotNull((Object)src, (String)"src");
        if (RxImageTool.isEmptyBitmap(src)) {
            return null;
        }
        int width = src.getWidth();
        int height = src.getHeight();
        int scaleWidth = (int)((float)width * scale + 0.5f);
        int scaleHeight = (int)((float)height * scale + 0.5f);
        if (scaleWidth == 0 || scaleHeight == 0) {
            return null;
        }
        Bitmap scaleBitmap = Bitmap.createScaledBitmap((Bitmap)src, (int)scaleWidth, (int)scaleHeight, (boolean)true);
        Paint paint = new Paint(3);
        Canvas canvas = new Canvas();
        PorterDuffColorFilter filter = new PorterDuffColorFilter(0, PorterDuff.Mode.SRC_ATOP);
        paint.setColorFilter((ColorFilter)filter);
        canvas.scale(scale, scale);
        Bitmap bitmap = scaleBitmap;
        if (bitmap == null) {
            Intrinsics.throwNpe();
        }
        canvas.drawBitmap(bitmap, 0.0f, 0.0f, paint);
        scaleBitmap = TBlurTool.renderScriptBlur(scaleBitmap, radius);
        if (scale == 1.0f) {
            return scaleBitmap;
        }
        Bitmap bitmap2 = scaleBitmap;
        if (bitmap2 == null) {
            Intrinsics.throwNpe();
        }
        Bitmap ret = Bitmap.createScaledBitmap((Bitmap)bitmap2, (int)width, (int)height, (boolean)true);
        if (!scaleBitmap.isRecycled()) {
            scaleBitmap.recycle();
        }
        if (recycle && !src.isRecycled()) {
            src.recycle();
        }
        return ret;
    }

    public static /* synthetic */ Bitmap fastBlur$default(Bitmap bitmap, float f, float f2, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        return TBlurTool.fastBlur(bitmap, f, f2, bl);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final Bitmap fastBlur(@NotNull Bitmap src, float scale, float radius) {
        return TBlurTool.fastBlur$default(src, scale, radius, false, 8, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @TargetApi(value=17)
    @Nullable
    public static final Bitmap renderScriptBlur(@NotNull Bitmap src, float radius) {
        Intrinsics.checkParameterIsNotNull((Object)src, (String)"src");
        float mRadius = radius;
        if (RxImageTool.isEmptyBitmap(src)) {
            return null;
        }
        RenderScript rs = null;
        try {
            Allocation input;
            RenderScript renderScript = rs = RenderScript.create((Context)RxTool.getContext());
            Intrinsics.checkExpressionValueIsNotNull((Object)renderScript, (String)"rs");
            renderScript.setMessageHandler(new RenderScript.RSMessageHandler());
            Allocation allocation = input = Allocation.createFromBitmap((RenderScript)rs, (Bitmap)src, (Allocation.MipmapControl)Allocation.MipmapControl.MIPMAP_NONE, (int)1);
            Intrinsics.checkExpressionValueIsNotNull((Object)allocation, (String)"input");
            Allocation output = Allocation.createTyped((RenderScript)rs, (Type)allocation.getType());
            ScriptIntrinsicBlur blurScript = ScriptIntrinsicBlur.create((RenderScript)rs, (Element)Element.U8_4((RenderScript)rs));
            if (mRadius > (float)25) {
                mRadius = 25.0f;
            } else if (mRadius <= 0.0f) {
                mRadius = 1.0f;
            }
            blurScript.setInput(input);
            blurScript.setRadius(mRadius);
            blurScript.forEach(output);
            output.copyTo(src);
        }
        catch (Throwable throwable) {
            RenderScript renderScript = rs;
            if (renderScript != null) {
                renderScript.destroy();
            }
            throw throwable;
        }
        rs.destroy();
        return src;
    }

    @JvmStatic
    @Nullable
    public static final Bitmap stackBlur(@NotNull Bitmap src, int radius, boolean recycle) {
        boolean bl;
        int n;
        int n2;
        Bitmap bitmap;
        Intrinsics.checkParameterIsNotNull((Object)src, (String)"src");
        if (recycle) {
            bitmap = src;
        } else {
            Bitmap bitmap2 = src.copy(src.getConfig(), true);
            bitmap = bitmap2;
            Intrinsics.checkExpressionValueIsNotNull((Object)bitmap2, (String)"src.copy(src.config, true)");
        }
        Bitmap ret = bitmap;
        if (radius < 1) {
            return null;
        }
        int w = ret.getWidth();
        int h = ret.getHeight();
        int[] pix = new int[w * h];
        ret.getPixels(pix, 0, w, 0, 0, w, h);
        int wm = w - 1;
        int hm = h - 1;
        int wh = w * h;
        int div = radius + radius + 1;
        int[] r = new int[wh];
        int[] g = new int[wh];
        int[] b = new int[wh];
        int rsum = 0;
        int gsum = 0;
        int bsum = 0;
        int x = 0;
        int y = 0;
        int i = 0;
        int p = 0;
        int yp = 0;
        int yi = 0;
        int yw = 0;
        boolean bl2 = false;
        int[] vmin = new int[Math.max(w, h)];
        int divsum = div + 1 >> 1;
        divsum *= divsum;
        int[] dv = new int[256 * divsum];
        for (i = 0; i < 256 * divsum; ++i) {
            dv[i] = i / divsum;
        }
        yw = yi = 0;
        int[][] nArrayArray = new int[div][];
        int n3 = 0;
        while (n3 < div) {
            int n4 = n3;
            n2 = n3++;
            int[][] nArrayArray2 = nArrayArray;
            boolean bl3 = false;
            int[] nArray = new int[3];
            nArrayArray2[n2] = nArray;
        }
        int[][] stack = nArrayArray;
        int stackpointer = 0;
        int stackstart = 0;
        int[] sir = null;
        int rbs = 0;
        int r1 = radius + 1;
        int routsum = 0;
        int goutsum = 0;
        int boutsum = 0;
        int rinsum = 0;
        int ginsum = 0;
        int binsum = 0;
        for (y = 0; y < h; ++y) {
            int n5;
            rinsum = ginsum = (binsum = (routsum = (goutsum = (boutsum = (rsum = (gsum = (bsum = 0)))))));
            for (i = -radius; i <= radius; ++i) {
                n = 0;
                n2 = yi;
                int[] nArray = pix;
                bl = false;
                n = n5 = Math.max(i, n);
                bl = false;
                n5 = Math.min(wm, n);
                p = nArray[n2 + n5];
                sir = stack[i + radius];
                sir[0] = (p & 0xFF0000) >> 16;
                sir[1] = (p & 0xFF00) >> 8;
                sir[2] = p & 0xFF;
                int n6 = r1;
                n = 0;
                n2 = Math.abs(i);
                rbs = n6 - n2;
                rsum += sir[0] * rbs;
                gsum += sir[1] * rbs;
                bsum += sir[2] * rbs;
                if (i > 0) {
                    rinsum += sir[0];
                    ginsum += sir[1];
                    binsum += sir[2];
                    continue;
                }
                routsum += sir[0];
                goutsum += sir[1];
                boutsum += sir[2];
            }
            stackpointer = radius;
            for (x = 0; x < w; ++x) {
                r[yi] = dv[rsum];
                g[yi] = dv[gsum];
                b[yi] = dv[bsum];
                rsum -= routsum;
                gsum -= goutsum;
                bsum -= boutsum;
                stackstart = stackpointer - radius + div;
                sir = stack[stackstart % div];
                routsum -= sir[0];
                goutsum -= sir[1];
                boutsum -= sir[2];
                if (y == 0) {
                    n = x + radius + 1;
                    n2 = x;
                    int[] nArray = vmin;
                    bl = false;
                    nArray[n2] = n5 = Math.min(n, wm);
                }
                p = pix[yw + vmin[x]];
                sir[0] = (p & 0xFF0000) >> 16;
                sir[1] = (p & 0xFF00) >> 8;
                sir[2] = p & 0xFF;
                rsum += (rinsum += sir[0]);
                gsum += (ginsum += sir[1]);
                bsum += (binsum += sir[2]);
                stackpointer = (stackpointer + 1) % div;
                sir = stack[stackpointer % div];
                routsum += sir[0];
                goutsum += sir[1];
                boutsum += sir[2];
                rinsum -= sir[0];
                ginsum -= sir[1];
                binsum -= sir[2];
                ++yi;
            }
            yw += w;
        }
        for (x = 0; x < w; ++x) {
            rinsum = ginsum = (binsum = (routsum = (goutsum = (boutsum = (rsum = (gsum = (bsum = 0)))))));
            yp = -radius * w;
            for (i = -radius; i <= radius; ++i) {
                n = 0;
                bl = false;
                yi = Math.max(n, yp) + x;
                sir = stack[i + radius];
                sir[0] = r[yi];
                sir[1] = g[yi];
                sir[2] = b[yi];
                int n7 = r1;
                n = 0;
                n2 = Math.abs(i);
                rbs = n7 - n2;
                rsum += r[yi] * rbs;
                gsum += g[yi] * rbs;
                bsum += b[yi] * rbs;
                if (i > 0) {
                    rinsum += sir[0];
                    ginsum += sir[1];
                    binsum += sir[2];
                } else {
                    routsum += sir[0];
                    goutsum += sir[1];
                    boutsum += sir[2];
                }
                if (i >= hm) continue;
                yp += w;
            }
            yi = x;
            stackpointer = radius;
            for (y = 0; y < h; ++y) {
                pix[yi] = 0xFF000000 & pix[yi] | dv[rsum] << 16 | dv[gsum] << 8 | dv[bsum];
                rsum -= routsum;
                gsum -= goutsum;
                bsum -= boutsum;
                stackstart = stackpointer - radius + div;
                sir = stack[stackstart % div];
                routsum -= sir[0];
                goutsum -= sir[1];
                boutsum -= sir[2];
                if (x == 0) {
                    n = y + r1;
                    n2 = y;
                    int[] nArray = vmin;
                    bl = false;
                    int n8 = Math.min(n, hm);
                    nArray[n2] = n8 * w;
                }
                p = x + vmin[y];
                sir[0] = r[p];
                sir[1] = g[p];
                sir[2] = b[p];
                rsum += (rinsum += sir[0]);
                gsum += (ginsum += sir[1]);
                bsum += (binsum += sir[2]);
                stackpointer = (stackpointer + 1) % div;
                sir = stack[stackpointer];
                routsum += sir[0];
                goutsum += sir[1];
                boutsum += sir[2];
                rinsum -= sir[0];
                ginsum -= sir[1];
                binsum -= sir[2];
                yi += w;
            }
        }
        ret.setPixels(pix, 0, w, 0, 0, w, h);
        return ret;
    }

    private TBlurTool() {
    }

    static {
        TBlurTool tBlurTool;
        INSTANCE = tBlurTool = new TBlurTool();
    }
}

